/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.ex.util.LimitedRangeHighlighterIterator;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexerEditorHighlighter
extends LexerEditorHighlighter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter");
    private final Map<IElementType, LayerDescriptor> myTokensToLayer;
    private final Map<LayerDescriptor, Mapper> myLayerBuffers;

    public LayeredLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme) {
        if (highlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(0);
        }
        if (scheme == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(1);
        }
        super(highlighter, scheme);
        this.myTokensToLayer = new HashMap<IElementType, LayerDescriptor>();
        this.myLayerBuffers = new HashMap<LayerDescriptor, Mapper>();
    }

    @Override
    @NotNull
    protected SegmentArrayWithData createSegments() {
        MappingSegments mappingSegments = new MappingSegments(this.createStorage());
        if (mappingSegments == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(2);
        }
        return mappingSegments;
    }

    public synchronized void registerLayer(@NotNull IElementType tokenType, @NotNull LayerDescriptor layerHighlighter) {
        if (tokenType == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(3);
        }
        if (layerHighlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(4);
        }
        this.myTokensToLayer.put(tokenType, layerHighlighter);
        this.getSegments().removeAll();
    }

    public synchronized void unregisterLayer(@NotNull IElementType tokenType) {
        LayerDescriptor layer;
        if (tokenType == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(5);
        }
        if ((layer = this.myTokensToLayer.remove(tokenType)) != null) {
            this.myLayerBuffers.remove(layer);
            this.getSegments().removeAll();
        }
    }

    @Override
    @NotNull
    public MappingSegments getSegments() {
        MappingSegments mappingSegments = (MappingSegments)super.getSegments();
        if (mappingSegments == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(6);
        }
        return mappingSegments;
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(7);
        }
        if (this.updateLayers()) {
            this.resetText(text2);
        } else {
            super.setText(text2);
        }
    }

    @Override
    @NotNull
    protected LexerEditorHighlighter.TokenProcessor createTokenProcessor(final int startIndex) {
        LexerEditorHighlighter.TokenProcessor tokenProcessor = new LexerEditorHighlighter.TokenProcessor(){
            final Map<Mapper, LightMapper> docTexts;
            {
                super(LayeredLexerEditorHighlighter.this);
                this.docTexts = FactoryMap.create(key -> {
                    MappedRange predecessor = ((Mapper)key).findPredecessor(startIndex);
                    return new LightMapper((Mapper)key, predecessor != null ? predecessor.range.getEndOffset() : 0);
                });
            }

            @Override
            public void addToken(int i, int startOffset, int endOffset, int data, @NotNull IElementType tokenType) {
                if (tokenType == null) {
                    1.$$$reportNull$$$0(0);
                }
                LayeredLexerEditorHighlighter.this.getSegments().setElementLight(i, startOffset, endOffset, data);
                Mapper mapper = LayeredLexerEditorHighlighter.this.getMappingDocument(tokenType);
                if (mapper != null) {
                    this.docTexts.get(mapper).addToken(LayeredLexerEditorHighlighter.this.myText.subSequence(startOffset, endOffset), tokenType, i);
                }
            }

            @Override
            public void finish() {
                for (LightMapper mapper : this.docTexts.values()) {
                    mapper.finish();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$1", "addToken"));
            }
        };
        if (tokenProcessor == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(8);
        }
        return tokenProcessor;
    }

    protected boolean updateLayers() {
        return false;
    }

    protected boolean updateLayers(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(9);
        }
        return this.updateLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(10);
        }
        boolean changed = this.updateLayers(e);
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            if (changed) {
                super.setText(e.getDocument().getImmutableCharSequence());
            } else {
                super.documentChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        // MONITORENTER : layeredLexerEditorHighlighter
        LayeredHighlighterIteratorImpl layeredHighlighterIteratorImpl = new LayeredHighlighterIteratorImpl(startOffset);
        // MONITOREXIT : layeredLexerEditorHighlighter
        if (layeredHighlighterIteratorImpl != null) return layeredHighlighterIteratorImpl;
        LayeredLexerEditorHighlighter.$$$reportNull$$$0(11);
        return layeredHighlighterIteratorImpl;
    }

    @NotNull
    public HighlighterIterator createBaseIterator(int startOffset) {
        HighlighterIterator highlighterIterator = super.createIterator(startOffset);
        if (highlighterIterator == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(12);
        }
        return highlighterIterator;
    }

    @Nullable
    private Mapper getMappingDocument(@NotNull IElementType token) {
        LayerDescriptor descriptor2;
        if (token == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(13);
        }
        if ((descriptor2 = this.myTokensToLayer.get(token)) == null) {
            return null;
        }
        Mapper mapper = this.myLayerBuffers.get(descriptor2);
        if (mapper == null) {
            mapper = new Mapper(descriptor2);
            this.myLayerBuffers.put(descriptor2, mapper);
        }
        return mapper;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(14);
        }
        super.setColorScheme(scheme);
        for (MappedRange mapping : this.getSegments().myRanges) {
            Mapper mapper;
            Mapper mapper2 = mapper = mapping == null ? null : mapping.mapper;
            if (mapper == null) continue;
            mapper.resetCachedTextAttributes();
        }
    }

    @Override
    protected boolean hasAdditionalData(int segmentIndex) {
        return this.getSegments().myRanges[segmentIndex] != null;
    }

    @NotNull
    private static MappedRange[] reallocateArray(@NotNull MappedRange[] array, int index) {
        if (array == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(15);
        }
        if (index < array.length) {
            if (array == null) {
                LayeredLexerEditorHighlighter.$$$reportNull$$$0(16);
            }
            return array;
        }
        MappedRange[] mappedRangeArray = (MappedRange[])ArrayUtil.realloc((Object[])array, (int)SegmentArray.calcCapacity(array.length, index), MappedRange[]::new);
        if (mappedRangeArray == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(17);
        }
        return mappedRangeArray;
    }

    @Override
    public String toString() {
        return this.myText.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layerHighlighter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSegments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokenProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseIterator";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerLayer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLayer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateLayers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMappingDocument";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setColorScheme";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LayeredHighlighterIteratorImpl
    implements LayeredHighlighterIterator {
        private final HighlighterIterator myBaseIterator;
        private HighlighterIterator myLayerIterator;
        private int myLayerStartOffset;
        private Mapper myCurrentMapper;

        private LayeredHighlighterIteratorImpl(int offset) {
            this.myBaseIterator = LayeredLexerEditorHighlighter.this.createBaseIterator(offset);
            if (!this.myBaseIterator.atEnd()) {
                int shift = offset - this.myBaseIterator.getStart();
                this.initLayer(shift);
            }
        }

        private void initLayer(int shiftInToken) {
            if (this.myBaseIterator.atEnd()) {
                this.myLayerIterator = null;
                this.myCurrentMapper = null;
                return;
            }
            MappedRange mapping = LayeredLexerEditorHighlighter.this.getSegments().myRanges[((LexerEditorHighlighter.HighlighterIteratorImpl)this.myBaseIterator).currentIndex()];
            if (mapping != null) {
                this.myCurrentMapper = mapping.mapper;
                this.myLayerIterator = this.myCurrentMapper.createIterator(mapping, shiftInToken);
                this.myLayerStartOffset = this.myBaseIterator.getStart() - mapping.range.getStartOffset();
            } else {
                this.myCurrentMapper = null;
                this.myLayerIterator = null;
            }
        }

        public TextAttributes getTextAttributes() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.getAttributes(this.getTokenType());
            }
            return this.myBaseIterator.getTextAttributes();
        }

        @Override
        @NotNull
        public SyntaxHighlighter getActiveSyntaxHighlighter() {
            if (this.myCurrentMapper != null) {
                SyntaxHighlighter syntaxHighlighter = this.myCurrentMapper.mySyntaxHighlighter;
                if (syntaxHighlighter == null) {
                    LayeredHighlighterIteratorImpl.$$$reportNull$$$0(0);
                }
                return syntaxHighlighter;
            }
            SyntaxHighlighter syntaxHighlighter = LayeredLexerEditorHighlighter.this.getSyntaxHighlighter();
            if (syntaxHighlighter == null) {
                LayeredHighlighterIteratorImpl.$$$reportNull$$$0(1);
            }
            return syntaxHighlighter;
        }

        public int getStart() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getStart() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getStart();
        }

        public int getEnd() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getEnd() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getEnd();
        }

        public IElementType getTokenType() {
            return this.myLayerIterator != null ? this.myLayerIterator.getTokenType() : this.myBaseIterator.getTokenType();
        }

        public void advance() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.advance();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.advance();
            this.initLayer(0);
        }

        public void retreat() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.retreat();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.retreat();
            this.initLayer(this.myBaseIterator.atEnd() ? 0 : this.myBaseIterator.getEnd() - this.myBaseIterator.getStart() - 1);
        }

        public boolean atEnd() {
            return this.myBaseIterator.atEnd();
        }

        public Document getDocument() {
            return this.myBaseIterator.getDocument();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LayeredHighlighterIteratorImpl", "getActiveSyntaxHighlighter"));
        }
    }

    private static class MappedRange {
        private RangeMarker range;
        private final Mapper mapper;
        private final IElementType outerToken;

        MappedRange(@NotNull Mapper mapper, @NotNull RangeMarker range2, @NotNull IElementType outerToken) {
            if (mapper == null) {
                MappedRange.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                MappedRange.$$$reportNull$$$0(1);
            }
            if (outerToken == null) {
                MappedRange.$$$reportNull$$$0(2);
            }
            this.mapper = mapper;
            this.range = range2;
            this.outerToken = outerToken;
            assert (mapper.doc == range2.getDocument());
        }

        public String toString() {
            return "MappedRange{range=" + this.range + ", outerToken=" + this.outerToken + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outerToken";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappedRange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class Mapper
    implements HighlighterClient {
        private final DocumentImpl doc;
        private final EditorHighlighter highlighter;
        private final String mySeparator;
        private final Map<IElementType, TextAttributes> myAttributesMap;
        @NotNull
        private final SyntaxHighlighter mySyntaxHighlighter;
        private final TextAttributesKey myBackground;

        private Mapper(LayerDescriptor descriptor2) {
            if (descriptor2 == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            this.myAttributesMap = new HashMap<IElementType, TextAttributes>();
            this.doc = new DocumentImpl("", true);
            this.mySyntaxHighlighter = descriptor2.getLayerHighlighter();
            this.myBackground = descriptor2.getBackgroundKey();
            this.highlighter = new LexerEditorHighlighter(this.mySyntaxHighlighter, LayeredLexerEditorHighlighter.this.getScheme());
            this.mySeparator = descriptor2.getTokenSeparator();
            this.highlighter.setEditor((HighlighterClient)this);
            this.doc.addDocumentListener((DocumentListener)this.highlighter);
        }

        @NotNull
        public TextAttributes getAttributes(IElementType tokenType) {
            TextAttributes attrs = this.myAttributesMap.get(tokenType);
            if (attrs == null) {
                attrs = LayeredLexerEditorHighlighter.this.convertAttributes(SyntaxHighlighterBase.pack((TextAttributesKey)this.myBackground, (TextAttributesKey[])this.mySyntaxHighlighter.getTokenHighlights(tokenType)));
                this.myAttributesMap.put(tokenType, attrs);
            }
            TextAttributes textAttributes = attrs;
            if (textAttributes == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            return textAttributes;
        }

        @NotNull
        public HighlighterIterator createIterator(@NotNull MappedRange mapper, int shift) {
            if (mapper == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            int rangeStart = mapper.range.getStartOffset();
            int rangeEnd = mapper.range.getEndOffset();
            LimitedRangeHighlighterIterator limitedRangeHighlighterIterator = new LimitedRangeHighlighterIterator(this.highlighter.createIterator(rangeStart + shift), rangeStart, rangeEnd);
            if (limitedRangeHighlighterIterator == null) {
                Mapper.$$$reportNull$$$0(3);
            }
            return limitedRangeHighlighterIterator;
        }

        public Project getProject() {
            return LayeredLexerEditorHighlighter.this.getClient().getProject();
        }

        public void repaint(int start2, int end) {
        }

        public Document getDocument() {
            return LayeredLexerEditorHighlighter.this.getDocument();
        }

        void resetCachedTextAttributes() {
            this.myAttributesMap.clear();
        }

        void updateMapping(int tokenIndex, @NotNull MappedRange oldMapping) {
            if (oldMapping == null) {
                Mapper.$$$reportNull$$$0(4);
            }
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int start2 = oldMapping.range.getStartOffset();
            int end = oldMapping.range.getEndOffset();
            if (Comparing.equal((CharSequence)this.doc.getCharsSequence().subSequence(start2, end), (CharSequence)tokenText)) {
                return;
            }
            this.doc.replaceString(start2, end, tokenText);
            int newEnd = start2 + tokenText.length();
            if (oldMapping.range.getStartOffset() != start2 || oldMapping.range.getEndOffset() != newEnd) {
                assert (oldMapping.range.getDocument() == this.doc);
                oldMapping.range.dispose();
                oldMapping.range = this.doc.createRangeMarker(start2, newEnd);
            }
        }

        @NotNull
        private MappedRange insertMapping(int tokenIndex, @NotNull IElementType outerToken) {
            if (outerToken == null) {
                Mapper.$$$reportNull$$$0(5);
            }
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int length = tokenText.length();
            MappedRange predecessor = this.findPredecessor(tokenIndex);
            int insertOffset = predecessor != null ? predecessor.range.getEndOffset() : 0;
            this.doc.insertString(insertOffset, (CharSequence)new MergingCharSequence((CharSequence)this.mySeparator, tokenText));
            RangeMarker marker = this.doc.createRangeMarker(insertOffset += this.mySeparator.length(), insertOffset + length);
            MappedRange mappedRange = new MappedRange(this, marker, outerToken);
            if (mappedRange == null) {
                Mapper.$$$reportNull$$$0(6);
            }
            return mappedRange;
        }

        @NotNull
        private CharSequence getTokenText(int tokenIndex) {
            CharSequence charSequence = LayeredLexerEditorHighlighter.this.myText.subSequence(LayeredLexerEditorHighlighter.this.getSegments().getSegmentStart(tokenIndex), LayeredLexerEditorHighlighter.this.getSegments().getSegmentEnd(tokenIndex));
            if (charSequence == null) {
                Mapper.$$$reportNull$$$0(7);
            }
            return charSequence;
        }

        @Nullable
        private MappedRange findPredecessor(int token) {
            --token;
            while (token >= 0) {
                MappedRange mappedRange = LayeredLexerEditorHighlighter.this.getSegments().myRanges[token];
                if (mappedRange != null && mappedRange.mapper == this) {
                    return mappedRange;
                }
                --token;
            }
            return null;
        }

        private void removeMapping(@NotNull MappedRange mapping) {
            RangeMarker rangeMarker;
            if (mapping == null) {
                Mapper.$$$reportNull$$$0(8);
            }
            if ((rangeMarker = mapping.range).isValid()) {
                int start2 = rangeMarker.getStartOffset();
                int end = rangeMarker.getEndOffset();
                assert (this.doc == rangeMarker.getDocument());
                this.doc.deleteString(start2 - this.mySeparator.length(), end);
                rangeMarker.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldMapping";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerToken";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIterator";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insertMapping";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateMapping";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insertMapping";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "removeMapping";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MappingSegments
    extends SegmentArrayWithData {
        private MappedRange[] myRanges;

        private MappingSegments(DataStorage o) {
            super(o);
            this.myRanges = new MappedRange[64];
        }

        @Override
        public void removeAll() {
            if (this.mySegmentCount != 0) {
                Arrays.fill(this.myRanges, null);
            }
            LayeredLexerEditorHighlighter.this.myLayerBuffers.clear();
            super.removeAll();
        }

        @Override
        public void setElementAt(int i, int startOffset, int endOffset, int data) {
            this.setElementLight(i, startOffset, endOffset, data);
            MappedRange range2 = this.myRanges[i];
            if (range2 != null) {
                range2.mapper.removeMapping(range2);
                this.myRanges[i] = null;
            }
            this.updateMappingForToken(i);
        }

        private void setElementLight(int i, int startOffset, int endOffset, int data) {
            super.setElementAt(i, startOffset, endOffset, data);
            this.myRanges = LayeredLexerEditorHighlighter.reallocateArray(this.myRanges, i + 1);
        }

        @Override
        public void remove(int startIndex, int endIndex) {
            Map mins = FactoryMap.create(key -> Integer.MAX_VALUE);
            Map maxs = FactoryMap.create(key -> 0);
            for (int i = startIndex; i < endIndex; ++i) {
                MappedRange range2 = this.myRanges[i];
                if (range2 != null && range2.range.isValid()) {
                    mins.put(range2.mapper, Math.min((Integer)mins.get(range2.mapper), range2.range.getStartOffset()));
                    maxs.put(range2.mapper, Math.max((Integer)maxs.get(range2.mapper), range2.range.getEndOffset()));
                }
                this.myRanges[i] = null;
            }
            for (Map.Entry entry : maxs.entrySet()) {
                Mapper mapper = (Mapper)entry.getKey();
                mapper.doc.deleteString((Integer)mins.get(mapper), (Integer)entry.getValue());
            }
            this.removeRange(this.myRanges, startIndex, endIndex);
            super.remove(startIndex, endIndex);
        }

        @Override
        public void replace(int startOffset, @NotNull SegmentArrayWithData data, int len) {
            if (data == null) {
                MappingSegments.$$$reportNull$$$0(0);
            }
            super.replace(startOffset, data, len);
            for (int i = startOffset; i < startOffset + len; ++i) {
                this.updateMappingForToken(i);
            }
        }

        @NotNull
        private MappedRange[] insert(@NotNull MappedRange[] array, @NotNull MappedRange[] insertArray, int startIndex, int insertLength) {
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(1);
            }
            if (insertArray == null) {
                MappingSegments.$$$reportNull$$$0(2);
            }
            MappedRange[] newArray = LayeredLexerEditorHighlighter.reallocateArray(array, this.mySegmentCount + insertLength);
            if (startIndex < this.mySegmentCount) {
                System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
            }
            System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
            if (newArray == null) {
                MappingSegments.$$$reportNull$$$0(3);
            }
            return newArray;
        }

        private <T> void removeRange(@NotNull T[] array, int startIndex, int endIndex) {
            if (array == null) {
                MappingSegments.$$$reportNull$$$0(4);
            }
            if (endIndex < this.mySegmentCount) {
                System.arraycopy(array, endIndex, array, startIndex, this.mySegmentCount - endIndex);
            }
            Arrays.fill(array, this.mySegmentCount - (endIndex - startIndex), this.mySegmentCount, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
            if (segmentArray == null) {
                MappingSegments.$$$reportNull$$$0(5);
            }
            LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = LayeredLexerEditorHighlighter.this;
            synchronized (layeredLexerEditorHighlighter) {
                super.insert(segmentArray, startIndex);
                int newCount = segmentArray.getSegmentCount();
                MappedRange[] newRanges = new MappedRange[newCount];
                this.myRanges = this.insert(this.myRanges, newRanges, startIndex, newCount);
                int endIndex = startIndex + segmentArray.getSegmentCount();
                LexerEditorHighlighter.TokenProcessor processor2 = LayeredLexerEditorHighlighter.this.createTokenProcessor(startIndex);
                for (int i = startIndex; i < endIndex; ++i) {
                    int data = this.getSegmentData(i);
                    IElementType token = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data);
                    processor2.addToken(i, this.getSegmentStart(i), this.getSegmentEnd(i), data, token);
                }
                processor2.finish();
            }
        }

        private void updateMappingForToken(int i) {
            int data = this.getSegmentData(i);
            IElementType token = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data);
            Mapper mapper = LayeredLexerEditorHighlighter.this.getMappingDocument(token);
            MappedRange oldMapping = this.myRanges[i];
            if (mapper != null) {
                if (oldMapping != null) {
                    if (oldMapping.mapper == mapper && oldMapping.outerToken == token) {
                        mapper.updateMapping(i, oldMapping);
                    } else {
                        oldMapping.mapper.removeMapping(oldMapping);
                        this.myRanges[i] = mapper.insertMapping(i, token);
                    }
                } else {
                    this.myRanges[i] = mapper.insertMapping(i, token);
                }
            } else if (oldMapping != null) {
                oldMapping.mapper.removeMapping(oldMapping);
                this.myRanges[i] = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertArray";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segmentArray";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 1: 
                case 2: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRange";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class LightMapper {
        final Mapper mapper;
        final StringBuilder text;
        final IntArrayList lengths;
        final List<IElementType> tokenTypes;
        final TIntIntHashMap index2Global;
        private final String mySeparator;
        final int insertOffset;

        LightMapper(Mapper mapper, int insertOffset) {
            if (mapper == null) {
                LightMapper.$$$reportNull$$$0(0);
            }
            this.text = new StringBuilder();
            this.lengths = new IntArrayList();
            this.tokenTypes = new ArrayList<IElementType>();
            this.index2Global = new TIntIntHashMap();
            this.mapper = mapper;
            this.mySeparator = mapper.mySeparator;
            this.insertOffset = insertOffset;
        }

        void addToken(@NotNull CharSequence tokenText, @NotNull IElementType tokenType, int globalIndex) {
            if (tokenText == null) {
                LightMapper.$$$reportNull$$$0(1);
            }
            if (tokenType == null) {
                LightMapper.$$$reportNull$$$0(2);
            }
            this.index2Global.put(this.tokenTypes.size(), globalIndex);
            this.text.append(this.mySeparator).append(tokenText);
            this.lengths.add(tokenText.length());
            this.tokenTypes.add(tokenType);
        }

        void finish() {
            assert (this.insertOffset >= 0);
            DocumentImpl document = this.mapper.doc;
            document.insertString(this.insertOffset, this.text);
            int start2 = this.insertOffset;
            for (int i = 0; i < this.tokenTypes.size(); ++i) {
                IElementType type = this.tokenTypes.get(i);
                int len = this.lengths.get(i);
                int globalIndex = this.index2Global.get(i);
                MappedRange[] ranges2 = LayeredLexerEditorHighlighter.this.getSegments().myRanges;
                this.checkNull(type, ranges2[globalIndex]);
                ranges2[globalIndex] = new MappedRange(this.mapper, document.createRangeMarker(start2 += this.mySeparator.length(), start2 + len), type);
                start2 += len;
            }
        }

        private void checkNull(@NotNull IElementType type, @Nullable MappedRange range2) {
            if (type == null) {
                LightMapper.$$$reportNull$$$0(3);
            }
            if (range2 != null) {
                Document mainDocument = LayeredLexerEditorHighlighter.this.getDocument();
                VirtualFile file2 = mainDocument == null ? null : FileDocumentManager.getInstance().getFile(mainDocument);
                LOG.error("Expected null range on " + type + ", found " + range2 + "; highlighter=" + LayeredLexerEditorHighlighter.this.getSyntaxHighlighter(), new Attachment[]{new Attachment(file2 != null ? file2.getName() : "editorText.txt", LayeredLexerEditorHighlighter.this.myText.toString())});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LightMapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToken";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

