/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.textarea.TextComponentDocument;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public class TextAreaDocument
extends TextComponentDocument {
    private final JTextArea myTextArea;

    public TextAreaDocument(JTextArea textComponent) {
        super(textComponent);
        this.myTextArea = textComponent;
    }

    @Override
    public int getLineCount() {
        return this.myTextArea.getLineCount();
    }

    @Override
    public int getLineNumber(int offset) {
        try {
            return this.myTextArea.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getLineStartOffset(int line2) {
        try {
            return this.myTextArea.getLineStartOffset(line2);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getLineEndOffset(int line2) {
        try {
            return this.myTextArea.getLineEndOffset(line2) - this.getLineSeparatorLength(line2);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLineSeparatorLength(int line2) {
        if (line2 == this.myTextArea.getLineCount() - 1) {
            return 0;
        }
        try {
            int l = 0;
            String text2 = this.getText();
            for (int pos = this.myTextArea.getLineEndOffset(line2) - 1; pos >= this.myTextArea.getLineStartOffset(line2) && (text2.charAt(pos) == '\r' || text2.charAt(pos) == '\n'); --pos) {
                ++l;
            }
            return l;
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }
}

