/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FileEditorOpenOptions {
    private boolean myCurrentTab = false;
    private boolean myFocusEditor = false;
    private Boolean myPin = null;
    private int myIndex = -1;
    private boolean myExactState = false;
    private boolean myReopeningEditorsOnStartup = false;

    public FileEditorOpenOptions withCurrentTab(boolean current) {
        this.myCurrentTab = current;
        return this;
    }

    public FileEditorOpenOptions withFocusEditor(boolean focusEditor) {
        this.myFocusEditor = focusEditor;
        return this;
    }

    public FileEditorOpenOptions withPin(Boolean pin) {
        this.myPin = pin;
        return this;
    }

    public FileEditorOpenOptions withIndex(int index) {
        this.myIndex = index;
        return this;
    }

    public FileEditorOpenOptions withExactState() {
        this.myExactState = true;
        return this;
    }

    public FileEditorOpenOptions withReopeningEditorsOnStartup() {
        this.myReopeningEditorsOnStartup = true;
        return this;
    }

    public boolean isCurrentTab() {
        return this.myCurrentTab;
    }

    public boolean isFocusEditor() {
        return this.myFocusEditor;
    }

    public Boolean getPin() {
        return this.myPin;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public boolean isExactState() {
        return this.myExactState;
    }

    public boolean isReopeningEditorsOnStartup() {
        return this.myReopeningEditorsOnStartup;
    }
}

