/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.TestEditorSplitter;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

final class TestEditorManagerImpl
extends FileEditorManagerEx
implements Disposable {
    private static final Logger LOG = Logger.getInstance(TestEditorManagerImpl.class);
    private final TestEditorSplitter myTestEditorSplitter;
    private final Project myProject;
    private int counter;
    private final Map<VirtualFile, Editor> myVirtualFile2Editor;
    private VirtualFile myActiveFile;
    private static final LightVirtualFile LIGHT_VIRTUAL_FILE = new LightVirtualFile("Dummy.java");

    TestEditorManagerImpl(@NotNull Project project) {
        if (project == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(0);
        }
        this.myTestEditorSplitter = new TestEditorSplitter();
        this.counter = 0;
        this.myVirtualFile2Editor = new HashMap<VirtualFile, Editor>();
        this.myProject = project;
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == TestEditorManagerImpl.this.myProject) {
                    TestEditorManagerImpl.this.closeAllFiles();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "projectClosed"));
            }
        });
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                    for (VirtualFile file2 : TestEditorManagerImpl.this.getOpenFiles()) {
                        if (!VfsUtilCore.isAncestor((VirtualFile)((VFileDeleteEvent)vFileEvent).getFile(), (VirtualFile)file2, (boolean)false)) continue;
                        TestEditorManagerImpl.this.closeFile(file2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$2", "before"));
            }
        });
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(1);
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(new OpenFileDescriptor(this.myProject, file2), focusEditor)), "", null);
        Pair pair = (Pair)result2.get();
        if (pair == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(2);
        }
        return pair;
    }

    private Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(OpenFileDescriptor openFileDescriptor, boolean focusEditor) {
        Pair result2;
        VirtualFile file2 = openFileDescriptor.getFile();
        boolean isNewEditor = !this.myVirtualFile2Editor.containsKey(file2);
        FileEditorProvider provider = (FileEditorProvider)file2.getUserData(FileEditorProvider.KEY);
        if (provider != null && provider.accept(this.getProject(), file2)) {
            result2 = Pair.create((Object)new FileEditor[]{provider.createEditor(this.getProject(), file2)}, (Object)new FileEditorProvider[]{provider});
        } else {
            Editor editor = this.doOpenTextEditor(openFileDescriptor);
            TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
            FileEditorProvider fileEditorProvider = TestEditorManagerImpl.getProvider();
            result2 = Pair.create((Object)new FileEditor[]{fileEditor}, (Object)new FileEditorProvider[]{fileEditorProvider});
        }
        this.modifyTabWell(() -> {
            this.myTestEditorSplitter.openAndFocusTab(file2, ((FileEditor[])result2.first)[0], ((FileEditorProvider[])result2.second)[0]);
            if (isNewEditor) {
                this.eventPublisher().fileOpened((FileEditorManager)this, file2);
            }
        });
        return result2;
    }

    private void modifyTabWell(Runnable tabWellModification) {
        if (this.myProject.isDisposed()) {
            return;
        }
        FileEditor lastFocusedEditor = this.myTestEditorSplitter.getFocusedFileEditor();
        VirtualFile lastFocusedFile = this.myTestEditorSplitter.getFocusedFile();
        FileEditorProvider oldProvider = this.myTestEditorSplitter.getProviderFromFocused();
        tabWellModification.run();
        FileEditor currentlyFocusedEditor = this.myTestEditorSplitter.getFocusedFileEditor();
        VirtualFile currentlyFocusedFile = this.myTestEditorSplitter.getFocusedFile();
        FileEditorProvider newProvider = this.myTestEditorSplitter.getProviderFromFocused();
        FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, lastFocusedFile, lastFocusedEditor, oldProvider, currentlyFocusedFile, currentlyFocusedEditor, newProvider);
        this.eventPublisher().selectionChanged(event);
    }

    @NotNull
    private FileEditorManagerListener eventPublisher() {
        FileEditorManagerListener fileEditorManagerListener = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
        if (fileEditorManagerListener == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(3);
        }
        return fileEditorManagerListener;
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(4);
        }
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(5);
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileWithProviders(file2, focusEditor, false);
        if (pair == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(6);
        }
        return pair;
    }

    @Override
    public boolean isInsideChange() {
        return false;
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(7);
        }
        runnable2.run();
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(8);
        }
        return actionCallback;
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c2) {
        return null;
    }

    @Override
    public void createSplitter(int orientation, EditorWindow window) {
        String containerName = this.createNewTabbedContainerName();
        this.myTestEditorSplitter.setActiveTabGroup(containerName);
    }

    private String createNewTabbedContainerName() {
        ++this.counter;
        return "SplitTabContainer" + ((Object)this.counter).toString();
    }

    @Override
    public void changeSplitterOrientation() {
    }

    @Override
    public void flipTabs() {
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    @Override
    public boolean isInSplitter() {
        return false;
    }

    @Override
    public boolean hasOpenedFile() {
        return false;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.myActiveFile;
    }

    @Override
    public FileEditorWithProvider getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(12);
        }
        return null;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(13);
        }
        if (component == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(14);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(15);
        }
        if (component == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(16);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(17);
        }
        if (component == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(18);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(19);
        }
        if (component == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(20);
        }
    }

    @Override
    public void closeAllFiles() {
        for (VirtualFile file2 : this.getOpenFiles()) {
            this.closeFile(file2);
        }
    }

    private static FileEditorProvider getProvider() {
        return new FileEditorProvider(){

            public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
                if (project == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(1);
                }
                return false;
            }

            @NotNull
            public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
                if (project == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(3);
                }
                throw new IncorrectOperationException();
            }

            public void disposeEditor(@NotNull FileEditor editor) {
                if (editor == null) {
                    3.$$$reportNull$$$0(4);
                }
            }

            @NotNull
            public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file2) {
                if (sourceElement == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (project == null) {
                    3.$$$reportNull$$$0(6);
                }
                if (file2 == null) {
                    3.$$$reportNull$$$0(7);
                }
                throw new IncorrectOperationException();
            }

            @NotNull
            public String getEditorTypeId() {
                if ("" == null) {
                    3.$$$reportNull$$$0(8);
                }
                return "";
            }

            @NotNull
            public FileEditorPolicy getPolicy() {
                throw new IncorrectOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 8: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 8: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceElement";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$3";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEditorTypeId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "accept";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "createEditor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "disposeEditor";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "readState";
                        break;
                    }
                    case 8: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 8: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    public EditorWindow getCurrentWindow() {
        return null;
    }

    @Override
    @NotNull
    public Promise<EditorWindow> getActiveWindow() {
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(21);
        }
        return promise;
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        if (editor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(22);
        }
        return LIGHT_VIRTUAL_FILE;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(23);
        }
    }

    @Override
    public void unsplitWindow() {
    }

    @Override
    public void unsplitAllWindow() {
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        EditorWindow[] editorWindowArray = new EditorWindow[]{};
        if (editorWindowArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(24);
        }
        return editorWindowArray;
    }

    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        Editor editor;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(25);
        }
        if ((editor = this.getEditor(file2)) != null) {
            return TextEditorProvider.getInstance().getTextEditor(editor);
        }
        Pair<FileEditor, FileEditorProvider> editorAndProvider = this.myTestEditorSplitter.getEditorAndProvider(file2);
        if (editorAndProvider != null) {
            return (FileEditor)editorAndProvider.first;
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(26);
        }
        return this.getEditor(file2) != null;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file2) {
        FileEditor e;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(27);
        }
        if ((e = this.getSelectedEditor(file2)) == null) {
            FileEditor[] fileEditorArray = new FileEditor[]{};
            if (fileEditorArray == null) {
                TestEditorManagerImpl.$$$reportNull$$$0(28);
            }
            return fileEditorArray;
        }
        FileEditor[] fileEditorArray = new FileEditor[]{e};
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(29);
        }
        return fileEditorArray;
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(30);
        }
        FileEditor[] fileEditorArray = this.getEditors(file2);
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(31);
        }
        return fileEditorArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(32);
        }
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.closeAllFiles();
    }

    public void closeFile(@NotNull VirtualFile file2) {
        Editor editor;
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(33);
        }
        if ((editor = this.myVirtualFile2Editor.remove(file2)) != null) {
            TextEditorProvider editorProvider = TextEditorProvider.getInstance();
            editorProvider.disposeEditor((FileEditor)editorProvider.getTextEditor(editor));
            EditorFactory.getInstance().releaseEditor(editor);
            this.eventPublisher().fileClosed((FileEditorManager)this, file2);
        }
        if (Comparing.equal((Object)file2, (Object)this.myActiveFile)) {
            this.myActiveFile = null;
        }
        this.modifyTabWell(() -> this.myTestEditorSplitter.closeFile(file2));
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(34);
        }
        if (window == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(35);
        }
        this.closeFile(file2);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        if (this.myActiveFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = this.myActiveFile;
        }
        if (virtualFileArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(36);
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        FileEditor[] fileEditorArray = this.myActiveFile == null ? new FileEditor[]{} : this.getEditors(this.myActiveFile);
        if (fileEditorArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(37);
        }
        return fileEditorArray;
    }

    public Editor getSelectedTextEditor() {
        return this.myActiveFile != null ? this.getEditor(this.myActiveFile) : null;
    }

    @Override
    public JComponent getComponent() {
        return new JLabel();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.myVirtualFile2Editor.keySet());
        if (virtualFileArray == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(38);
        }
        return virtualFileArray;
    }

    public Editor getEditor(VirtualFile file2) {
        return this.myVirtualFile2Editor.get(file2);
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditor[] result2 = new FileEditor[this.myVirtualFile2Editor.size()];
        int i = 0;
        for (Map.Entry<VirtualFile, Editor> entry : this.myVirtualFile2Editor.entrySet()) {
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(entry.getValue());
            result2[i++] = textEditor;
        }
        if (result2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(39);
        }
        return result2;
    }

    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(40);
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(descriptor2, focusEditor)), "", null);
        Pair pair = (Pair)result2.get();
        for (FileEditor editor : (FileEditor[])pair.first) {
            if (!(editor instanceof TextEditor)) continue;
            return ((TextEditor)editor).getEditor();
        }
        return null;
    }

    @NotNull
    private Editor doOpenTextEditor(@NotNull OpenFileDescriptor descriptor2) {
        VirtualFile file2;
        Editor editor;
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(41);
        }
        if ((editor = this.myVirtualFile2Editor.get(file2 = descriptor2.getFile())) == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
            LOG.assertTrue(psiFile != null, (Object)file2);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            LOG.assertTrue(document != null, (Object)psiFile);
            editor = EditorFactory.getInstance().createEditor(document, this.myProject);
            EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)this.myProject, (VirtualFile)file2);
            Language language = TextEditorImpl.getDocumentLanguage(editor);
            editor.getSettings().setLanguage(language);
            ((EditorEx)editor).setHighlighter(highlighter);
            ((EditorEx)editor).setFile(file2);
            this.myVirtualFile2Editor.put(file2, editor);
        }
        editor.getSelectionModel().removeSelection();
        descriptor2.navigateIn(editor);
        this.myActiveFile = file2;
        Editor editor2 = editor;
        if (editor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(42);
        }
        return editor2;
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(43);
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(44);
        }
        if (parentDisposable == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(45);
        }
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(46);
        }
    }

    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(47);
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> result2.set(this.openFileImpl3(descriptor2, focusEditor)), "", null);
        List<Object> list2 = Arrays.asList((Object[])((Pair)result2.get()).first);
        if (list2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(48);
        }
        return list2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(49);
        }
        return project;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(50);
        }
        Pair<FileEditor, FileEditorProvider> editorAndProvider = this.myTestEditorSplitter.getEditorAndProvider(file2);
        FileEditor[] fileEditor = new FileEditor[]{};
        FileEditorProvider[] fileEditorProvider = new FileEditorProvider[]{};
        if (editorAndProvider != null) {
            fileEditor = new FileEditor[]{(FileEditor)editorAndProvider.first};
            fileEditorProvider = new FileEditorProvider[]{(FileEditorProvider)editorAndProvider.second};
        }
        Pair pair = Pair.create((Object)fileEditor, (Object)fileEditorProvider);
        if (pair == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(51);
        }
        return pair;
    }

    @Override
    public int getWindowSplitCount() {
        return 0;
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        return false;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        throw new IncorrectOperationException();
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(52);
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(53);
        }
        return actionCallback;
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        if (file2 == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(54);
        }
        if (fileEditorProviderId == null) {
            TestEditorManagerImpl.$$$reportNull$$$0(55);
        }
        if (this.myVirtualFile2Editor.containsKey(file2)) {
            this.modifyTabWell(() -> {
                this.myActiveFile = file2;
                this.myTestEditorSplitter.setFocusedFile(file2);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 40: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorProviderId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileWithProviders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "eventPublisher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyPublisher";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindows";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 31: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "doOpenTextEditor";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditor";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsWithProviders";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openFileWithProviders";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyPublisher";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditorWithProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNextWindow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPrevWindow";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTopComponent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeTopComponent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addBottomComponent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeBottomComponent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "updateFilePresentation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAllEditors";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSiblings";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "openTextEditor";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "doOpenTextEditor";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addFileEditorManagerListener";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "removeFileEditorManagerListener";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsWithProviders";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 21: 
            case 24: 
            case 28: 
            case 29: 
            case 31: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 51: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

