/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.progress.util.BlockingProgressIndicator;
import com.intellij.openapi.progress.util.ProgressDialog;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressWindow
extends ProgressIndicatorBase
implements BlockingProgressIndicator,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.progress.util.ProgressWindow");
    public static final int DEFAULT_PROGRESS_DIALOG_POSTPONE_TIME_MILLIS = 300;
    private ProgressDialog myDialog;
    final Project myProject;
    final boolean myShouldShowCancel;
    String myCancelText;
    private String myTitle;
    private boolean myStoppedAlready;
    protected boolean myBackgrounded;
    int myDelayInMillis = 300;
    private boolean myModalityEntered;
    public static final Topic<Listener> TOPIC = Topic.create((String)"progress window", Listener.class);

    public ProgressWindow(boolean shouldShowCancel, @Nullable Project project) {
        this(shouldShowCancel, false, project);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project) {
        this(shouldShowCancel, shouldShowBackground, project, null);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText) {
        this(shouldShowCancel, shouldShowBackground, project, null, cancelText);
    }

    public ProgressWindow(boolean shouldShowCancel, boolean shouldShowBackground, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText) {
        this.myProject = project;
        this.myShouldShowCancel = shouldShowCancel;
        this.myCancelText = cancelText;
        Window parentWindow = this.calcParentWindow(parentComponent);
        if (this.myProject != null) {
            Disposer.register((Disposable)this.myProject, (Disposable)this);
        }
        this.myDialog = new ProgressDialog(this, shouldShowBackground, cancelText, parentWindow);
        Disposer.register((Disposable)this, (Disposable)this.myDialog);
        this.setModalityProgress(shouldShowBackground ? null : this);
        this.addStateDelegate(new MyDelegate());
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).progressWindowCreated(this);
    }

    private Window calcParentWindow(@Nullable Component parent) {
        if (parent == null && this.myProject == null && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            parent = JOptionPane.getRootFrame();
        }
        if (parent != null) {
            return UIUtil.getWindow((Component)parent);
        }
        Window parentWindow = WindowManager.getInstance().suggestParentWindow(this.myProject);
        return parentWindow != null ? parentWindow : WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.isRunning());
            LOG.assertTrue(!this.myStoppedAlready);
            super.start();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.prepareShowDialog();
            }
        }
    }

    public void setDelayInMillis(int delayInMillis) {
        this.myDelayInMillis = delayInMillis;
    }

    protected void prepareShowDialog() {
        Timer timer2 = UIUtil.createNamedTimer((String)"Progress window timer", (int)this.myDelayInMillis, e -> ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isRunning()) {
                DialogWrapper popup2;
                if (this.myDialog != null && (popup2 = this.myDialog.myPopup) != null && popup2.isShowing()) {
                    this.myDialog.setWasShown();
                }
                this.showDialog();
            } else {
                Disposer.dispose((Disposable)this);
                IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
                focusManager.doWhenFocusSettlesDown(() -> focusManager.requestDefaultFocus(true), ModalityState.defaultModalityState());
            }
        }, this.getModalityState()));
        timer2.setRepeats(false);
        timer2.start();
    }

    final void enterModality() {
        if (this.isModalEntity() && !this.myModalityEntered) {
            LaterInvocator.enterModal(this, (ModalityStateEx)this.getModalityState());
            this.myModalityEntered = true;
        }
    }

    final void exitModality() {
        if (this.isModalEntity() && this.myModalityEntered) {
            this.myModalityEntered = false;
            LaterInvocator.leaveModal(this);
        }
    }

    @Override
    public void startBlocking() {
        this.startBlocking(EmptyRunnable.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlocking(@NotNull Runnable init) {
        if (init == null) {
            ProgressWindow.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.isRunning());
            LOG.assertTrue(!this.myStoppedAlready);
        }
        this.enterModality();
        init.run();
        try {
            IdeEventQueue.getInstance().pumpEventsForHierarchy(this.myDialog.myPanel, (Condition<? super AWTEvent>)((Condition)event -> {
                if (this.isCancellationEvent((AWTEvent)event)) {
                    this.cancel();
                }
                return this.wasStarted() && !this.isRunning();
            }));
        }
        finally {
            this.exitModality();
        }
    }

    final boolean isCancellationEvent(@Nullable AWTEvent event) {
        return this.myShouldShowCancel && event instanceof KeyEvent && event.getID() == 401 && ((KeyEvent)event).getKeyCode() == 27 && ((KeyEvent)event).getModifiers() == 0;
    }

    protected void showDialog() {
        if (!this.isRunning() || this.isCanceled()) {
            return;
        }
        this.myDialog.show();
        if (this.myDialog != null) {
            this.myDialog.myRepaintRunnable.run();
        }
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.getLock();
        synchronized (object) {
            LOG.assertTrue(!this.myStoppedAlready);
            super.stop();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (this.myDialog != null) {
                    this.myDialog.hide();
                }
                Object object = this.getLock();
                synchronized (object) {
                    this.myStoppedAlready = true;
                }
                Disposer.dispose((Disposable)this);
            });
            SwingUtilities.invokeLater(EmptyRunnable.INSTANCE);
        }
    }

    @Nullable
    protected ProgressDialog getDialog() {
        return this.myDialog;
    }

    public void background() {
        if (this.myDialog != null) {
            this.myBackgrounded = true;
            this.myDialog.background();
            this.myDialog = null;
        }
    }

    protected boolean isBackgrounded() {
        return this.myBackgrounded;
    }

    @Override
    public void setText(String text2) {
        if (!Comparing.equal((String)text2, (String)this.getText())) {
            super.setText(text2);
            this.update();
        }
    }

    @Override
    public void setFraction(double fraction) {
        if (fraction != this.getFraction()) {
            super.setFraction(fraction);
            this.update();
        }
    }

    @Override
    public void setText2(String text2) {
        if (!Comparing.equal((String)text2, (String)this.getText2())) {
            super.setText2(text2);
            this.update();
        }
    }

    private void update() {
        if (this.myDialog != null) {
            this.myDialog.update();
        }
    }

    public void setTitle(String title) {
        if (!Comparing.equal((String)title, (String)this.myTitle)) {
            this.myTitle = title;
            this.update();
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public void setCancelButtonText(@NotNull String text2) {
        if (text2 == null) {
            ProgressWindow.$$$reportNull$$$0(1);
        }
        if (this.myDialog != null) {
            this.myDialog.changeCancelButtonText(text2);
        } else {
            this.myCancelText = text2;
        }
    }

    IdeFocusManager getFocusManager() {
        return IdeFocusManager.getInstance((Project)this.myProject);
    }

    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.stopSystemActivity();
        if (this.isRunning()) {
            this.cancel();
        }
    }

    @Override
    public boolean isPopupWasShown() {
        return this.myDialog != null && this.myDialog.myPopup != null && this.myDialog.myPopup.isShowing();
    }

    private void enableCancelButton(boolean enable) {
        if (this.myDialog != null) {
            this.myDialog.enableCancelButtonIfNeeded(enable);
        }
    }

    @Override
    public String toString() {
        return this.getTitle() + " " + System.identityHashCode(this) + ": running=" + this.isRunning() + "; canceled=" + this.isCanceled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "init";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/progress/util/ProgressWindow";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startBlocking";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setCancelButtonText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDelegate
    extends AbstractProgressIndicatorBase
    implements ProgressIndicatorEx {
        private long myLastUpdatedButtonTimestamp;

        private MyDelegate() {
        }

        @Override
        public void cancel() {
            super.cancel();
            if (ProgressWindow.this.myDialog != null) {
                ProgressWindow.this.myDialog.cancel();
            }
        }

        @Override
        public void checkCanceled() {
            super.checkCanceled();
            long now = System.currentTimeMillis();
            if (now - this.myLastUpdatedButtonTimestamp > 10L) {
                ProgressWindow.this.enableCancelButton(!ProgressManager.getInstance().isInNonCancelableSection());
                this.myLastUpdatedButtonTimestamp = now;
            }
        }

        @Override
        public void addStateDelegate(@NotNull ProgressIndicatorEx delegate) {
            if (delegate == null) {
                MyDelegate.$$$reportNull$$$0(0);
            }
            throw new IncorrectOperationException();
        }

        @Override
        public void finish(@NotNull TaskInfo task2) {
            if (task2 == null) {
                MyDelegate.$$$reportNull$$$0(1);
            }
        }

        @Override
        public boolean isFinished(@NotNull TaskInfo task2) {
            if (task2 == null) {
                MyDelegate.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean wasStarted() {
            return false;
        }

        @Override
        public void processFinish() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/progress/util/ProgressWindow$MyDelegate";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addStateDelegate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "finish";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void progressWindowCreated(@NotNull ProgressWindow var1);
    }
}

