/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.LoadingPhase;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionId;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.ui.AppIcon;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbServiceImpl
extends DumbService
implements Disposable,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.project.DumbServiceImpl");
    private static final Set<String> REPORTED_EXECUTIONS = ContainerUtil.newConcurrentSet();
    private final AtomicReference<State> myState = new AtomicReference<State>(State.SMART);
    private volatile Throwable myDumbEnterTrace;
    private volatile Throwable myDumbStart;
    private volatile TransactionId myDumbStartTransaction;
    private final DumbService.DumbModeListener myPublisher;
    private long myModificationCount;
    private final Set<Object> myQueuedEquivalences = new HashSet<Object>();
    private final Queue<DumbModeTask> myUpdatesQueue = new Queue(5);
    private final Map<DumbModeTask, ProgressIndicatorEx> myProgresses = ContainerUtil.newConcurrentMap();
    private final Queue<Runnable> myRunWhenSmartQueue = new Queue(5);
    private final Project myProject;
    private final ThreadLocal<Integer> myAlternativeResolution = new ThreadLocal();
    private final StartupManager myStartupManager;
    private volatile ProgressSuspender myCurrentSuspender;
    private final List<String> myRequestedSuspensions = ContainerUtil.createEmptyCOWList();

    public DumbServiceImpl(Project project, StartupManager startupManager) {
        this.myProject = project;
        this.myPublisher = (DumbService.DumbModeListener)project.getMessageBus().syncPublisher(DUMB_MODE);
        this.myStartupManager = startupManager;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){
            final Stack<AccessToken> stack = new Stack();

            @Override
            public void batchChangeStarted(@NotNull Project project, @Nullable String activityName) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == DumbServiceImpl.this.myProject) {
                    this.stack.push(DumbServiceImpl.this.heavyActivityStarted(activityName != null ? UIUtil.removeMnemonic((String)activityName) : "file system changes"));
                }
            }

            @Override
            public void batchChangeCompleted(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (project != DumbServiceImpl.this.myProject) {
                    return;
                }
                Stack<AccessToken> tokens = this.stack;
                if (!tokens.isEmpty()) {
                    tokens.pop().finish();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/project/DumbServiceImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static DumbServiceImpl getInstance(@NotNull Project project) {
        if (project == null) {
            DumbServiceImpl.$$$reportNull$$$0(0);
        }
        return (DumbServiceImpl)DumbService.getInstance((Project)project);
    }

    public void cancelTask(@NotNull DumbModeTask task2) {
        ProgressIndicatorEx indicator;
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("cancel " + task2);
        }
        if ((indicator = this.myProgresses.get(task2)) != null) {
            indicator.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myUpdatesQueue.clear();
        this.myQueuedEquivalences.clear();
        Queue<Runnable> queue = this.myRunWhenSmartQueue;
        synchronized (queue) {
            this.myRunWhenSmartQueue.clear();
        }
        for (DumbModeTask task2 : new ArrayList<DumbModeTask>(this.myProgresses.keySet())) {
            this.cancelTask(task2);
            Disposer.dispose((Disposable)task2);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public boolean isAlternativeResolveEnabled() {
        return this.myAlternativeResolution.get() != null;
    }

    public void suspendIndexingAndRun(@NotNull String activityName, @NotNull Runnable activity) {
        if (activityName == null) {
            DumbServiceImpl.$$$reportNull$$$0(2);
        }
        if (activity == null) {
            DumbServiceImpl.$$$reportNull$$$0(3);
        }
        try (AccessToken ignore = this.heavyActivityStarted(activityName);){
            activity.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private AccessToken heavyActivityStarted(@NotNull String activityName) {
        if (activityName == null) {
            DumbServiceImpl.$$$reportNull$$$0(4);
        }
        final String reason = "Indexing paused due to " + activityName;
        List<String> list2 = this.myRequestedSuspensions;
        synchronized (list2) {
            this.myRequestedSuspensions.add(reason);
        }
        this.suspendCurrentTask(reason);
        AccessToken accessToken = new AccessToken(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finish() {
                List list2 = DumbServiceImpl.this.myRequestedSuspensions;
                synchronized (list2) {
                    DumbServiceImpl.this.myRequestedSuspensions.remove(reason);
                }
                DumbServiceImpl.this.resumeAutoSuspendedTask(reason);
            }
        };
        if (accessToken == null) {
            DumbServiceImpl.$$$reportNull$$$0(5);
        }
        return accessToken;
    }

    private void suspendCurrentTask(String reason) {
        ProgressSuspender currentSuspender = this.myCurrentSuspender;
        if (currentSuspender != null && !currentSuspender.isSuspended()) {
            currentSuspender.suspendProcess(reason);
        }
    }

    private void resumeAutoSuspendedTask(@NotNull String reason) {
        ProgressSuspender currentSuspender;
        if (reason == null) {
            DumbServiceImpl.$$$reportNull$$$0(6);
        }
        if ((currentSuspender = this.myCurrentSuspender) != null && currentSuspender.isSuspended() && reason.equals(currentSuspender.getSuspendedText())) {
            currentSuspender.resumeProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendIfRequested(ProgressSuspender suspender) {
        List<String> list2 = this.myRequestedSuspensions;
        synchronized (list2) {
            String suspendedReason = (String)ContainerUtil.getLastItem(this.myRequestedSuspensions);
            if (suspendedReason != null) {
                suspender.suspendProcess(suspendedReason);
            }
        }
    }

    public void setAlternativeResolveEnabled(boolean enabled) {
        Integer oldValue = this.myAlternativeResolution.get();
        int newValue = (oldValue == null ? 0 : oldValue) + (enabled ? 1 : -1);
        assert (newValue >= 0) : "Non-paired alternative resolution mode";
        this.myAlternativeResolution.set(newValue == 0 ? null : Integer.valueOf(newValue));
    }

    public ModificationTracker getModificationTracker() {
        return this;
    }

    public boolean isDumb() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed() && Registry.is((String)"ide.check.is.dumb.contract") && REPORTED_EXECUTIONS.add(ExceptionUtil.currentStackTrace())) {
            LOG.error("To avoid race conditions isDumb method should be used only under read action or in EDT thread.");
        }
        return this.myState.get() != State.SMART;
    }

    public void setDumb(boolean dumb) {
        if (dumb) {
            this.myState.set(State.RUNNING_DUMB_TASKS);
            this.myPublisher.enteredDumbMode();
        } else {
            this.myState.set(State.WAITING_FOR_FINISH);
            this.updateFinished();
        }
    }

    public void runWhenSmart(@Async.Schedule @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(7);
        }
        this.myStartupManager.runWhenProjectIsInitialized(() -> {
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                if (this.isDumb()) {
                    this.myRunWhenSmartQueue.addLast((Object)runnable2);
                    return;
                }
            }
            runnable2.run();
        });
    }

    public void queueTask(@NotNull DumbModeTask task2) {
        Application application;
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(8);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduling task " + task2);
        }
        if (this.myProject.isDefault()) {
            LOG.error("No indexing tasks should be created for default project: " + task2);
        }
        if ((application = ApplicationManager.getApplication()).isUnitTestMode() || application.isHeadlessEnvironment()) {
            DumbServiceImpl.runTaskSynchronously(task2);
        } else {
            this.queueAsynchronousTask(task2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runTaskSynchronously(@NotNull DumbModeTask task2) {
        ProgressIndicator indicator;
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(9);
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) == null) {
            indicator = new EmptyProgressIndicator();
        }
        indicator.pushState();
        ((CoreProgressManager)ProgressManager.getInstance()).suppressPrioritizing();
        try (AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing task");){
            task2.performInDumbMode(indicator);
        }
        finally {
            ((CoreProgressManager)ProgressManager.getInstance()).restorePrioritizing();
            indicator.popState();
            Disposer.dispose((Disposable)task2);
        }
    }

    @VisibleForTesting
    void queueAsynchronousTask(@NotNull DumbModeTask task2) {
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(10);
        }
        Throwable trace = new Throwable();
        TransactionId contextTransaction = TransactionGuard.getInstance().getContextTransaction();
        Runnable runnable2 = () -> this.queueTaskOnEdt(task2, contextTransaction, trace);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable2.run();
        } else {
            TransactionGuard.submitTransaction((Disposable)this.myProject, (Runnable)runnable2);
        }
    }

    private void queueTaskOnEdt(@NotNull DumbModeTask task2, @Nullable TransactionId contextTransaction, @NotNull Throwable trace) {
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(11);
        }
        if (trace == null) {
            DumbServiceImpl.$$$reportNull$$$0(12);
        }
        if (!this.addTaskToQueue(task2)) {
            return;
        }
        if (this.myState.get() == State.SMART || this.myState.get() == State.WAITING_FOR_FINISH) {
            this.enterDumbMode(contextTransaction, trace);
            ApplicationManager.getApplication().invokeLater(this::startBackgroundProcess, this.myProject.getDisposed());
        }
    }

    private boolean addTaskToQueue(@NotNull DumbModeTask task2) {
        if (task2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(13);
        }
        if (!this.myQueuedEquivalences.add(task2.getEquivalenceObject())) {
            Disposer.dispose((Disposable)task2);
            return false;
        }
        this.myProgresses.put(task2, new ProgressIndicatorBase());
        Disposer.register((Disposable)task2, () -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myProgresses.remove(task2);
        });
        this.myUpdatesQueue.addLast((Object)task2);
        return true;
    }

    private void enterDumbMode(@Nullable TransactionId contextTransaction, @NotNull Throwable trace) {
        if (trace == null) {
            DumbServiceImpl.$$$reportNull$$$0(14);
        }
        boolean wasSmart = !this.isDumb();
        WriteAction.run(() -> {
            Queue<Runnable> queue = this.myRunWhenSmartQueue;
            synchronized (queue) {
                this.myState.set(State.SCHEDULED_TASKS);
            }
            this.myDumbStart = trace;
            this.myDumbEnterTrace = new Throwable();
            this.myDumbStartTransaction = contextTransaction;
            ++this.myModificationCount;
        });
        if (wasSmart) {
            try {
                this.myPublisher.enteredDumbMode();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private void queueUpdateFinished() {
        if (this.myState.compareAndSet(State.RUNNING_DUMB_TASKS, State.WAITING_FOR_FINISH)) {
            this.myCurrentSuspender = null;
            StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> TransactionGuard.getInstance().submitTransaction((Disposable)this.myProject, this.myDumbStartTransaction, this::updateFinished));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean switchToSmartMode() {
        Queue<Runnable> queue = this.myRunWhenSmartQueue;
        synchronized (queue) {
            if (!this.myState.compareAndSet(State.WAITING_FOR_FINISH, State.SMART)) {
                return false;
            }
        }
        LoadingPhase.compareAndSet((LoadingPhase)LoadingPhase.PROJECT_OPENED, (LoadingPhase)LoadingPhase.INDEXING_FINISHED);
        this.myDumbEnterTrace = null;
        this.myDumbStart = null;
        ++this.myModificationCount;
        return !this.myProject.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFinished() {
        if (!((Boolean)WriteAction.compute(this::switchToSmartMode)).booleanValue()) {
            return;
        }
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("updateFinished");
        }
        try {
            this.myPublisher.exitDumbMode();
            FileEditorManagerEx.getInstanceEx(this.myProject).refreshIcons();
        }
        finally {
            while (!this.isDumb()) {
                Runnable runnable2;
                Queue<Runnable> queue = this.myRunWhenSmartQueue;
                synchronized (queue) {
                    if (this.myRunWhenSmartQueue.isEmpty()) {
                        break;
                    }
                    runnable2 = (Runnable)this.myRunWhenSmartQueue.pullFirst();
                }
                DumbServiceImpl.doRun(runnable2);
            }
        }
    }

    private static void doRun(@Async.Execute Runnable runnable2) {
        try {
            runnable2.run();
        }
        catch (ProcessCanceledException e) {
            LOG.error("Task canceled: " + runnable2, new Attachment[]{new Attachment("pce", (Throwable)e)});
        }
        catch (Throwable e) {
            LOG.error("Error executing task " + runnable2, e);
        }
    }

    public void showDumbModeNotification(@NotNull String message) {
        if (message == null) {
            DumbServiceImpl.$$$reportNull$$$0(15);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.myProject);
            if (ideFrame != null) {
                ((StatusBarEx)ideFrame.getStatusBar()).notifyProgressByBalloon(MessageType.WARNING, message);
            }
        });
    }

    public void waitForSmartMode() {
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed() || application.isDispatchThread()) {
            throw new AssertionError((Object)"Don't invoke waitForSmartMode from inside read action in dumb mode");
        }
        while (this.myState.get() != State.SMART && !this.myProject.isDisposed()) {
            LockSupport.parkNanos(50000000L);
            ProgressManager.checkCanceled();
        }
    }

    public JComponent wrapGently(@NotNull JComponent dumbUnawareContent, @NotNull Disposable parentDisposable) {
        if (dumbUnawareContent == null) {
            DumbServiceImpl.$$$reportNull$$$0(16);
        }
        if (parentDisposable == null) {
            DumbServiceImpl.$$$reportNull$$$0(17);
        }
        final DumbUnawareHider wrapper2 = new DumbUnawareHider(dumbUnawareContent);
        wrapper2.setContentVisible(!this.isDumb());
        this.getProject().getMessageBus().connect(parentDisposable).subscribe(DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                wrapper2.setContentVisible(false);
            }

            public void exitDumbMode() {
                wrapper2.setContentVisible(true);
            }
        });
        return wrapper2;
    }

    public void smartInvokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(18);
        }
        this.smartInvokeLater(runnable2, ModalityState.defaultModalityState());
    }

    public void smartInvokeLater(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
        if (runnable2 == null) {
            DumbServiceImpl.$$$reportNull$$$0(19);
        }
        if (modalityState == null) {
            DumbServiceImpl.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.isDumb()) {
                this.runWhenSmart(() -> this.smartInvokeLater(runnable2, modalityState));
            } else {
                runnable2.run();
            }
        }, modalityState, this.myProject.getDisposed());
    }

    public void completeJustSubmittedTasks() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myProject.isInitialized());
        if (this.myState.get() != State.SCHEDULED_TASKS) {
            return;
        }
        while (this.isDumb()) {
            this.assertState(State.SCHEDULED_TASKS);
            this.showModalProgress();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void showModalProgress() {
        NoAccessDuringPsiEvents.checkCallContext();
        try {
            ((ApplicationImpl)ApplicationManager.getApplication()).executeSuspendingWriteAction(this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), () -> {
                this.assertState(State.SCHEDULED_TASKS);
                this.runBackgroundProcess(ProgressManager.getInstance().getProgressIndicator());
                this.assertState(State.SMART, State.WAITING_FOR_FINISH);
            });
            this.assertState(State.SMART, State.WAITING_FOR_FINISH);
            if (this.myState.get() == State.SMART) return;
        }
        catch (Throwable throwable) {
            if (this.myState.get() == State.SMART) throw throwable;
            this.assertState(State.WAITING_FOR_FINISH);
            this.updateFinished();
            this.assertState(State.SMART, State.SCHEDULED_TASKS);
            throw throwable;
        }
        this.assertState(State.WAITING_FOR_FINISH);
        this.updateFinished();
        this.assertState(State.SMART, State.SCHEDULED_TASKS);
    }

    private void assertState(State ... expected) {
        State state = this.myState.get();
        List<State> expectedList = Arrays.asList(expected);
        if (!expectedList.contains((Object)state)) {
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            if (this.myDumbEnterTrace != null) {
                attachments.add(new Attachment("indexingStart", this.myDumbEnterTrace));
            }
            attachments.add(new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString()));
            throw new RuntimeExceptionWithAttachments("Internal error, please include thread dump attachment. Expected " + expectedList + ", but was " + state.toString(), attachments.toArray(Attachment.EMPTY_ARRAY));
        }
    }

    private void startBackgroundProcess() {
        try {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, IdeBundle.message((String)"progress.indexing", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator visibleIndicator) {
                    if (visibleIndicator == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    DumbServiceImpl.this.runBackgroundProcess(visibleIndicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleIndicator", "com/intellij/openapi/project/DumbServiceImpl$4", "run"));
                }
            });
        }
        catch (Throwable e) {
            this.queueUpdateFinished();
            LOG.error("Failed to start background index update task", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBackgroundProcess(final @NotNull ProgressIndicator visibleIndicator) {
        block30: {
            if (visibleIndicator == null) {
                DumbServiceImpl.$$$reportNull$$$0(21);
            }
            ((ProgressManagerImpl)ProgressManager.getInstance()).markProgressSafe((ProgressWindow)visibleIndicator);
            if (!this.myState.compareAndSet(State.SCHEDULED_TASKS, State.RUNNING_DUMB_TASKS)) {
                return;
            }
            try (ProgressSuspender suspender = ProgressSuspender.markSuspendable(visibleIndicator, "Indexing paused");){
                this.myCurrentSuspender = suspender;
                this.suspendIfRequested(suspender);
                ShutDownTracker shutdownTracker = ShutDownTracker.getInstance();
                Thread self = Thread.currentThread();
                try {
                    Pair<DumbModeTask, ProgressIndicatorEx> pair;
                    shutdownTracker.registerStopperThread(self);
                    ((ProgressIndicatorEx)visibleIndicator).addStateDelegate(new AppIconProgress());
                    DumbModeTask task2 = null;
                    while ((pair = this.getNextTask(task2)) != null) {
                        task2 = (DumbModeTask)pair.first;
                        ProgressIndicatorEx taskIndicator = (ProgressIndicatorEx)pair.second;
                        taskIndicator.addStateDelegate(new AbstractProgressIndicatorExBase(){

                            @Override
                            protected void delegateProgressChange(@NotNull AbstractProgressIndicatorExBase.IndicatorAction action2) {
                                if (action2 == null) {
                                    5.$$$reportNull$$$0(0);
                                }
                                super.delegateProgressChange(action2);
                                action2.execute((ProgressIndicatorEx)visibleIndicator);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/project/DumbServiceImpl$5", "delegateProgressChange"));
                            }
                        });
                        AccessToken ignored = HeavyProcessLatch.INSTANCE.processStarted("Performing indexing tasks");
                        Throwable throwable = null;
                        try {
                            DumbServiceImpl.runSingleTask(task2, taskIndicator);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ignored == null) continue;
                            if (throwable != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ignored.close();
                        }
                    }
                }
                catch (Throwable unexpected) {
                    try {
                        LOG.error(unexpected);
                        break block30;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        shutdownTracker.unregisterStopperThread(self);
                        this.myCurrentSuspender = null;
                    }
                }
                shutdownTracker.unregisterStopperThread(self);
                this.myCurrentSuspender = null;
            }
        }
    }

    private static void runSingleTask(DumbModeTask task2, ProgressIndicatorEx taskIndicator) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.info("Running dumb mode task: " + task2);
        }
        ProgressManager.getInstance().runProcess(() -> {
            try {
                taskIndicator.checkCanceled();
                taskIndicator.setIndeterminate(true);
                taskIndicator.setText(IdeBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
                task2.performInDumbMode((ProgressIndicator)taskIndicator);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            catch (Throwable unexpected) {
                LOG.error(unexpected);
            }
        }, (ProgressIndicator)taskIndicator);
    }

    @Nullable
    private Pair<DumbModeTask, ProgressIndicatorEx> getNextTask(@Nullable DumbModeTask prevTask) {
        CompletableFuture result2 = new CompletableFuture();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                result2.completeExceptionally(new ProcessCanceledException());
                return;
            }
            if (prevTask != null) {
                Disposer.dispose((Disposable)prevTask);
            }
            result2.complete(this.pollTaskQueue());
        });
        return (Pair)DumbServiceImpl.waitForFuture(result2);
    }

    @Nullable
    private Pair<DumbModeTask, ProgressIndicatorEx> pollTaskQueue() {
        ProgressIndicatorEx indicator;
        DumbModeTask queuedTask;
        while (true) {
            if (this.myUpdatesQueue.isEmpty()) {
                this.queueUpdateFinished();
                return null;
            }
            queuedTask = (DumbModeTask)this.myUpdatesQueue.pullFirst();
            this.myQueuedEquivalences.remove(queuedTask.getEquivalenceObject());
            indicator = this.myProgresses.get(queuedTask);
            if (!indicator.isCanceled()) break;
            Disposer.dispose((Disposable)queuedTask);
        }
        return Pair.create((Object)queuedTask, (Object)indicator);
    }

    @Nullable
    private static <T> T waitForFuture(Future<T> result2) {
        try {
            return result2.get();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof ProcessCanceledException)) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)cause);
            }
            return null;
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    public Throwable getDumbModeStartTrace() {
        return this.myDumbStart;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/DumbServiceImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 7: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbUnawareContent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/DumbServiceImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "heavyActivityStarted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cancelTask";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suspendIndexingAndRun";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "heavyActivityStarted";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resumeAutoSuspendedTask";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runWhenSmart";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "queueTask";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runTaskSynchronously";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "queueAsynchronousTask";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "queueTaskOnEdt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTaskToQueue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "enterDumbMode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showDumbModeNotification";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "wrapGently";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "smartInvokeLater";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runBackgroundProcess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum State {
        SMART,
        SCHEDULED_TASKS,
        RUNNING_DUMB_TASKS,
        WAITING_FOR_FINISH;

    }

    private class AppIconProgress
    extends ProgressIndicatorBase {
        private double lastFraction;

        private AppIconProgress() {
        }

        @Override
        public void setFraction(double fraction) {
            if (fraction - this.lastFraction < 0.01) {
                return;
            }
            this.lastFraction = fraction;
            UIUtil.invokeLaterIfNeeded(() -> AppIcon.getInstance().setProgress(DumbServiceImpl.this.myProject, "indexUpdate", AppIconScheme.Progress.INDEXING, fraction, true));
        }

        @Override
        public void finish(@NotNull TaskInfo task2) {
            if (task2 == null) {
                AppIconProgress.$$$reportNull$$$0(0);
            }
            if (this.lastFraction != 0.0) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    AppIcon appIcon = AppIcon.getInstance();
                    if (appIcon.hideProgress(DumbServiceImpl.this.myProject, "indexUpdate")) {
                        if (Registry.is((String)"ide.appIcon.requestAttention.after.indexing", (boolean)false)) {
                            appIcon.requestAttention(DumbServiceImpl.this.myProject, false);
                        }
                        appIcon.setOkBadge(DumbServiceImpl.this.myProject, true);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/project/DumbServiceImpl$AppIconProgress", "finish"));
        }
    }
}

