/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class PluginsAdvertiserStartupActivity
implements StartupActivity,
DumbAware {
    PluginsAdvertiserStartupActivity() {
    }

    public void runActivity(@NotNull Project project) {
        Application app;
        if (project == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(0);
        }
        if ((app = ApplicationManager.getApplication()).isUnitTestMode() || app.isHeadlessEnvironment()) {
            return;
        }
        if (!UpdateSettings.getInstance().isCheckNeeded()) {
            return;
        }
        try {
            PluginsAdvertiserStartupActivity.run(project);
        }
        catch (UnknownHostException e) {
            PluginsAdvertiser.LOG.warn("Host name could not be resolved: " + e.getMessage());
        }
        catch (Exception e) {
            PluginsAdvertiser.LOG.info((Throwable)e);
        }
    }

    private static void run(@NotNull Project project) throws IOException {
        if (project == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(1);
        }
        Set<UnknownFeature> unknownFeatures = UnknownFeaturesCollector.getInstance(project).getUnknownFeatures();
        PluginsAdvertiser.KnownExtensions extensions = PluginsAdvertiser.loadExtensions();
        if (extensions != null && unknownFeatures.isEmpty()) {
            return;
        }
        MultiMap features = new MultiMap();
        THashMap disabledPlugins = new THashMap();
        List<IdeaPluginDescriptor> allPlugins = RepositoryHelper.loadPluginsFromAllRepositories(null);
        if (project.isDisposed()) {
            return;
        }
        if (extensions == null) {
            PluginsAdvertiser.loadSupportedExtensions(allPlugins);
            if (project.isDisposed()) {
                return;
            }
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
        }
        HashMap<String, PluginsAdvertiser.Plugin> ids = new HashMap<String, PluginsAdvertiser.Plugin>();
        for (UnknownFeature feature : unknownFeatures) {
            ProgressManager.checkCanceled();
            List<PluginsAdvertiser.Plugin> pluginId = PluginsAdvertiser.retrieve(feature);
            if (pluginId == null) continue;
            for (PluginsAdvertiser.Plugin plugin : pluginId) {
                ids.put(plugin.myPluginId, plugin);
                features.putValue((Object)plugin.myPluginId, (Object)feature);
            }
        }
        for (String id : ids.keySet()) {
            IdeaPluginDescriptor pluginDescriptor;
            PluginsAdvertiser.Plugin plugin = (PluginsAdvertiser.Plugin)ids.get(id);
            if (!PluginManagerCore.isDisabled(id) || (pluginDescriptor = PluginManager.getPlugin(PluginId.getId((String)id))) == null) continue;
            disabledPlugins.put(plugin, pluginDescriptor);
        }
        List<String> bundledPlugin = PluginsAdvertiser.hasBundledPluginToInstall(ids.values());
        THashSet plugins2 = new THashSet();
        for (IdeaPluginDescriptor loadedPlugin : allPlugins) {
            PluginId pluginId = loadedPlugin.getPluginId();
            if (!ids.containsKey(pluginId.getIdString()) || PluginManagerCore.isDisabled(pluginId.getIdString()) || PluginManagerCore.isBrokenPlugin(loadedPlugin)) continue;
            plugins2.add(PluginDownloader.createDownloader(loadedPlugin));
        }
        ApplicationManager.getApplication().invokeLater(() -> PluginsAdvertiserStartupActivity.lambda$run$0(project, (Set)plugins2, (Map)disabledPlugins, features, bundledPlugin, unknownFeatures, allPlugins), ModalityState.NON_MODAL);
    }

    @NotNull
    private static String getAddressedMessagePresentation(@NotNull Set<PluginDownloader> plugins2, @NotNull Map<PluginsAdvertiser.Plugin, IdeaPluginDescriptor> disabledPlugins, @NotNull MultiMap<String, UnknownFeature> features) {
        if (plugins2 == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(2);
        }
        if (disabledPlugins == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(3);
        }
        if (features == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(4);
        }
        MultiMap addressedFeatures = MultiMap.createSet();
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (PluginDownloader pluginDownloader : plugins2) {
            ids.add(pluginDownloader.getPluginId());
        }
        for (PluginsAdvertiser.Plugin plugin : disabledPlugins.keySet()) {
            ids.add(plugin.myPluginId);
        }
        for (String string : ids) {
            for (UnknownFeature feature : features.get((Object)string)) {
                addressedFeatures.putValue((Object)feature.getFeatureDisplayName(), (Object)feature.getImplementationDisplayName());
            }
        }
        String addressedFeaturesPresentation = StringUtil.join((Collection)addressedFeatures.entrySet(), entry -> (String)entry.getKey() + "[" + StringUtil.join((Collection)((Collection)entry.getValue()), (String)", ") + "]", (String)", ");
        int n = addressedFeatures.keySet().size();
        int pluginsNumber = ids.size();
        String string = StringUtil.pluralize((String)"Plugin", (int)pluginsNumber) + " supporting " + StringUtil.pluralize((String)"feature", (int)n) + " (" + addressedFeaturesPresentation + ") " + (pluginsNumber == 1 ? "is" : "are") + " currently " + (plugins2.isEmpty() ? "disabled" : "not installed") + ".<br>";
        if (string == null) {
            PluginsAdvertiserStartupActivity.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void lambda$run$0(Project project, Set plugins2, Map disabledPlugins, MultiMap features, List bundledPlugin, Set unknownFeatures, List allPlugins) {
        if (project.isDisposed()) {
            return;
        }
        String message = null;
        if (!plugins2.isEmpty() || !disabledPlugins.isEmpty()) {
            message = PluginsAdvertiserStartupActivity.getAddressedMessagePresentation(plugins2, disabledPlugins, (MultiMap<String, UnknownFeature>)features);
            message = !disabledPlugins.isEmpty() ? message + "<a href=\"enable\">Enable plugins...</a><br>" : message + "<a href=\"configure\">Configure plugins...</a><br>";
            message = message + "<a href=\"ignore\">Ignore Unknown Features</a>";
        } else if (bundledPlugin != null && !PropertiesComponent.getInstance().isTrueValue("ignoreUltimateEdition")) {
            message = "Features covered by IntelliJ IDEA Ultimate Edition (" + StringUtil.join((Collection)bundledPlugin, (String)", ") + ") are detected.<br><a href=\"open\">" + "Check IntelliJ IDEA Ultimate Edition" + "</a><br><a href=\"ignoreUltimate\">" + "Do not suggest Ultimate Edition" + "</a>";
        }
        if (message != null) {
            PluginsAdvertiser.ConfigurePluginsListener notificationListener = new PluginsAdvertiser.ConfigurePluginsListener(unknownFeatures, project, allPlugins, plugins2, disabledPlugins);
            PluginsAdvertiser.NOTIFICATION_GROUP.createNotification("Plugins Suggestion", message, NotificationType.INFORMATION, (NotificationListener)notificationListener).notify(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserStartupActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginsAdvertiserStartupActivity";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddressedMessagePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runActivity";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAddressedMessagePresentation";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

