/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TogglePopupHintsPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
StatusBarWidget.IconPresentation {
    private Icon myCurrentIcon;
    private String myToolTipText;

    public TogglePopupHintsPanel(@NotNull Project project) {
        if (project == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(0);
        }
        super(project);
        this.myCurrentIcon = IconLoader.getDisabledIcon((Icon)AllIcons.Ide.HectorOff);
        this.myConnection.subscribe(PowerSaveMode.TOPIC, this::updateStatus);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(1);
        }
        this.updateStatus();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(3);
        }
        this.updateStatus();
    }

    public StatusBarWidget copy() {
        return new TogglePopupHintsPanel(this.getProject());
    }

    @Nullable
    public Icon getIcon() {
        return this.myCurrentIcon;
    }

    public String getTooltipText() {
        return this.myToolTipText;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return e -> {
            Point point = new Point(0, 0);
            PsiFile file2 = this.getCurrentFile();
            if (file2 != null) {
                if (!DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).isHighlightingAvailable(file2)) {
                    return;
                }
                HectorComponent component = new HectorComponent(file2);
                Dimension dimension = component.getPreferredSize();
                point = new Point(point.x - dimension.width, point.y - dimension.height);
                component.showComponent(new RelativePoint(e.getComponent(), point));
            }
        };
    }

    @NotNull
    public String ID() {
        if ("InspectionProfile" == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(4);
        }
        return "InspectionProfile";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            TogglePopupHintsPanel.$$$reportNull$$$0(5);
        }
        return this;
    }

    public void clear() {
        this.myCurrentIcon = IconLoader.getDisabledIcon((Icon)AllIcons.Ide.HectorOff);
        this.myToolTipText = null;
        this.myStatusBar.updateWidget(this.ID());
    }

    public void updateStatus() {
        UIUtil.invokeLaterIfNeeded(() -> this.updateStatus(this.getCurrentFile()));
    }

    private void updateStatus(PsiFile file2) {
        if (this.isDisposed()) {
            return;
        }
        if (TogglePopupHintsPanel.isStateChangeable(file2)) {
            if (PowerSaveMode.isEnabled()) {
                this.myCurrentIcon = IconLoader.getDisabledIcon((Icon)AllIcons.Ide.HectorOff);
                this.myToolTipText = "Code analysis is disabled in power save mode.\n";
            } else if (HighlightingLevelManager.getInstance(this.myProject).shouldInspect((PsiElement)file2)) {
                this.myCurrentIcon = AllIcons.Ide.HectorOn;
                this.myToolTipText = "Current inspection profile: " + InspectionProjectProfileManager.getInstance(file2.getProject()).getCurrentProfile().getName() + ".\n";
            } else if (HighlightingLevelManager.getInstance(this.myProject).shouldHighlight((PsiElement)file2)) {
                this.myCurrentIcon = AllIcons.Ide.HectorSyntax;
                this.myToolTipText = "Highlighting level is: Syntax.\n";
            } else {
                this.myCurrentIcon = AllIcons.Ide.HectorOff;
                this.myToolTipText = "Inspections are off.\n";
            }
            this.myToolTipText = this.myToolTipText + UIBundle.message((String)"popup.hints.panel.click.to.configure.highlighting.tooltip.text", (Object[])new Object[0]);
        } else {
            this.myCurrentIcon = file2 != null ? IconLoader.getDisabledIcon((Icon)AllIcons.Ide.HectorOff) : null;
            this.myToolTipText = null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    private static boolean isStateChangeable(PsiFile file2) {
        return file2 != null && DaemonCodeAnalyzer.getInstance((Project)file2.getProject()).isHighlightingAvailable(file2);
    }

    @Nullable
    private PsiFile getCurrentFile() {
        VirtualFile virtualFile = this.getSelectedFile();
        if (virtualFile != null && virtualFile.isValid()) {
            return PsiManager.getInstance((Project)this.getProject()).findFile(virtualFile);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/TogglePopupHintsPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

