/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopeUtil {
    @NotNull
    public static GlobalSearchScope toGlobalSearchScope(@NotNull SearchScope scope, @NotNull Project project) {
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(1);
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)scope;
            if (globalSearchScope == null) {
                GlobalSearchScopeUtil.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)ReadAction.compute(() -> GlobalSearchScope.filesScope((Project)project, GlobalSearchScopeUtil.getLocalScopeFiles((LocalSearchScope)scope)));
        if (globalSearchScope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @NotNull
    public static Set<VirtualFile> getLocalScopeFiles(@NotNull LocalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(4);
        }
        Set set = (Set)ReadAction.compute(() -> {
            LinkedHashSet files2 = new LinkedHashSet();
            for (PsiElement element : scope.getScope()) {
                PsiFile file2 = element.getContainingFile();
                if (file2 == null) continue;
                ContainerUtil.addIfNotNull(files2, (Object)file2.getVirtualFile());
                ContainerUtil.addIfNotNull(files2, (Object)file2.getNavigationElement().getContainingFile().getVirtualFile());
            }
            return files2;
        });
        if (set == null) {
            GlobalSearchScopeUtil.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopeUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopeUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toGlobalSearchScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalScopeFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toGlobalSearchScope";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLocalScopeFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

