/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiCheckedRenameElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.refactoring.rename.FragmentaryPsiReference;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.rename.RenameInputValidatorRegistry;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameUtil");

    private RenameUtil() {
    }

    @NotNull
    public static UsageInfo[] findUsages(@NotNull PsiElement element, String newName, boolean searchInStringsAndComments, boolean searchForTextOccurrences, Map<? extends PsiElement, String> allRenames) {
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(0);
        }
        UsageInfo[] usageInfoArray = RenameUtil.findUsages(element, newName, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject()), searchInStringsAndComments, searchForTextOccurrences, allRenames);
        if (usageInfoArray == null) {
            RenameUtil.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    @NotNull
    public static UsageInfo[] findUsages(@NotNull PsiElement element, String newName, @NotNull SearchScope searchScope, boolean searchInStringsAndComments, boolean searchForTextOccurrences, Map<? extends PsiElement, String> allRenames) {
        String stringToReplace;
        String stringToSearch;
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(3);
        }
        List<UsageInfo> result2 = Collections.synchronizedList(new ArrayList());
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element);
        SearchScope useScope = searchScope.intersectWith(PsiSearchHelper.getInstance((Project)element.getProject()).getUseScope(element));
        Collection<PsiReference> refs = processor2.findReferences(element, useScope, searchInStringsAndComments);
        for (PsiReference ref : refs) {
            if (ref == null) {
                LOG.error("null reference from processor " + processor2);
                continue;
            }
            PsiElement referenceElement = ref.getElement();
            result2.add(processor2.createUsageInfo(element, ref, referenceElement));
        }
        processor2.findCollisions(element, newName, allRenames, result2);
        PsiElement searchForInComments = processor2.getElementToSearchInStringsAndComments(element);
        if (searchInStringsAndComments && searchForInComments != null && (stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)searchForInComments, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS)).length() > 0) {
            stringToReplace = RenameUtil.getStringToReplace(element, newName, false, processor2);
            NonCodeUsageInfoFactory factory = new NonCodeUsageInfoFactory(searchForInComments, stringToReplace);
            TextOccurrencesUtil.addUsagesInStringsAndComments(searchForInComments, searchScope, stringToSearch, result2, factory);
        }
        if (searchForTextOccurrences && searchForInComments != null) {
            Pair<String, String> additionalStringToSearch;
            stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)searchForInComments, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
            if (stringToSearch.length() > 0) {
                stringToReplace = RenameUtil.getStringToReplace(element, newName, true, processor2);
                RenameUtil.addTextOccurrence(searchForInComments, result2, searchScope, stringToSearch, stringToReplace);
            }
            if ((additionalStringToSearch = processor2.getTextOccurrenceSearchStrings(searchForInComments, newName)) != null && ((String)additionalStringToSearch.first).length() > 0) {
                RenameUtil.addTextOccurrence(searchForInComments, result2, searchScope, (String)additionalStringToSearch.first, (String)additionalStringToSearch.second);
            }
        }
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            RenameUtil.$$$reportNull$$$0(4);
        }
        return usageInfoArray;
    }

    private static void addTextOccurrence(final @NotNull PsiElement element, @NotNull List<? super UsageInfo> result2, @NotNull SearchScope searchScope, @NotNull String stringToSearch, final String stringToReplace) {
        if (element == null) {
            RenameUtil.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            RenameUtil.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            RenameUtil.$$$reportNull$$$0(7);
        }
        if (stringToSearch == null) {
            RenameUtil.$$$reportNull$$$0(8);
        }
        UsageInfoFactory factory = new UsageInfoFactory(){

            public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                TextRange textRange;
                if (usage == null) {
                    1.$$$reportNull$$$0(0);
                }
                int start2 = (textRange = usage.getTextRange()) == null ? 0 : textRange.getStartOffset();
                return NonCodeUsageInfo.create((PsiFile)usage.getContainingFile(), (int)(start2 + startOffset), (int)(start2 + endOffset), (PsiElement)element, (String)stringToReplace);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/rename/RenameUtil$1", "createUsageInfo"));
            }
        };
        if (searchScope instanceof GlobalSearchScope) {
            TextOccurrencesUtil.addTextOccurrences(element, stringToSearch, (GlobalSearchScope)searchScope, result2, factory);
        }
    }

    public static void buildPackagePrefixChangedMessage(VirtualFile[] virtualFiles, StringBuffer message, String qualifiedName) {
        if (virtualFiles.length > 0) {
            message.append(RefactoringBundle.message((String)"package.occurs.in.package.prefixes.of.the.following.source.folders.n", (Object[])new Object[]{qualifiedName}));
            for (VirtualFile virtualFile : virtualFiles) {
                message.append(virtualFile.getPresentableUrl()).append("\n");
            }
            message.append(RefactoringBundle.message((String)"these.package.prefixes.will.be.changed"));
        }
    }

    private static String getStringToReplace(PsiElement element, String newName, boolean nonJava, RenamePsiElementProcessor theProcessor) {
        String result2;
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        if (element instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)element).getMetaData()) != null) {
            return metaData.getName();
        }
        if (theProcessor != null && (result2 = theProcessor.getQualifiedNameAfterRename(element, newName, nonJava)) != null) {
            return result2;
        }
        if (element instanceof PsiNamedElement) {
            return newName;
        }
        LOG.error("Unknown element type : " + element);
        return null;
    }

    public static void checkRename(PsiElement element, String newName) throws IncorrectOperationException {
        if (element instanceof PsiCheckedRenameElement) {
            ((PsiCheckedRenameElement)element).checkSetName(newName);
        }
    }

    public static void doRename(final PsiElement element, String newName, UsageInfo[] usages, Project project, final @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        String fqn;
        RenamePsiElementProcessor processor2 = RenamePsiElementProcessor.forElement(element);
        String string = fqn = element instanceof PsiFile ? ((PsiFile)element).getVirtualFile().getPath() : CopyReferenceAction.elementToFqn(element);
        if (fqn != null) {
            BasicUndoableAction action2 = new BasicUndoableAction(){

                public void undo() {
                    if (listener2 instanceof UndoRefactoringElementListener) {
                        ((UndoRefactoringElementListener)listener2).undoElementMovedOrRenamed(element, fqn);
                    }
                }

                public void redo() {
                }
            };
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)action2);
        }
        processor2.renameElement(element, newName, usages, listener2);
    }

    public static void showErrorMessage(IncorrectOperationException e, PsiElement element, Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(e);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            String helpID = RenamePsiElementProcessor.forElement(element).getHelpID(element);
            String message = e.getMessage();
            if (StringUtil.isEmpty((String)message)) {
                message = RefactoringBundle.message((String)"rename.not.supported");
            }
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"rename.title"), (String)message, (String)helpID, (Project)project);
        });
    }

    public static void doRenameGenericNamedElement(@NotNull PsiElement namedElement, String newName, UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        PsiMetaData metaData;
        if (namedElement == null) {
            RenameUtil.$$$reportNull$$$0(9);
        }
        PsiWritableMetaData writableMetaData = null;
        if (namedElement instanceof PsiMetaOwner && (metaData = ((PsiMetaOwner)namedElement).getMetaData()) instanceof PsiWritableMetaData) {
            writableMetaData = (PsiWritableMetaData)metaData;
        }
        if (writableMetaData == null && !(namedElement instanceof PsiNamedElement)) {
            LOG.error("Unknown element type:" + namedElement);
        }
        boolean hasBindables = false;
        for (UsageInfo usage : usages) {
            if (!(usage.getReference() instanceof BindablePsiReference)) {
                RenameUtil.rename(usage, newName);
                continue;
            }
            hasBindables = true;
        }
        if (writableMetaData != null) {
            writableMetaData.setName(newName);
        } else {
            PsiElement namedElementAfterRename = ((PsiNamedElement)namedElement).setName(newName);
            if (namedElementAfterRename != null) {
                namedElement = namedElementAfterRename;
            }
        }
        if (hasBindables) {
            for (UsageInfo usage : usages) {
                PsiReference ref = usage.getReference();
                if (!(ref instanceof BindablePsiReference)) continue;
                boolean fallback = true;
                if (!(ref instanceof FragmentaryPsiReference) || !((FragmentaryPsiReference)ref).isFragmentOnlyRename()) {
                    try {
                        ref.bindToElement(namedElement);
                        fallback = false;
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        // empty catch block
                    }
                }
                if (!fallback) continue;
                ref.handleElementRename(newName);
            }
        }
        if (listener2 != null) {
            listener2.elementRenamed(namedElement);
        }
    }

    public static void rename(UsageInfo info, String newName) throws IncorrectOperationException {
        if (info.getElement() == null) {
            return;
        }
        PsiReference ref = info.getReference();
        if (ref == null) {
            return;
        }
        ref.handleElementRename(newName);
    }

    @Nullable
    public static List<UnresolvableCollisionUsageInfo> removeConflictUsages(Set<UsageInfo> usages) {
        ArrayList<UnresolvableCollisionUsageInfo> result2 = new ArrayList<UnresolvableCollisionUsageInfo>();
        Iterator<UsageInfo> iterator = usages.iterator();
        while (iterator.hasNext()) {
            UsageInfo usageInfo = iterator.next();
            if (!(usageInfo instanceof UnresolvableCollisionUsageInfo)) continue;
            result2.add((UnresolvableCollisionUsageInfo)usageInfo);
            iterator.remove();
        }
        return result2.isEmpty() ? null : result2;
    }

    public static void addConflictDescriptions(UsageInfo[] usages, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo usage : usages) {
            if (!(usage instanceof UnresolvableCollisionUsageInfo)) continue;
            conflicts.putValue((Object)usage.getElement(), (Object)((UnresolvableCollisionUsageInfo)usage).getDescription());
        }
    }

    public static void renameNonCodeUsages(@NotNull Project project, @NotNull NonCodeUsageInfo[] usages) {
        if (project == null) {
            RenameUtil.$$$reportNull$$$0(10);
        }
        if (usages == null) {
            RenameUtil.$$$reportNull$$$0(11);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        HashMap<Document, ArrayList<UsageOffset>> docsToOffsetsMap = new HashMap<Document, ArrayList<UsageOffset>>();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        for (NonCodeUsageInfo usage : usages) {
            ProperTextRange rangeInElement;
            PsiElement element = usage.getElement();
            if (element == null || (element = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(element, true)) == null || (rangeInElement = usage.getRangeInElement()) == null) continue;
            PsiFile containingFile = element.getContainingFile();
            Document document = psiDocumentManager.getDocument(containingFile);
            Segment segment = usage.getSegment();
            LOG.assertTrue(segment != null);
            int fileOffset = segment.getStartOffset();
            ArrayList<UsageOffset> list2 = (ArrayList<UsageOffset>)docsToOffsetsMap.get(document);
            if (list2 == null) {
                list2 = new ArrayList<UsageOffset>();
                docsToOffsetsMap.put(document, list2);
            }
            list2.add(new UsageOffset(fileOffset, fileOffset + rangeInElement.getLength(), usage.newText));
        }
        for (Document document : docsToOffsetsMap.keySet()) {
            List list3 = (List)docsToOffsetsMap.get(document);
            LOG.assertTrue(list3 != null, (Object)document);
            Object[] offsets = list3.toArray(new UsageOffset[0]);
            Arrays.sort(offsets);
            for (int i = offsets.length - 1; i >= 0; --i) {
                Object usageOffset = offsets[i];
                document.replaceString(((UsageOffset)usageOffset).startOffset, ((UsageOffset)usageOffset).endOffset, (CharSequence)((UsageOffset)usageOffset).newText);
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
    }

    public static boolean isValidName(Project project, PsiElement psiElement, String newName) {
        Language fileLanguage;
        if (newName == null || newName.length() == 0) {
            return false;
        }
        Condition inputValidator = RenameInputValidatorRegistry.getInputValidator((PsiElement)psiElement);
        if (inputValidator != null) {
            return inputValidator.value((Object)newName);
        }
        if (psiElement instanceof PsiFile || psiElement instanceof PsiDirectory) {
            return newName.indexOf(92) < 0 && newName.indexOf(47) < 0;
        }
        if (psiElement instanceof PomTargetPsiElement) {
            return !StringUtil.isEmptyOrSpaces((String)newName);
        }
        PsiFile file2 = psiElement.getContainingFile();
        Language elementLanguage = psiElement.getLanguage();
        Language language = fileLanguage = file2 == null ? null : file2.getLanguage();
        Language language2 = fileLanguage == null ? elementLanguage : (fileLanguage.isKindOf(elementLanguage) ? fileLanguage : elementLanguage);
        return ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(language2)).isIdentifier(newName.trim(), project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameUtil";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToSearch";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTextOccurrence";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doRenameGenericNamedElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renameNonCodeUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UsageOffset
    implements Comparable<UsageOffset> {
        final int startOffset;
        final int endOffset;
        final String newText;

        UsageOffset(int startOffset, int endOffset, String newText) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.newText = newText;
        }

        @Override
        public int compareTo(UsageOffset o) {
            return this.startOffset - o.startOffset;
        }
    }
}

