/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogListener;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.log.TerminalHandler;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;

public class CloudLoggingHandlerImpl
implements CloudAgentLoggingHandler {
    private final HashMap<String, LogListenerImpl> myPipeName2LogListener;
    private final LoggingHandler myMainLoggingHandler;
    private final DeploymentLogManager myLogManager;

    public CloudLoggingHandlerImpl(DeploymentLogManager logManager) {
        this.myMainLoggingHandler = logManager.getMainLoggingHandler();
        this.myPipeName2LogListener = new HashMap();
        this.myLogManager = logManager;
    }

    public void println(String message) {
        this.myMainLoggingHandler.print(message + "\n");
    }

    public LogListener getOrCreateLogListener(String pipeName) {
        LogListenerImpl cached = this.myPipeName2LogListener.get(pipeName);
        if (cached != null && !cached.isClosed()) {
            return cached;
        }
        LogListenerImpl result2 = new LogListenerImpl(this.myLogManager.addAdditionalLog(pipeName), true);
        this.myPipeName2LogListener.put(pipeName, result2);
        return result2;
    }

    public LogListener getOrCreateEmptyLogListener(String pipeName) {
        LogListenerImpl result2 = (LogListenerImpl)this.getOrCreateLogListener(pipeName);
        result2.clear();
        return result2;
    }

    public LogListener createConsole(String pipeName, final OutputStream consoleInput) {
        LoggingHandler loggingHandler = this.myLogManager.addAdditionalLog(pipeName);
        loggingHandler.attachToProcess(new ProcessHandler(){

            protected void destroyProcessImpl() {
            }

            protected void detachProcessImpl() {
            }

            public boolean detachIsDefault() {
                return false;
            }

            @Nullable
            public OutputStream getProcessInput() {
                return consoleInput;
            }
        });
        return new LogListenerImpl(loggingHandler, false);
    }

    public boolean isTtySupported() {
        return this.myLogManager.isTtySupported();
    }

    public TerminalListener createTerminal(String pipeName, OutputStream terminalInput, InputStream terminalOutput, InputStream stderr) {
        final TerminalHandler terminalHandler = this.myLogManager.addTerminal(pipeName, terminalOutput, terminalInput);
        return new TerminalListener(){

            public void close() {
                if (terminalHandler != null) {
                    terminalHandler.close();
                }
            }

            public void setTtyResizeHandler(@Nullable TerminalListener.TtyResizeHandler ttyResizeHandler) {
                if (terminalHandler instanceof TerminalHandlerBase && ttyResizeHandler != null) {
                    ((TerminalHandlerBase)terminalHandler).setResizeHandler(ttyResizeHandler);
                }
            }
        };
    }

    private static class LogListenerImpl
    implements LogListener {
        private final LoggingHandler myLoggingHandler;
        private final boolean myAppendLineBreak;

        LogListenerImpl(LoggingHandler loggingHandler, boolean appendLineBreak) {
            this.myLoggingHandler = loggingHandler;
            this.myAppendLineBreak = appendLineBreak;
        }

        public void lineLogged(String line2) {
            this.myLoggingHandler.print(this.myAppendLineBreak ? line2 + "\n" : line2);
        }

        public void close() {
            if (this.myLoggingHandler instanceof LoggingHandlerBase) {
                ((LoggingHandlerBase)this.myLoggingHandler).close();
            }
        }

        public boolean isClosed() {
            return this.myLoggingHandler instanceof LoggingHandlerBase && ((LoggingHandlerBase)this.myLoggingHandler).isClosed();
        }

        public void clear() {
            this.myLoggingHandler.clear();
        }
    }
}

