/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.jediterm.terminal.TerminalDataStream;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;

public class AppendableTerminalDataStream
implements TerminalDataStream,
Appendable {
    private final LinkedBlockingDeque<Character> myQueue = new LinkedBlockingDeque(10000000);
    private final LinkedBlockingDeque<Character> myPushBackQueue = new LinkedBlockingDeque();

    public char getChar() throws IOException {
        Character ch = this.myPushBackQueue.poll();
        if (ch != null) {
            return ch.charValue();
        }
        try {
            return this.myQueue.take().charValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void pushChar(char c2) {
        this.myPushBackQueue.addFirst(Character.valueOf(c2));
    }

    public String readNonControlCharacters(int maxLength) {
        StringBuilder sb = new StringBuilder();
        while (sb.length() < maxLength) {
            Character c2 = this.myPushBackQueue.peek();
            if (c2 != null) {
                if (c2.charValue() < ' ') break;
                sb.append(this.myPushBackQueue.poll());
                continue;
            }
            c2 = this.myQueue.peek();
            if (c2 == null || c2.charValue() < ' ') break;
            sb.append(this.myQueue.poll());
        }
        return sb.toString();
    }

    public void pushBackBuffer(char[] chars, int length) {
        for (int i = length - 1; i >= 0; --i) {
            this.myPushBackQueue.addFirst(Character.valueOf(chars[i]));
        }
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start2, int end) throws IOException {
        for (int i = start2; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public Appendable append(char c2) throws IOException {
        try {
            this.myQueue.put(Character.valueOf(c2));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return this;
    }
}

