/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.terminal.AppendableTerminalDataStream;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.terminal.PendingTasksRunner;
import com.intellij.terminal.ProcessHandlerTtyConnector;
import com.intellij.terminal.TerminalConsoleContentHelper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.ObjectUtils;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.pty4j.PtyProcess;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalExecutionConsole
implements ConsoleView,
ObservableConsoleView {
    private static final Logger LOG = Logger.getInstance(TerminalExecutionConsole.class);
    private JBTerminalWidget myTerminalWidget;
    private final Project myProject;
    private final AppendableTerminalDataStream myDataStream;
    private final AtomicBoolean myAttachedToProcess;
    private volatile boolean myLastCR;
    private final PendingTasksRunner myOnResizedRunner;
    private final TerminalConsoleContentHelper myContentHelper;
    private boolean myEnableConsoleActions;
    private boolean myEnterKeyDefaultCodeEnabled;

    public TerminalExecutionConsole(@NotNull Project project, @Nullable ProcessHandler processHandler2) {
        if (project == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(0);
        }
        this.myAttachedToProcess = new AtomicBoolean(false);
        this.myLastCR = false;
        this.myContentHelper = new TerminalConsoleContentHelper(this);
        this.myEnableConsoleActions = true;
        this.myEnterKeyDefaultCodeEnabled = true;
        this.myProject = project;
        this.myOnResizedRunner = new PendingTasksRunner(2000L, project);
        JBTerminalSystemSettingsProviderBase provider = new JBTerminalSystemSettingsProviderBase(){

            public HyperlinkStyle.HighlightMode getHyperlinkHighlightingMode() {
                return HyperlinkStyle.HighlightMode.ALWAYS;
            }
        };
        this.myDataStream = new AppendableTerminalDataStream();
        this.myTerminalWidget = new ConsoleTerminalWidget(project, provider);
        Disposer.register((Disposable)this.myTerminalWidget, (Disposable)provider);
        if (processHandler2 != null) {
            this.attachToProcess(processHandler2);
        }
    }

    private void printText(@NotNull String text2, @Nullable ConsoleViewContentType contentType) throws IOException {
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(1);
        }
        if (contentType != null) {
            this.myDataStream.append(TerminalExecutionConsole.encodeColor(contentType.getAttributes().getForegroundColor()));
        }
        this.myDataStream.append(text2);
        if (contentType != null) {
            this.myDataStream.append("\u001b[39m");
        }
        this.myContentHelper.onContentTypePrinted((ConsoleViewContentType)ObjectUtils.notNull((Object)contentType, (Object)ConsoleViewContentType.NORMAL_OUTPUT));
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(3);
        }
        this.myContentHelper.addChangeListener(listener2, parent);
    }

    private static String encodeColor(Color color) {
        return "\u001b[38;2;" + color.getRed() + ";" + color.getGreen() + ";" + color.getBlue() + "m";
    }

    @Deprecated
    public void setAutoNewLineMode(boolean enabled) {
    }

    @NotNull
    public TerminalExecutionConsole withEnterKeyDefaultCodeEnabled(boolean enterKeyDefaultCodeEnabled) {
        this.myEnterKeyDefaultCodeEnabled = enterKeyDefaultCodeEnabled;
        TerminalExecutionConsole terminalExecutionConsole = this;
        if (terminalExecutionConsole == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(4);
        }
        return terminalExecutionConsole;
    }

    public void addMessageFilter(Project project, Filter filter) {
        this.myTerminalWidget.addMessageFilter(project, filter);
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(5);
        }
        if (contentType == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(6);
        }
        String textCRLF = this.convertTextToCRLF(text2);
        try {
            this.printText(textCRLF, contentType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @NotNull
    private String convertTextToCRLF(@NotNull String text2) {
        boolean preserveLastCR;
        if (text2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(7);
        }
        if (text2.isEmpty()) {
            String string = text2;
            if (string == null) {
                TerminalExecutionConsole.$$$reportNull$$$0(8);
            }
            return string;
        }
        boolean preserveFirstLF = text2.startsWith(LineSeparator.LF.getSeparatorString()) && this.myLastCR;
        this.myLastCR = preserveLastCR = text2.endsWith(LineSeparator.CR.getSeparatorString());
        String textToConvert = text2.substring(preserveFirstLF ? 1 : 0, preserveLastCR ? text2.length() - 1 : text2.length());
        String textCRLF = StringUtil.convertLineSeparators((String)textToConvert, (String)LineSeparator.CRLF.getSeparatorString());
        if (preserveFirstLF) {
            textCRLF = LineSeparator.LF.getSeparatorString() + textCRLF;
        }
        if (preserveLastCR) {
            textCRLF = textCRLF + LineSeparator.CR.getSeparatorString();
        }
        String string = textCRLF;
        if (string == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void clear() {
        this.myLastCR = false;
        this.myTerminalWidget.getTerminalPanel().clearBuffer();
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        if (processHandler2 != null) {
            this.attachToProcess(processHandler2, true);
        }
    }

    protected final void attachToProcess(@NotNull ProcessHandler processHandler2, final boolean attachToProcessOutput) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(10);
        }
        if (!this.myAttachedToProcess.compareAndSet(false, true)) {
            return;
        }
        this.myTerminalWidget.createTerminalSession(new ProcessHandlerTtyConnector(processHandler2, EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset()));
        this.myTerminalWidget.start();
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (attachToProcessOutput) {
                    TerminalExecutionConsole.this.myOnResizedRunner.execute(() -> {
                        try {
                            ConsoleViewContentType contentType = null;
                            if (outputType != ProcessOutputTypes.STDOUT) {
                                contentType = ConsoleViewContentType.getConsoleViewType((Key)outputType);
                            }
                            String text2 = event.getText();
                            if (outputType == ProcessOutputTypes.SYSTEM) {
                                text2 = StringUtil.convertLineSeparators((String)text2, (String)LineSeparator.CRLF.getSeparatorString());
                            }
                            TerminalExecutionConsole.this.printText(text2, contentType);
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                        }
                    });
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    JBTerminalWidget widget = TerminalExecutionConsole.this.myTerminalWidget;
                    if (widget != null) {
                        widget.getTerminalPanel().setCursorVisible(false);
                    }
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(11);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(12);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(13);
        }
        this.addMessageFilter(this.myProject, filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(14);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] detachConsoleActions(boolean prependSeparatorIfNonEmpty) {
        Object[] actions = this.createConsoleActions();
        this.myEnableConsoleActions = false;
        if (prependSeparatorIfNonEmpty && actions.length > 0) {
            actions = (AnAction[])ArrayUtil.mergeArrays((Object[])new AnAction[]{Separator.create()}, (Object[])actions);
        }
        if (actions == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(15);
        }
        return actions;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (this.myEnableConsoleActions) {
            AnAction[] anActionArray = new AnAction[]{new ScrollToTheEndAction(), new ClearAction()};
            if (anActionArray == null) {
                TerminalExecutionConsole.$$$reportNull$$$0(16);
            }
            return anActionArray;
        }
        if (AnAction.EMPTY_ARRAY == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(17);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public void dispose() {
        this.myTerminalWidget = null;
    }

    public static boolean isAcceptable(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            TerminalExecutionConsole.$$$reportNull$$$0(18);
        }
        return processHandler2 instanceof OSProcessHandler && ((OSProcessHandler)processHandler2).getProcess() instanceof PtyProcess && !(processHandler2 instanceof ColoredProcessHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withEnterKeyDefaultCodeEnabled";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTextToCRLF";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "detachConsoleActions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "printText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertTextToCRLF";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ScrollToTheEndAction
    extends DumbAwareAction {
        private ScrollToTheEndAction() {
            super(ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), AllIcons.RunConfigurations.Scroll_down);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(0);
            }
            BoundedRangeModel model2 = this.getBoundedRangeModel();
            e.getPresentation().setEnabled(model2 != null && model2.getValue() != 0);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BoundedRangeModel model2;
            if (e == null) {
                ScrollToTheEndAction.$$$reportNull$$$0(1);
            }
            if ((model2 = this.getBoundedRangeModel()) != null) {
                model2.setValue(0);
            }
        }

        @Nullable
        private BoundedRangeModel getBoundedRangeModel() {
            return TerminalExecutionConsole.this.myTerminalWidget != null ? TerminalExecutionConsole.this.myTerminalWidget.getTerminalPanel().getBoundedRangeModel() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ScrollToTheEndAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClearAction
    extends DumbAwareAction {
        private ClearAction() {
            super(ExecutionBundle.message((String)"clear.all.from.console.action.name", (Object[])new Object[0]), "Clear the contents of the console", AllIcons.Actions.GC);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearAction.$$$reportNull$$$0(1);
            }
            TerminalExecutionConsole.this.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ClearAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ConsoleTerminalWidget
    extends JBTerminalWidget
    implements DataProvider {
        private ConsoleTerminalWidget(@NotNull Project project, JBTerminalSystemSettingsProviderBase provider) {
            if (project == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(1);
            }
            super(project, 200, 24, provider, (Disposable)TerminalExecutionConsole.this);
        }

        @Override
        protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
            if (settingsProvider == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(2);
            }
            if (styleState == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(3);
            }
            if (textBuffer == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(4);
            }
            JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState){

                public Dimension requestResize(Dimension newSize, RequestOrigin origin, int cursorX, int cursorY, JediTerminal.ResizeHandler resizeHandler) {
                    Dimension dimension = super.requestResize(newSize, origin, cursorX, cursorY, resizeHandler);
                    TerminalExecutionConsole.this.myOnResizedRunner.setReady();
                    return dimension;
                }

                public void clearBuffer() {
                    super.clearBuffer(false);
                }
            };
            Disposer.register((Disposable)this, (Disposable)panel2);
            return panel2;
        }

        @Override
        protected TerminalStarter createTerminalStarter(JediTerminal terminal, TtyConnector connector) {
            return new TerminalStarter((Terminal)terminal, connector, TerminalExecutionConsole.this.myDataStream){

                public byte[] getCode(int key, int modifiers) {
                    if (key == 10 && modifiers == 0 && TerminalExecutionConsole.this.myEnterKeyDefaultCodeEnabled) {
                        return LineSeparator.CR.getSeparatorBytes();
                    }
                    return super.getCode(key, modifiers);
                }
            };
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                ConsoleTerminalWidget.$$$reportNull$$$0(5);
            }
            if (LangDataKeys.CONSOLE_VIEW.is(dataId)) {
                return TerminalExecutionConsole.this;
            }
            return super.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "styleState";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textBuffer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/terminal/TerminalExecutionConsole$ConsoleTerminalWidget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTerminalPanel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

