/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;

public class FramelessNotificationPopup {
    private final JComponent myContent;
    public static final Dimension myPreferredContentSize = JBUI.size((int)300, (int)100);
    private final JBPopup myPopup;
    private int myTimerTick;
    private final Color myBackgroud;
    private final boolean myUseDefaultPreferredSize;
    private static final int FADE_IN_TICKS = 60;
    private static final int SHOW_TIME_TICKS = 360;
    private static final int FADE_OUT_TICKS = 420;
    private final ActionListener myFadeTracker = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Window popupWindow = SwingUtilities.windowForComponent(FramelessNotificationPopup.this.myContent);
            if (popupWindow != null) {
                FramelessNotificationPopup.this.myTimerTick++;
                if (FramelessNotificationPopup.this.myTimerTick < 60) {
                    popupWindow.setLocation(popupWindow.getLocation().x, popupWindow.getLocation().y - 2);
                } else if (FramelessNotificationPopup.this.myTimerTick > 420) {
                    FramelessNotificationPopup.this.myPopup.cancel();
                    FramelessNotificationPopup.this.myFadeInTimer.stop();
                } else if (FramelessNotificationPopup.this.myTimerTick > 360) {
                    popupWindow.setLocation(popupWindow.getLocation().x, popupWindow.getLocation().y + 2);
                }
            }
        }
    };
    private final Timer myFadeInTimer;
    private final ActionListener myActionListener;

    public FramelessNotificationPopup(JComponent owner, JComponent content2, Color backgroud) {
        this(owner, content2, backgroud, true, null);
    }

    public FramelessNotificationPopup(JComponent owner, JComponent content2, Color backgroud, boolean useDefaultPreferredSize, ActionListener listener2) {
        this.myBackgroud = backgroud;
        this.myUseDefaultPreferredSize = useDefaultPreferredSize;
        this.myContent = new ContentComponent(content2);
        this.myActionListener = listener2;
        this.myFadeInTimer = UIUtil.createNamedTimer((String)"Frameless fade in", (int)10, (ActionListener)this.myFadeTracker);
        this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(this.myContent, null).setRequestFocus(false).setResizable(false).setMovable(true).setLocateWithinScreenBounds(false).setAlpha(0.2f).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (FramelessNotificationPopup.this.myFadeInTimer.isRunning()) {
                    FramelessNotificationPopup.this.myFadeInTimer.stop();
                }
                FramelessNotificationPopup.this.myFadeInTimer.removeActionListener(FramelessNotificationPopup.this.myFadeTracker);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/popup/FramelessNotificationPopup$2", "onClosed"));
            }
        }).createPopup();
        Point p = RelativePoint.getSouthEastOf((JComponent)owner).getScreenPoint();
        Rectangle screen = ScreenUtil.getScreenRectangle((int)p.x, (int)p.y);
        Point initial = new Point(screen.x + screen.width - this.myContent.getPreferredSize().width - 50, screen.y + screen.height - 5);
        this.myPopup.showInScreenCoordinates((Component)owner, initial);
        this.myFadeInTimer.setRepeats(true);
        this.myFadeInTimer.start();
    }

    public JBPopup getPopup() {
        return this.myPopup;
    }

    private class ContentComponent
    extends JPanel {
        private final MouseAdapter myMouseListener;

        ContentComponent(JComponent content2) {
            super(new BorderLayout());
            this.add((Component)content2, "Center");
            this.setBackground(FramelessNotificationPopup.this.myBackgroud);
            this.myMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        FramelessNotificationPopup.this.myPopup.cancel();
                    } else if (UIUtil.isActionClick((MouseEvent)e) && FramelessNotificationPopup.this.myActionListener != null) {
                        FramelessNotificationPopup.this.myActionListener.actionPerformed(new ActionEvent(FramelessNotificationPopup.this, 1001, null));
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (FramelessNotificationPopup.this.myFadeInTimer.isRunning()) {
                        FramelessNotificationPopup.this.myFadeInTimer.stop();
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!FramelessNotificationPopup.this.myFadeInTimer.isRunning()) {
                        FramelessNotificationPopup.this.myFadeInTimer.start();
                    }
                }
            };
        }

        @Override
        public void addNotify() {
            super.addNotify();
            ListenerUtil.addMouseListener(this, this.myMouseListener);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            ListenerUtil.removeMouseListener(this, this.myMouseListener);
        }

        @Override
        public Dimension getPreferredSize() {
            if (FramelessNotificationPopup.this.myUseDefaultPreferredSize) {
                return myPreferredContentSize;
            }
            return super.getPreferredSize();
        }
    }
}

