/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.Identifiable;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.tree.Navigatable;
import com.intellij.ui.tree.Searchable;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Command;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class AsyncTreeModel
extends AbstractTreeModel
implements Identifiable,
Searchable,
Navigatable,
TreeVisitor.Acceptor {
    private static final Logger LOG = Logger.getInstance(AsyncTreeModel.class);
    private final Command.Processor processor;
    private final Tree tree;
    private final TreeModel model;
    private final boolean showLoadingNode;
    private final TreeModelListener listener;

    @Deprecated
    public AsyncTreeModel(@NotNull TreeModel model2) {
        if (model2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(0);
        }
        this(model2, true);
    }

    @Deprecated
    public AsyncTreeModel(@NotNull TreeModel model2, boolean showLoadingNode) {
        Invoker.EDT foreground;
        if (model2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(1);
        }
        this.tree = new Tree();
        this.listener = new TreeModelAdapter(){

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                TreePath path;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((path = event.getTreePath()) == null) {
                    AsyncTreeModel.this.processor.process(new CmdGetRoot("Reload root", null));
                    return;
                }
                Object object = path.getLastPathComponent();
                if (object == null) {
                    LOG.warn("unsupported path: " + path);
                    return;
                }
                if (path.getParentPath() == null && type == TreeModelAdapter.EventType.StructureChanged) {
                    AsyncTreeModel.this.processor.process(new CmdGetRoot("Update root", object));
                    return;
                }
                AsyncTreeModel.this.onValidThread(() -> {
                    Node node = (Node)AsyncTreeModel.this.tree.map.get(object);
                    if (node == null) {
                        LOG.debug("ignore updating of nonexistent node: ", new Object[]{object});
                    } else if (type == TreeModelAdapter.EventType.NodesChanged) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), event.getChildIndices(), event.getChildren());
                    } else if (node.isLoadingRequired()) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), null, null);
                    } else if (type == TreeModelAdapter.EventType.NodesInserted) {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Insert children", node, false));
                    } else if (type == TreeModelAdapter.EventType.NodesRemoved) {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Remove children", node, false));
                    } else {
                        AsyncTreeModel.this.processor.process(new CmdGetChildren("Update children", node, true));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/tree/AsyncTreeModel$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (model2 instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)model2));
        }
        Invoker background = foreground = new Invoker.EDT((Disposable)this);
        if (model2 instanceof InvokerSupplier) {
            InvokerSupplier supplier = (InvokerSupplier)((Object)model2);
            background = supplier.getInvoker();
        }
        this.processor = new Command.Processor(foreground, background);
        this.model = model2;
        this.model.addTreeModelListener(this.listener);
        this.showLoadingNode = showLoadingNode;
    }

    public AsyncTreeModel(@NotNull TreeModel model2, @NotNull Disposable parent) {
        if (model2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            AsyncTreeModel.$$$reportNull$$$0(3);
        }
        this(model2, true, parent);
    }

    public AsyncTreeModel(@NotNull TreeModel model2, boolean showLoadingNode, @NotNull Disposable parent) {
        if (model2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            AsyncTreeModel.$$$reportNull$$$0(5);
        }
        this(model2, showLoadingNode);
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public void dispose() {
        super.dispose();
        this.model.removeTreeModelListener(this.listener);
    }

    @Override
    public Object getUniqueID(@NotNull TreePath path) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(6);
        }
        return this.model instanceof Identifiable ? ((Identifiable)((Object)this.model)).getUniqueID(path) : null;
    }

    @Override
    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(7);
            }
            return promise;
        }
        Promise<TreePath> promise = this.resolve(this.model instanceof Searchable ? ((Searchable)((Object)this.model)).getTreePath(object) : null);
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(8);
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<TreePath> nextTreePath(@NotNull TreePath path, Object object) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(9);
        }
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(10);
            }
            return promise;
        }
        Promise<TreePath> promise = this.resolve(this.model instanceof Navigatable ? ((Navigatable)((Object)this.model)).nextTreePath(path, object) : null);
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(11);
        }
        return promise;
    }

    @Override
    @NotNull
    public Promise<TreePath> prevTreePath(@NotNull TreePath path, Object object) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(12);
        }
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(13);
            }
            return promise;
        }
        Promise<TreePath> promise = this.resolve(this.model instanceof Navigatable ? ((Navigatable)((Object)this.model)).prevTreePath(path, object) : null);
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(14);
        }
        return promise;
    }

    @NotNull
    public Promise<TreePath> resolve(TreePath path) {
        AsyncPromise async = new AsyncPromise();
        this.onValidThread(() -> this.resolve((AsyncPromise<? super TreePath>)async, path));
        AsyncPromise asyncPromise = async;
        if (asyncPromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(15);
        }
        return asyncPromise;
    }

    @NotNull
    private Promise<TreePath> resolve(Promise<? extends TreePath> promise) {
        if (promise == null && this.isValidThread()) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(16);
            }
            return promise2;
        }
        AsyncPromise async = new AsyncPromise();
        if (promise == null) {
            this.onValidThread(() -> async.setError("rejected"));
        } else {
            promise.onError(this.onValidThread(arg_0 -> ((AsyncPromise)async).setError(arg_0)));
            promise.onSuccess(this.onValidThread(path -> this.resolve((AsyncPromise<? super TreePath>)async, (TreePath)path)));
        }
        AsyncPromise asyncPromise = async;
        if (asyncPromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(17);
        }
        return asyncPromise;
    }

    private void resolve(@NotNull AsyncPromise<? super TreePath> async, TreePath path) {
        if (async == null) {
            AsyncTreeModel.$$$reportNull$$$0(18);
        }
        LOG.debug("resolve path: ", new Object[]{path});
        if (path == null) {
            async.setError("path is null");
            return;
        }
        Object object = path.getLastPathComponent();
        if (object == null) {
            async.setError("path is wrong");
            return;
        }
        this.accept((TreeVisitor)new TreeVisitor.ByTreePath(path, o -> o)).onProcessed(result2 -> {
            if (result2 == null) {
                async.setError("path not found");
                return;
            }
            async.setResult(result2);
        });
    }

    public Object getRoot() {
        if (this.disposed) {
            return null;
        }
        this.onValidThread(this::promiseRootEntry);
        Node node = this.tree.root;
        return node == null ? null : node.object;
    }

    public Object getChild(Object object, int index) {
        List<Node> children2 = this.getEntryChildren(object);
        return 0 <= index && index < children2.size() ? children2.get(index).object : null;
    }

    public int getChildCount(Object object) {
        return this.getEntryChildren(object).size();
    }

    public boolean isLeaf(Object object) {
        Node node = this.getEntry(object);
        if (node == null) {
            return true;
        }
        if (node.leafState == LeafState.ALWAYS) {
            return true;
        }
        if (node.leafState == LeafState.NEVER) {
            return false;
        }
        List children2 = node.children;
        return children2 != null && children2.isEmpty();
    }

    public void valueForPathChanged(@NotNull TreePath path, Object value) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(19);
        }
        this.processor.background.runOrInvokeLater(() -> this.model.valueForPathChanged(path, value));
    }

    public int getIndexOfChild(Object object, Object child2) {
        if (child2 != null) {
            List<Node> children2 = this.getEntryChildren(object);
            for (int i = 0; i < children2.size(); ++i) {
                if (!child2.equals(children2.get(i).object)) continue;
                return i;
            }
        }
        return -1;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor) {
        if (visitor == null) {
            AsyncTreeModel.$$$reportNull$$$0(20);
        }
        Promise<TreePath> promise = this.accept(visitor, true);
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(21);
        }
        return promise;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor, final boolean allowLoading) {
        if (visitor == null) {
            AsyncTreeModel.$$$reportNull$$$0(22);
        }
        AbstractTreeWalker<Node> walker = new AbstractTreeWalker<Node>(visitor, node -> ((Node)node).object){

            @Override
            protected Collection<Node> getChildren(@NotNull Node node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (node.leafState == LeafState.ALWAYS || !allowLoading) {
                    return node.getChildren();
                }
                AsyncTreeModel.this.promiseChildren(node).onSuccess(parent -> this.setChildren(((Node)parent).getChildren())).onError(this::setError);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/tree/AsyncTreeModel$2", "getChildren"));
            }
        };
        if (allowLoading) {
            this.processor.background.invokeLater(() -> this.onValidThread(() -> this.promiseRootEntry().onSuccess(walker::start).onError(walker::setError)));
        } else {
            this.onValidThread(() -> walker.start(this.tree.root));
        }
        Promise<TreePath> promise = walker.promise();
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(23);
        }
        return promise;
    }

    public boolean isProcessing() {
        if (this.processor.getTaskCount() > 0) {
            return true;
        }
        Object command = this.tree.queue.get();
        return command != null && ((ObsolescentCommand)command).isPending();
    }

    private boolean isValidThread() {
        if (this.processor.foreground.isValidThread()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException("AsyncTreeModel is used from unexpected thread"));
        return false;
    }

    public void onValidThread(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(24);
        }
        this.processor.foreground.runOrInvokeLater(runnable2);
    }

    @NotNull
    private <T> java.util.function.Consumer<T> onValidThread(@NotNull Consumer<? super T> consumer) {
        if (consumer == null) {
            AsyncTreeModel.$$$reportNull$$$0(25);
        }
        java.util.function.Consumer<Object> consumer2 = value -> this.onValidThread(() -> consumer.consume(value));
        if (consumer2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(26);
        }
        return consumer2;
    }

    @NotNull
    private Promise<Node> promiseRootEntry() {
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(27);
            }
            return promise;
        }
        Promise<Node> promise = this.tree.queue.promise(this.processor, () -> new CmdGetRoot("Load root", null));
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(28);
        }
        return promise;
    }

    @NotNull
    private Promise<Node> promiseChildren(@NotNull Node node) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(29);
        }
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(30);
            }
            return promise;
        }
        Promise<Node> promise = node.queue.promise(this.processor, () -> {
            node.setLoading(!this.showLoadingNode ? null : new Node(new LoadingNode(), LeafState.ALWAYS));
            return new CmdGetChildren("Load children", node, false);
        });
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(31);
        }
        return promise;
    }

    private Node getEntry(Object object) {
        return this.disposed || object == null || !this.isValidThread() ? null : (Node)this.tree.map.get(object);
    }

    @NotNull
    private List<Node> getEntryChildren(Object object) {
        Node node = this.getEntry(object);
        if (node == null) {
            List<Node> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(32);
            }
            return list2;
        }
        if (node.isLoadingRequired()) {
            this.promiseChildren(node);
        }
        List list3 = node.getChildren();
        if (list3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(33);
        }
        return list3;
    }

    @NotNull
    private TreeModelEvent createEvent(@NotNull TreePath path, Map<Object, Integer> map2) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(34);
        }
        if (map2 == null || map2.isEmpty()) {
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, path, null, null);
            if (treeModelEvent == null) {
                AsyncTreeModel.$$$reportNull$$$0(35);
            }
            return treeModelEvent;
        }
        int i = 0;
        int size = map2.size();
        int[] indices = new int[size];
        Object[] children2 = new Object[size];
        for (Map.Entry<Object, Integer> entry : map2.entrySet()) {
            indices[i] = entry.getValue();
            children2[i] = entry.getKey();
            ++i;
        }
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, path, indices, children2);
        if (treeModelEvent == null) {
            AsyncTreeModel.$$$reportNull$$$0(36);
        }
        return treeModelEvent;
    }

    private void treeNodesChanged(@NotNull Node node, Map<Object, Integer> map2) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(37);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesChanged(this.createEvent(path, map2));
            }
        }
    }

    private void treeNodesInserted(@NotNull Node node, Map<Object, Integer> map2) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(38);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesInserted(this.createEvent(path, map2));
            }
        }
    }

    private void treeNodesRemoved(@NotNull Node node, Map<Object, Integer> map2) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(39);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesRemoved(this.createEvent(path, map2));
            }
        }
    }

    @NotNull
    private static LinkedHashMap<Object, Integer> getIndices(@NotNull List<Node> children2, @Nullable ToIntFunction<? super Node> function) {
        if (children2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(40);
        }
        LinkedHashMap<Object, Integer> map2 = new LinkedHashMap<Object, Integer>();
        for (int i = 0; i < children2.size(); ++i) {
            Node child2 = children2.get(i);
            if (map2.containsKey(child2.object)) {
                LOG.warn("ignore duplicated " + (function == null ? "old" : "new") + " child at " + i);
                continue;
            }
            map2.put(child2.object, function == null ? i : function.applyAsInt(child2));
        }
        LinkedHashMap<Object, Integer> linkedHashMap = map2;
        if (linkedHashMap == null) {
            AsyncTreeModel.$$$reportNull$$$0(41);
        }
        return linkedHashMap;
    }

    private static int getIntersectionCount(@NotNull Map<Object, Integer> indices, @NotNull Iterable<Object> objects) {
        if (indices == null) {
            AsyncTreeModel.$$$reportNull$$$0(42);
        }
        if (objects == null) {
            AsyncTreeModel.$$$reportNull$$$0(43);
        }
        int count = 0;
        int last = -1;
        for (Object object : objects) {
            Integer index = indices.get(object);
            if (index == null || last >= index) continue;
            last = index;
            ++count;
        }
        return count;
    }

    @NotNull
    private static List<Object> getIntersection(@NotNull Map<Object, Integer> indices, @NotNull Iterable<Object> objects) {
        if (indices == null) {
            AsyncTreeModel.$$$reportNull$$$0(44);
        }
        if (objects == null) {
            AsyncTreeModel.$$$reportNull$$$0(45);
        }
        ArrayList<Object> list2 = new ArrayList<Object>(indices.size());
        int last = -1;
        for (Object object : objects) {
            Integer index = indices.get(object);
            if (index == null || last >= index) continue;
            last = index;
            list2.add(object);
        }
        ArrayList<Object> arrayList = list2;
        if (arrayList == null) {
            AsyncTreeModel.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    @NotNull
    private static List<Object> getIntersection(@NotNull Map<Object, Integer> removed, @NotNull Map<Object, Integer> inserted) {
        int countTwo;
        if (removed == null) {
            AsyncTreeModel.$$$reportNull$$$0(47);
        }
        if (inserted == null) {
            AsyncTreeModel.$$$reportNull$$$0(48);
        }
        if (removed.isEmpty() || inserted.isEmpty()) {
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(49);
            }
            return list2;
        }
        int countOne = AsyncTreeModel.getIntersectionCount(removed, inserted.keySet());
        if (countOne > (countTwo = AsyncTreeModel.getIntersectionCount(inserted, removed.keySet()))) {
            List<Object> list3 = AsyncTreeModel.getIntersection(removed, inserted.keySet());
            if (list3 == null) {
                AsyncTreeModel.$$$reportNull$$$0(50);
            }
            return list3;
        }
        if (countTwo > 0) {
            List<Object> list4 = AsyncTreeModel.getIntersection(inserted, removed.keySet());
            if (list4 == null) {
                AsyncTreeModel.$$$reportNull$$$0(51);
            }
            return list4;
        }
        List<Object> list5 = Collections.emptyList();
        if (list5 == null) {
            AsyncTreeModel.$$$reportNull$$$0(52);
        }
        return list5;
    }

    @NotNull
    private LeafState getLeafState(Object object) {
        LeafState.Supplier supplier;
        LeafState leafState;
        LOG.assertTrue(this.processor.background.isValidThread());
        if (object instanceof LeafState.Supplier && LeafState.DEFAULT != (leafState = (supplier = (LeafState.Supplier)object).getLeafState())) {
            LeafState leafState2 = leafState;
            if (leafState2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(53);
            }
            return leafState2;
        }
        LeafState leafState3 = this.model.isLeaf(object) ? LeafState.ALWAYS : LeafState.NEVER;
        if (leafState3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(54);
        }
        return leafState3;
    }

    protected void treeStructureChanged(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeStructureChanged(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    protected void treeNodesChanged(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesChanged(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    protected void treeNodesInserted(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesInserted(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    protected void treeNodesRemoved(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesRemoved(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + this.model, throwable);
        }
    }

    @Deprecated
    public void setRootImmediately(@NotNull Object object) {
        if (object == null) {
            AsyncTreeModel.$$$reportNull$$$0(55);
        }
        Node node = new Node(object, LeafState.NEVER);
        node.insertPath(new TreePath(object));
        this.tree.root = node;
        this.tree.map.put(object, node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 19: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "async";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 29: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inserted";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "nextTreePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "prevTreePath";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "onValidThread";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseRootEntry";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseChildren";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryChildren";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvent";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersection";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueID";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "nextTreePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prevTreePath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "valueForPathChanged";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "promiseChildren";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesChanged";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesInserted";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesRemoved";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionCount";
                break;
            }
            case 44: 
            case 45: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getIntersection";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setRootImmediately";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 41: 
            case 46: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Node {
        private final CommandQueue<CmdGetChildren> queue;
        private final Set<TreePath> paths;
        private volatile Object object;
        private volatile LeafState leafState;
        @Nullable
        private volatile List<Node> children;
        private volatile Node loading;

        private Node(@NotNull Object object, @NotNull LeafState leafState) {
            if (object == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (leafState == null) {
                Node.$$$reportNull$$$0(1);
            }
            this.queue = new CommandQueue();
            this.paths = new SmartHashSet();
            this.object = object;
            this.leafState = leafState;
        }

        private void setLeafState(@NotNull LeafState leafState) {
            if (leafState == null) {
                Node.$$$reportNull$$$0(2);
            }
            this.leafState = leafState;
            this.children = leafState == LeafState.ALWAYS ? null : Collections.emptyList();
            this.loading = null;
        }

        private void setChildren(@NotNull List<Node> children2) {
            if (children2 == null) {
                Node.$$$reportNull$$$0(3);
            }
            this.leafState = LeafState.NEVER;
            this.children = children2;
            this.loading = null;
        }

        private void setLoading(Node loading) {
            this.leafState = LeafState.NEVER;
            this.children = loading != null ? Collections.singletonList(loading) : Collections.emptyList();
            this.loading = loading;
        }

        private boolean isLoadingRequired() {
            return this.leafState != LeafState.ALWAYS && this.children == null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children;
            List<Node> list3 = list2 != null ? list2 : Collections.emptyList();
            if (list3 == null) {
                Node.$$$reportNull$$$0(4);
            }
            return list3;
        }

        private void forEachChildExceptLoading(Consumer<? super Node> consumer) {
            for (Node node : this.getChildren()) {
                if (node == this.loading) continue;
                consumer.consume((Object)node);
            }
        }

        private void insertPath(@NotNull TreePath path) {
            if (path == null) {
                Node.$$$reportNull$$$0(5);
            }
            if (!this.paths.add(path)) {
                LOG.warn("node is already attached to " + path);
            }
            this.forEachChildExceptLoading((Consumer<? super Node>)((Consumer)child2 -> child2.insertPath(path.pathByAddingChild(child2.object))));
        }

        private void insertMapping(Node parent) {
            if (parent == null) {
                this.insertPath(new TreePath(this.object));
            } else if (parent.loading == this) {
                LOG.warn("insert loading node unexpectedly");
            } else if (parent.paths.isEmpty()) {
                LOG.warn("insert to invalid parent");
            } else {
                parent.paths.forEach(path -> this.insertPath(path.pathByAddingChild(this.object)));
            }
        }

        private void removePath(@NotNull TreePath path) {
            if (path == null) {
                Node.$$$reportNull$$$0(6);
            }
            if (!this.paths.remove(path)) {
                LOG.warn("node is not attached to " + path);
            }
            this.forEachChildExceptLoading((Consumer<? super Node>)((Consumer)child2 -> child2.removePath(path.pathByAddingChild(child2.object))));
        }

        private void removeMapping(Node parent, @NotNull Tree tree) {
            if (tree == null) {
                Node.$$$reportNull$$$0(7);
            }
            if (parent == null) {
                this.removePath(new TreePath(this.object));
                tree.removeEmpty(this);
            } else if (parent.loading == this) {
                parent.loading = null;
            } else if (parent.paths.isEmpty()) {
                LOG.warn("remove from invalid parent");
            } else {
                parent.paths.forEach(path -> this.removePath(path.pathByAddingChild(this.object)));
                tree.removeEmpty(this);
            }
        }

        private void updatePaths(@NotNull Object oldObject, @NotNull Object newObject) {
            if (oldObject == null) {
                Node.$$$reportNull$$$0(8);
            }
            if (newObject == null) {
                Node.$$$reportNull$$$0(9);
            }
            if (this.paths.stream().anyMatch(path -> Node.contains(path, oldObject))) {
                List updated = ContainerUtil.map(this.paths, path -> Node.update(path, oldObject, newObject));
                this.paths.clear();
                this.paths.addAll(updated);
                this.forEachChildExceptLoading((Consumer<? super Node>)((Consumer)child2 -> child2.updatePaths(oldObject, newObject)));
            }
        }

        @NotNull
        private static TreePath update(@NotNull TreePath path, @NotNull Object oldObject, @NotNull Object newObject) {
            if (path == null) {
                Node.$$$reportNull$$$0(10);
            }
            if (oldObject == null) {
                Node.$$$reportNull$$$0(11);
            }
            if (newObject == null) {
                Node.$$$reportNull$$$0(12);
            }
            if (!Node.contains(path, oldObject)) {
                TreePath treePath = path;
                if (treePath == null) {
                    Node.$$$reportNull$$$0(13);
                }
                return treePath;
            }
            LOG.debug("update path: ", new Object[]{path});
            Object[] objects = TreePathUtil.convertTreePathToArray(path);
            for (int i = 0; i < objects.length; ++i) {
                if (oldObject != objects[i]) continue;
                objects[i] = newObject;
            }
            TreePath treePath = TreePathUtil.convertArrayToTreePath(objects);
            if (treePath == null) {
                Node.$$$reportNull$$$0(14);
            }
            return treePath;
        }

        private static boolean contains(@NotNull TreePath path, @NotNull Object object) {
            if (path == null) {
                Node.$$$reportNull$$$0(15);
            }
            if (object == null) {
                Node.$$$reportNull$$$0(16);
            }
            while (object != path.getLastPathComponent()) {
                if ((path = path.getParentPath()) != null) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leafState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$Node";
                    break;
                }
                case 5: 
                case 6: 
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldObject";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$Node";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "update";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setLeafState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildren";
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insertPath";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removePath";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeMapping";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePaths";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Tree {
        private final CommandQueue<CmdGetRoot> queue = new CommandQueue();
        private final Map<Object, Node> map = new HashMap<Object, Node>();
        private volatile Node root;

        private Tree() {
        }

        private void removeEmpty(@NotNull Node child2) {
            if (child2 == null) {
                Tree.$$$reportNull$$$0(0);
            }
            child2.forEachChildExceptLoading((Consumer<? super Node>)this::removeEmpty);
            if (child2.paths.isEmpty()) {
                child2.queue.close();
                Node node = this.map.remove(child2.object);
                if (node != child2) {
                    LOG.warn("invalid node: " + child2.object);
                    if (node != null) {
                        this.map.put(node.object, node);
                    }
                }
            }
        }

        private void fixEqualButNotSame(@NotNull Node node, @NotNull Object object) {
            if (node == null) {
                Tree.$$$reportNull$$$0(1);
            }
            if (object == null) {
                Tree.$$$reportNull$$$0(2);
            }
            if (object == node.object) {
                return;
            }
            this.map.remove(node.object);
            node.updatePaths(node.object, object);
            node.object = object;
            this.map.put(object, node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$Tree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeEmpty";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fixEqualButNotSame";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CommandQueue<T extends ObsolescentCommand> {
        private final Deque<T> deque = new ArrayDeque<T>();
        private volatile boolean closed;

        private CommandQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T get() {
            Deque<T> deque = this.deque;
            synchronized (deque) {
                return (T)((ObsolescentCommand)this.deque.peekFirst());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        Promise<Node> promise(@NotNull Command.Processor processor2, @NotNull Supplier<? extends T> supplier) {
            ObsolescentCommand command;
            if (processor2 == null) {
                CommandQueue.$$$reportNull$$$0(0);
            }
            if (supplier == null) {
                CommandQueue.$$$reportNull$$$0(1);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                command = (ObsolescentCommand)this.deque.peekFirst();
                if (command != null) {
                    AsyncPromise<Node> asyncPromise = command.promise;
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var4_3
                    if (asyncPromise == null) {
                        CommandQueue.$$$reportNull$$$0(2);
                    }
                    return asyncPromise;
                }
                command = (ObsolescentCommand)supplier.get();
            }
            processor2.process(command);
            AsyncPromise<Node> asyncPromise = command.promise;
            if (asyncPromise == null) {
                CommandQueue.$$$reportNull$$$0(3);
            }
            return asyncPromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(@NotNull T command, @NotNull Predicate<? super T> predicate) {
            if (command == null) {
                CommandQueue.$$$reportNull$$$0(4);
            }
            if (predicate == null) {
                CommandQueue.$$$reportNull$$$0(5);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                boolean add;
                if (this.closed) {
                    return;
                }
                ObsolescentCommand old = (ObsolescentCommand)this.deque.peekFirst();
                boolean bl = add = old == null || predicate.test(old);
                if (add) {
                    this.deque.addFirst(command);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done(@NotNull T command, Node node) {
            Iterable<AsyncPromise<Node>> promises;
            if (command == null) {
                CommandQueue.$$$reportNull$$$0(6);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                if (this.closed) {
                    return;
                }
                if (!this.deque.contains(command)) {
                    return;
                }
                promises = this.getPromises(command);
                if (this.deque.isEmpty()) {
                    this.deque.addLast(command);
                }
            }
            promises.forEach(promise -> promise.setResult((Object)node));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Iterable<AsyncPromise<Node>> promises;
            Deque<T> deque = this.deque;
            synchronized (deque) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.deque.isEmpty()) {
                    return;
                }
                promises = this.getPromises(null);
            }
            promises.forEach(promise -> promise.setError("cancel loading"));
        }

        @NotNull
        private Iterable<AsyncPromise<Node>> getPromises(T command) {
            ObsolescentCommand last;
            ArrayList<AsyncPromise<Node>> list2 = new ArrayList<AsyncPromise<Node>>();
            while ((last = (ObsolescentCommand)this.deque.pollLast()) != null) {
                if (last.isPending()) {
                    list2.add(last.promise);
                }
                if (!last.equals(command)) continue;
                break;
            }
            ArrayList<AsyncPromise<Node>> arrayList = list2;
            if (arrayList == null) {
                CommandQueue.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$CommandQueue";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$CommandQueue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "promise";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPromises";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "promise";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class CmdGetChildren
    extends ObsolescentCommand {
        private final Node node;
        private volatile boolean deep;

        CmdGetChildren(@NotNull String name, Node node, boolean deep) {
            if (name == null) {
                CmdGetChildren.$$$reportNull$$$0(0);
            }
            if (node == null) {
                CmdGetChildren.$$$reportNull$$$0(1);
            }
            super(name, node.object);
            this.node = node;
            if (deep) {
                this.deep = true;
            }
            node.queue.add(this, old -> {
                if (!deep && old.deep && old.isPending()) {
                    this.deep = true;
                }
                return true;
            });
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != this.node.queue.get();
        }

        @Override
        Node getNode(Object object) {
            Node loaded = new Node(object, AsyncTreeModel.this.getLeafState(object));
            if (loaded.leafState == LeafState.ALWAYS || this.isObsolete()) {
                return loaded;
            }
            if (AsyncTreeModel.this.model instanceof ChildrenProvider) {
                ChildrenProvider provider = (ChildrenProvider)((Object)AsyncTreeModel.this.model);
                List children2 = provider.getChildren(object);
                if (children2 == null) {
                    throw new ProcessCanceledException();
                }
                loaded.children = this.load(children2.size(), index -> children2.get(index));
            } else {
                loaded.children = this.load(AsyncTreeModel.this.model.getChildCount(object), index -> AsyncTreeModel.this.model.getChild(object, index));
            }
            return loaded;
        }

        @Nullable
        private List<Node> load(int count, @NotNull IntFunction function) {
            if (function == null) {
                CmdGetChildren.$$$reportNull$$$0(2);
            }
            if (count < 0) {
                LOG.warn("illegal child count: " + count);
            }
            if (count <= 0) {
                return Collections.emptyList();
            }
            SmartHashSet set = new SmartHashSet(count);
            ArrayList<Node> children2 = new ArrayList<Node>(count);
            for (int i = 0; i < count; ++i) {
                if (this.isObsolete()) {
                    return null;
                }
                Object child2 = function.apply(i);
                if (child2 == null) {
                    LOG.warn("ignore null child at " + i);
                    continue;
                }
                if (!set.add(child2)) {
                    LOG.warn("ignore duplicated child at " + i + ": " + child2);
                    continue;
                }
                if (this.isObsolete()) {
                    return null;
                }
                children2.add(new Node(child2, AsyncTreeModel.this.getLeafState(child2)));
            }
            return children2;
        }

        @Override
        void setNode(Node loaded) {
            if (loaded == null || loaded.isLoadingRequired()) {
                LOG.debug("cancelled command: ", new Object[]{this});
                return;
            }
            if (this.node != AsyncTreeModel.this.tree.map.get(loaded.object)) {
                this.node.queue.close();
                LOG.warn("ignore removed node: " + this.node.object);
                return;
            }
            List oldChildren = this.node.getChildren();
            ArrayList newChildren = loaded.getChildren();
            if (oldChildren.isEmpty() && newChildren.isEmpty()) {
                this.node.setLeafState(loaded.leafState);
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
                LOG.debug("no children: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            LinkedHashMap removed = AsyncTreeModel.getIndices(oldChildren, null);
            if (newChildren.isEmpty()) {
                oldChildren.forEach(child2 -> ((Node)child2).removeMapping(this.node, AsyncTreeModel.this.tree));
                this.node.setLeafState(loaded.leafState);
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
                LOG.debug("children removed: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            ArrayList list2 = new ArrayList(newChildren.size());
            SmartHashSet reload = new SmartHashSet();
            LinkedHashMap inserted = AsyncTreeModel.getIndices(newChildren, child2 -> {
                Node found = (Node)AsyncTreeModel.this.tree.map.get(((Node)child2).object);
                if (found == null) {
                    AsyncTreeModel.this.tree.map.put(((Node)child2).object, child2);
                    list2.add(child2);
                } else {
                    AsyncTreeModel.this.tree.fixEqualButNotSame(found, ((Node)child2).object);
                    list2.add(found);
                    if (found.leafState == LeafState.ALWAYS) {
                        if (((Node)child2).leafState != LeafState.ALWAYS) {
                            found.setLeafState(((Node)child2).leafState);
                            reload.add(found.object);
                        }
                    } else if (((Node)child2).leafState == LeafState.ALWAYS || !found.isLoadingRequired() && (this.deep || !removed.containsKey(found.object))) {
                        reload.add(found.object);
                    }
                }
                return list2.size() - 1;
            });
            newChildren = list2;
            if (oldChildren.isEmpty()) {
                newChildren.forEach(child2 -> ((Node)child2).insertMapping(this.node));
                this.node.setChildren(newChildren);
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
                LOG.debug("children inserted: ", new Object[]{this.node.object});
                this.node.queue.done(this, this.node);
                return;
            }
            LinkedHashMap contained = new LinkedHashMap();
            for (Object object : AsyncTreeModel.getIntersection((Map<Object, Integer>)removed, inserted)) {
                Integer newIndex;
                Integer oldIndex = (Integer)removed.remove(object);
                if (oldIndex == null) {
                    LOG.warn("intersection failed");
                }
                if ((newIndex = (Integer)inserted.remove(object)) == null) {
                    LOG.warn("intersection failed");
                    continue;
                }
                contained.put(object, newIndex);
            }
            for (Node child3 : newChildren) {
                if (removed.containsKey(child3.object) || !inserted.containsKey(child3.object)) continue;
                child3.insertMapping(this.node);
            }
            for (Node child3 : oldChildren) {
                if (!removed.containsKey(child3.object) || inserted.containsKey(child3.object)) continue;
                child3.removeMapping(this.node, AsyncTreeModel.this.tree);
            }
            this.node.setChildren(newChildren);
            if (!removed.isEmpty()) {
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
            }
            if (!inserted.isEmpty()) {
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
            }
            if (!contained.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, contained);
            }
            if (removed.isEmpty() && inserted.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
            }
            LOG.debug("children changed: ", new Object[]{this.node.object});
            if (!reload.isEmpty()) {
                for (Node child3 : newChildren) {
                    if (!reload.contains(child3.object)) continue;
                    AsyncTreeModel.this.processor.process(new CmdGetChildren("Update children recursively", child3, true));
                }
            }
            this.node.queue.done(this, this.node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$CmdGetChildren";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "load";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CmdGetRoot
    extends ObsolescentCommand {
        private CmdGetRoot(String name, Object object) {
            if (name == null) {
                CmdGetRoot.$$$reportNull$$$0(0);
            }
            super(name, object);
            AsyncTreeModel.this.tree.queue.add(this, old -> old.started || old.object != object);
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != AsyncTreeModel.this.tree.queue.get();
        }

        @Override
        Node getNode(Object object) {
            if (object == null) {
                object = AsyncTreeModel.this.model.getRoot();
            }
            if (object == null || this.isObsolete()) {
                return null;
            }
            return new Node(object, AsyncTreeModel.this.getLeafState(object));
        }

        @Override
        void setNode(Node loaded) {
            Node root = AsyncTreeModel.this.tree.root;
            if (root == null && loaded == null) {
                LOG.debug("no root");
                AsyncTreeModel.this.tree.queue.done(this, null);
                return;
            }
            if (root != null && loaded != null && root.object.equals(loaded.object)) {
                AsyncTreeModel.this.tree.fixEqualButNotSame(root, loaded.object);
                LOG.debug("same root: ", new Object[]{root.object});
                if (!root.isLoadingRequired()) {
                    AsyncTreeModel.this.processor.process(new CmdGetChildren("Update root children", root, true));
                }
                AsyncTreeModel.this.tree.queue.done(this, root);
                return;
            }
            if (root != null) {
                root.removeMapping(null, AsyncTreeModel.this.tree);
            }
            if (!AsyncTreeModel.this.tree.map.isEmpty()) {
                AsyncTreeModel.this.tree.map.values().forEach(node -> {
                    ((Node)node).queue.close();
                    LOG.warn("remove staled node: " + ((Node)node).object);
                });
                AsyncTreeModel.this.tree.map.clear();
            }
            AsyncTreeModel.this.tree.root = loaded;
            if (loaded != null) {
                AsyncTreeModel.this.tree.map.put(loaded.object, loaded);
                TreePath path = new TreePath(loaded.object);
                loaded.insertPath(path);
                AsyncTreeModel.this.treeStructureChanged(path, null, null);
                LOG.debug("new root: ", new Object[]{loaded.object});
                AsyncTreeModel.this.tree.queue.done(this, loaded);
            } else {
                AsyncTreeModel.this.treeStructureChanged(null, null, null);
                LOG.debug("root removed");
                AsyncTreeModel.this.tree.queue.done(this, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/AsyncTreeModel$CmdGetRoot", "<init>"));
        }
    }

    private static abstract class ObsolescentCommand
    implements Obsolescent,
    Command<Node> {
        final AsyncPromise<Node> promise;
        final String name;
        final Object object;
        volatile boolean started;

        ObsolescentCommand(@NotNull String name, Object object) {
            if (name == null) {
                ObsolescentCommand.$$$reportNull$$$0(0);
            }
            this.promise = new AsyncPromise();
            this.name = name;
            this.object = object;
            LOG.debug("create command: ", new Object[]{this});
        }

        abstract Node getNode(Object var1);

        abstract void setNode(Node var1);

        boolean isPending() {
            return Promise.State.PENDING == this.promise.getState();
        }

        public String toString() {
            return this.object == null ? this.name : this.name + ": " + this.object;
        }

        @Override
        public Node get() {
            this.started = true;
            if (this.isObsolete()) {
                LOG.debug("obsolete command: ", new Object[]{this});
                return null;
            }
            LOG.debug("background command: ", new Object[]{this});
            return this.getNode(this.object);
        }

        @Override
        public void accept(Node node) {
            if (this.isObsolete()) {
                LOG.debug("obsolete command: ", new Object[]{this});
            } else {
                LOG.debug("foreground command: ", new Object[]{this});
                this.setNode(node);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/AsyncTreeModel$ObsolescentCommand", "<init>"));
        }
    }
}

