/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.wizard;

import com.intellij.ui.wizard.WizardModel;
import com.intellij.ui.wizard.WizardNavigationState;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class WizardStep<T extends WizardModel> {
    public static final WizardStep FORCED_GOAL_DROPPED = new Empty();
    public static final WizardStep FORCED_GOAL_ACHIEVED = new Empty();
    private String myTitle = "";
    private String myExplanation = "";
    private Icon myIcon = null;
    private String myHelpId;

    protected WizardStep() {
    }

    public WizardStep(String title) {
        this.myTitle = title;
    }

    public WizardStep(String title, String explanation) {
        this.myTitle = title;
        this.myExplanation = explanation;
    }

    public WizardStep(String title, String explanation, Icon icon) {
        this.myTitle = title;
        this.myExplanation = explanation;
        this.myIcon = icon;
    }

    public WizardStep(String title, String explanation, Icon icon, @NonNls String helpId) {
        this.myTitle = title;
        this.myExplanation = explanation;
        this.myIcon = icon;
        this.myHelpId = helpId;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public String getExplanation() {
        return this.myExplanation;
    }

    public abstract JComponent prepare(WizardNavigationState var1);

    public WizardStep onNext(T model2) {
        return ((WizardModel)model2).getNextFor(this);
    }

    public WizardStep onPrevious(T model2) {
        return ((WizardModel)model2).getPreviousFor(this);
    }

    public boolean onCancel() {
        return true;
    }

    public boolean onFinish() {
        return true;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NonNls
    public String getHelpId() {
        return this.myHelpId;
    }

    public static class Empty
    extends WizardStep {
        @Override
        public JComponent prepare(WizardNavigationState state) {
            return null;
        }
    }
}

