/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.index.IndexImporterFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.SnapshotInputMappingIndex;
import com.intellij.util.indexing.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.indexing.impl.InputData;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IndexImporterMappingIndex<Key, Value, Input>
implements SnapshotInputMappingIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance(IndexImporterMappingIndex.class);
    private final List<SnapshotInputMappingIndex<Key, Value, Input>> myImporters;

    @Nullable
    static <Key, Value, Input> SnapshotInputMappingIndex<Key, Value, Input> wrap(final @Nullable SnapshotInputMappingIndex<Key, Value, Input> index, @NotNull IndexExtension<Key, Value, Input> indexExtension) {
        SnapshotInputMappingIndex<Key, Value, Input> indexImporterMappingIndex;
        if (indexExtension == null) {
            IndexImporterMappingIndex.$$$reportNull$$$0(0);
        }
        if ((indexImporterMappingIndex = IndexImporterMappingIndex.createImportersWrapper(indexExtension)) == null) {
            return index;
        }
        if (index == null) {
            return indexImporterMappingIndex;
        }
        if (index instanceof UpdatableSnapshotInputMappingIndex) {
            final UpdatableSnapshotInputMappingIndex updatableIndex = (UpdatableSnapshotInputMappingIndex)index;
            return new UpdatableSnapshotInputMappingIndex<Key, Value, Input>(){

                @Override
                @NotNull
                public Map<Key, Value> readData(int hashId) throws IOException {
                    Map map2 = updatableIndex.readData(hashId);
                    if (map2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return map2;
                }

                @Override
                public InputData<Key, Value> putData(@NotNull Input content2, @NotNull InputData<Key, Value> data) throws IOException {
                    if (content2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (data == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return updatableIndex.putData(content2, data);
                }

                @Override
                public void flush() throws IOException {
                    updatableIndex.flush();
                }

                @Override
                public void clear() throws IOException {
                    updatableIndex.clear();
                }

                @Override
                @Nullable
                public InputData<Key, Value> readData(@NotNull Input content2) throws IOException {
                    InputData existedData;
                    if (content2 == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    try {
                        existedData = index.readData(content2);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                        existedData = null;
                    }
                    if (existedData != null) {
                        return existedData;
                    }
                    InputData importedData = indexImporterMappingIndex.readData(content2);
                    if (importedData != null) {
                        return updatableIndex.putData(content2, importedData);
                    }
                    return null;
                }

                @Override
                public void close() throws IOException {
                    try {
                        updatableIndex.close();
                    }
                    finally {
                        indexImporterMappingIndex.close();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/util/indexing/IndexImporterMappingIndex$1";
                            break;
                        }
                        case 1: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "content";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "readData";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/util/indexing/IndexImporterMappingIndex$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "putData";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "readData";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        return new SnapshotInputMappingIndex<Key, Value, Input>(){

            @Override
            @Nullable
            public InputData<Key, Value> readData(@NotNull Input content2) throws IOException {
                InputData data;
                if (content2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((data = index.readData(content2)) != null) {
                    return data;
                }
                return indexImporterMappingIndex.readData(content2);
            }

            @Override
            public void close() throws IOException {
                try {
                    index.close();
                }
                finally {
                    indexImporterMappingIndex.close();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/indexing/IndexImporterMappingIndex$2", "readData"));
            }
        };
    }

    @Nullable
    private static <Key, Value, Input> SnapshotInputMappingIndex<Key, Value, Input> createImportersWrapper(@NotNull IndexExtension<Key, Value, Input> indexExtension) {
        List<SnapshotInputMappingIndex<Key, Value, Input>> importers;
        if (indexExtension == null) {
            IndexImporterMappingIndex.$$$reportNull$$$0(1);
        }
        try {
            importers = IndexImporterFactory.EP_NAME.extensions().map(f -> f.createImporter(indexExtension)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            importers = Collections.emptyList();
        }
        return importers.isEmpty() ? null : new IndexImporterMappingIndex<Key, Value, Input>(importers);
    }

    private IndexImporterMappingIndex(@NotNull List<SnapshotInputMappingIndex<Key, Value, Input>> importers) {
        if (importers == null) {
            IndexImporterMappingIndex.$$$reportNull$$$0(2);
        }
        this.myImporters = importers;
        LOG.assertTrue(!importers.isEmpty());
    }

    @Override
    @Nullable
    public InputData<Key, Value> readData(@NotNull Input content2) {
        if (content2 == null) {
            IndexImporterMappingIndex.$$$reportNull$$$0(3);
        }
        for (SnapshotInputMappingIndex<Key, Value, Input> importer : this.myImporters) {
            try {
                InputData<Key, Value> data = importer.readData(content2);
                if (data == null) continue;
                return data;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void close() {
        for (SnapshotInputMappingIndex<Key, Value, Input> importer : this.myImporters) {
            try {
                importer.close();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexExtension";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/IndexImporterMappingIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createImportersWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

