/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class ToggleLineBreakpointAction
extends XDebuggerActionBase
implements DumbAware,
Toggleable {
    public ToggleLineBreakpointAction() {
        super(true);
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(0);
        }
        DebuggerActionHandler debuggerActionHandler = debuggerSupport.getToggleLineBreakpointHandler();
        if (debuggerActionHandler == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(1);
        }
        return debuggerActionHandler;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(2);
        }
        super.update(event);
        if ("TouchBarGeneral".equals(event.getPlace())) {
            event.getPresentation().setIcon(AllIcons.Debugger.Db_set_breakpoint);
        }
        boolean selected2 = ToggleLineBreakpointAction.hasLineBreakpoint(event);
        event.getPresentation().putClientProperty("selected", (Object)selected2);
    }

    private static boolean hasLineBreakpoint(@NotNull AnActionEvent e) {
        Project proj;
        if (e == null) {
            ToggleLineBreakpointAction.$$$reportNull$$$0(3);
        }
        if ((proj = e.getProject()) == null) {
            return false;
        }
        XLineBreakpointType[] breakpointTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
        XBreakpointManager breakpointManager = XDebuggerManager.getInstance((Project)proj).getBreakpointManager();
        for (XSourcePosition position : XDebuggerUtilImpl.getAllCaretsPositions(proj, e.getDataContext())) {
            for (XLineBreakpointType breakpointType : breakpointTypes) {
                int line2;
                VirtualFile file2 = position.getFile();
                if (breakpointManager.findBreakpointAtLine(breakpointType, file2, line2 = position.getLine()) == null) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerSupport";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/ToggleLineBreakpointAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/ToggleLineBreakpointAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasLineBreakpoint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

