/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.settings.DataViewsConfigurable;
import com.intellij.xdebugger.impl.settings.MergedCompositeConfigurable;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerConfigurable
implements SearchableConfigurable.Parent {
    public static final String DISPLAY_NAME = XDebuggerBundle.message((String)"debugger.configurable.display.name", (Object[])new Object[0]);
    static final Configurable[] EMPTY_CONFIGURABLES = new Configurable[0];
    private static final DebuggerSettingsCategory[] MERGED_CATEGORIES = new DebuggerSettingsCategory[]{DebuggerSettingsCategory.STEPPING, DebuggerSettingsCategory.HOTSWAP};
    private Configurable myRootConfigurable;
    private Configurable[] myChildren;

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger";
    }

    @NotNull
    public Configurable[] getConfigurables() {
        this.compute();
        if (this.myChildren.length == 0 && this.myRootConfigurable instanceof SearchableConfigurable.Parent) {
            Configurable[] configurableArray = ((SearchableConfigurable.Parent)this.myRootConfigurable).getConfigurables();
            if (configurableArray == null) {
                DebuggerConfigurable.$$$reportNull$$$0(0);
            }
            return configurableArray;
        }
        if (this.myChildren == null) {
            DebuggerConfigurable.$$$reportNull$$$0(1);
        }
        return this.myChildren;
    }

    private void compute() {
        if (this.myChildren != null) {
            return;
        }
        SmartList configurables = new SmartList();
        configurables.add(new DataViewsConfigurable());
        DebuggerConfigurableProvider[] providers = (DebuggerConfigurableProvider[])DebuggerConfigurableProvider.EXTENSION_POINT.getExtensions();
        DebuggerConfigurable.computeMergedConfigurables(providers, (List<? super Configurable>)configurables);
        for (DebuggerConfigurableProvider provider : providers) {
            configurables.addAll(provider.getConfigurables(DebuggerSettingsCategory.ROOT));
        }
        MergedCompositeConfigurable mergedGeneralConfigurable = this.computeGeneralConfigurables(providers);
        if (configurables.isEmpty() && mergedGeneralConfigurable == null) {
            this.myRootConfigurable = null;
            this.myChildren = EMPTY_CONFIGURABLES;
        } else if (configurables.size() == 1) {
            Configurable firstConfigurable = (Configurable)configurables.get(0);
            if (mergedGeneralConfigurable == null) {
                this.myRootConfigurable = firstConfigurable;
                this.myChildren = EMPTY_CONFIGURABLES;
            } else {
                Configurable[] generalConfigurables = mergedGeneralConfigurable.children;
                Configurable[] mergedArray = new Configurable[generalConfigurables.length + 1];
                System.arraycopy(generalConfigurables, 0, mergedArray, 0, generalConfigurables.length);
                mergedArray[generalConfigurables.length] = firstConfigurable;
                this.myRootConfigurable = new MergedCompositeConfigurable(this.getId(), this.getDisplayName(), null, mergedArray);
                this.myChildren = firstConfigurable instanceof SearchableConfigurable.Parent ? ((SearchableConfigurable.Parent)firstConfigurable).getConfigurables() : EMPTY_CONFIGURABLES;
            }
        } else {
            this.myChildren = configurables.toArray(new Configurable[0]);
            this.myRootConfigurable = mergedGeneralConfigurable;
        }
    }

    private static void computeMergedConfigurables(@NotNull DebuggerConfigurableProvider[] providers, @NotNull List<? super Configurable> result2) {
        if (providers == null) {
            DebuggerConfigurable.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            DebuggerConfigurable.$$$reportNull$$$0(3);
        }
        for (DebuggerSettingsCategory category : MERGED_CATEGORIES) {
            List<Configurable> configurables = DebuggerConfigurable.getConfigurables(category, providers);
            if (configurables.isEmpty()) continue;
            String id = StringUtil.toLowerCase((String)category.name());
            result2.add((Configurable)new MergedCompositeConfigurable("debugger." + id, XDebuggerBundle.message((String)("debugger." + id + ".display.name"), (Object[])new Object[0]), DebuggerConfigurable.getDefaultCategoryHelpTopic(category), configurables.toArray(new Configurable[0])));
        }
    }

    @Nullable
    private MergedCompositeConfigurable computeGeneralConfigurables(@NotNull DebuggerConfigurableProvider[] providers) {
        List<Configurable> rootConfigurables;
        if (providers == null) {
            DebuggerConfigurable.$$$reportNull$$$0(4);
        }
        if ((rootConfigurables = DebuggerConfigurable.getConfigurables(DebuggerSettingsCategory.GENERAL, providers)).isEmpty()) {
            return null;
        }
        Configurable[] mergedRootConfigurables = rootConfigurables.toArray(new Configurable[0]);
        Arrays.sort(mergedRootConfigurables, (o1, o2) -> {
            boolean c1e = StringUtil.isEmpty((String)o1.getDisplayName());
            return c1e == StringUtil.isEmpty((String)o2.getDisplayName()) ? 0 : (c1e ? -1 : 1);
        });
        return new MergedCompositeConfigurable(this.getId(), this.getDisplayName(), null, mergedRootConfigurables);
    }

    public void apply() throws ConfigurationException {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.apply();
        }
    }

    public boolean hasOwnContent() {
        this.compute();
        return this.myRootConfigurable != null;
    }

    public JComponent createComponent() {
        this.compute();
        return this.myRootConfigurable != null ? this.myRootConfigurable.createComponent() : null;
    }

    public boolean isModified() {
        return this.myRootConfigurable != null && this.myRootConfigurable.isModified();
    }

    public void reset() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.disposeUIResources();
        }
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("project.propDebugger" == null) {
            DebuggerConfigurable.$$$reportNull$$$0(5);
        }
        return "project.propDebugger";
    }

    @NotNull
    static List<Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            DebuggerConfigurable.$$$reportNull$$$0(6);
        }
        List<Configurable> list2 = DebuggerConfigurable.getConfigurables(category, (DebuggerConfigurableProvider[])DebuggerConfigurableProvider.EXTENSION_POINT.getExtensions());
        if (list2 == null) {
            DebuggerConfigurable.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private static List<Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category, @NotNull DebuggerConfigurableProvider[] providers) {
        if (category == null) {
            DebuggerConfigurable.$$$reportNull$$$0(8);
        }
        if (providers == null) {
            DebuggerConfigurable.$$$reportNull$$$0(9);
        }
        List configurables = null;
        for (DebuggerConfigurableProvider provider : providers) {
            Collection providerConfigurables = provider.getConfigurables(category);
            if (providerConfigurables.isEmpty()) continue;
            if (configurables == null) {
                configurables = new SmartList();
            }
            configurables.addAll(providerConfigurables);
        }
        List list2 = ContainerUtil.notNullize(configurables);
        if (list2 == null) {
            DebuggerConfigurable.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static String getDefaultCategoryHelpTopic(DebuggerSettingsCategory category) {
        switch (category) {
            case STEPPING: {
                return "reference.idesettings.debugger.stepping";
            }
            case HOTSWAP: {
                return "reference.idesettings.debugger.hotswap";
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/settings/DebuggerConfigurable";
                break;
            }
            case 2: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/settings/DebuggerConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeMergedConfigurables";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeGeneralConfigurables";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

