/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSetOptions;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnexpectedAnchorInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Begin or end anchor in unexpected position" == null) {
            UnexpectedAnchorInspection.$$$reportNull$$$0(0);
        }
        return "Begin or end anchor in unexpected position";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnexpectedAnchorInspection.$$$reportNull$$$0(1);
        }
        UnexpectedAnchorVisitor unexpectedAnchorVisitor = new UnexpectedAnchorVisitor(holder);
        if (unexpectedAnchorVisitor == null) {
            UnexpectedAnchorInspection.$$$reportNull$$$0(2);
        }
        return unexpectedAnchorVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/inspection/UnexpectedAnchorInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/inspection/UnexpectedAnchorInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnexpectedAnchorVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        UnexpectedAnchorVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpBoundary(RegExpBoundary boundary) {
            super.visitRegExpBoundary(boundary);
            RegExpBoundary.Type type = boundary.getType();
            switch (type) {
                case BEGIN: {
                    if (UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, false, false)) break;
                    return;
                }
                case LINE_START: {
                    if (UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, false, true)) break;
                    return;
                }
                case END: 
                case END_NO_LINE_TERM: {
                    if (UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, true, false)) break;
                    return;
                }
                case LINE_END: {
                    if (UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, true, true)) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.myHolder.registerProblem((PsiElement)boundary, "Anchor <code>#ref</code> in unexpected position", new LocalQuickFix[0]);
        }

        private static boolean hasUnexpectedSibling(PsiElement element, boolean next, boolean line2) {
            PsiElement sibling;
            PsiElement psiElement = sibling = next ? PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, RegExpSetOptions.class}) : PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, RegExpSetOptions.class});
            if (sibling == null) {
                return false;
            }
            if (line2) {
                if (sibling instanceof RegExpChar) {
                    int value = ((RegExpChar)sibling).getValue();
                    return value != 10 && value != 13;
                }
                if (sibling instanceof RegExpSimpleClass) {
                    RegExpSimpleClass.Kind kind = ((RegExpSimpleClass)sibling).getKind();
                    switch (kind) {
                        case ANY: 
                        case NON_DIGIT: 
                        case NON_WORD: 
                        case SPACE: 
                        case NON_HORIZONTAL_SPACE: 
                        case NON_VERTICAL_SPACE: 
                        case NON_XML_NAME_START: 
                        case NON_XML_NAME_PART: 
                        case UNICODE_LINEBREAK: {
                            return false;
                        }
                    }
                    return true;
                }
                return sibling instanceof RegExpBoundary;
            }
            return true;
        }
    }
}

