/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.PatternValuesIndex;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.InjectionPlace;
import org.jetbrains.annotations.NotNull;

public class InjectionCache {
    private final CachedValue<Set<String>> myAnnoIndex;
    private final CachedValue<Collection<String>> myXmlIndex;
    private final Project myProject;

    public InjectionCache(@NotNull Project project) {
        if (project == null) {
            InjectionCache.$$$reportNull$$$0(0);
        }
        Configuration configuration = Configuration.getProjectInstance(project);
        this.myProject = project;
        this.myXmlIndex = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            THashMap map = new THashMap();
            for (BaseInjection injection : configuration.getInjections("java")) {
                for (InjectionPlace place : injection.getInjectionPlaces()) {
                    if (!place.isEnabled() || place.getElementPattern() == null) continue;
                    map.put(place.getElementPattern(), injection);
                }
            }
            Set stringSet = PatternValuesIndex.buildStringIndex(map.keySet());
            return new CachedValueProvider.Result((Object)stringSet, new Object[]{configuration});
        }, false);
        this.myAnnoIndex = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Set<String> result = this.collectMethodNamesWithLanguage(configuration.getAdvancedConfiguration().getLanguageAnnotationClass());
            return new CachedValueProvider.Result(result, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT, configuration});
        }, false);
    }

    @NotNull
    private Set<String> collectMethodNamesWithLanguage(String annotationClassName) {
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)this.myProject);
        GlobalSearchScope usageScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)allScope, (FileType[])new FileType[]{JavaFileType.INSTANCE});
        THashSet result = new THashSet();
        ArrayList annoClasses = ContainerUtil.newArrayList((Object[])JavaPsiFacade.getInstance((Project)this.myProject).findClasses(annotationClassName, allScope));
        for (int cursor = 0; cursor < annoClasses.size(); ++cursor) {
            AnnotatedElementsSearch.Parameters parameters = new AnnotatedElementsSearch.Parameters((PsiClass)annoClasses.get(cursor), (SearchScope)usageScope, true, new Class[]{PsiClass.class, PsiParameter.class, PsiMethod.class});
            AnnotatedElementsSearch.searchElements((AnnotatedElementsSearch.Parameters)parameters).forEach(arg_0 -> InjectionCache.lambda$collectMethodNamesWithLanguage$2((Set)result, annoClasses, arg_0));
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            InjectionCache.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    public static InjectionCache getInstance(Project project) {
        return (InjectionCache)ServiceManager.getService((Project)project, InjectionCache.class);
    }

    public Set<String> getAnnoIndex() {
        return (Set)this.myAnnoIndex.getValue();
    }

    public Collection<String> getXmlIndex() {
        return (Collection)this.myXmlIndex.getValue();
    }

    private static /* synthetic */ boolean lambda$collectMethodNamesWithLanguage$2(Set result, ArrayList annoClasses, PsiModifierListOwner element) {
        if (element instanceof PsiParameter) {
            PsiElement scope = ((PsiParameter)element).getDeclarationScope();
            if (scope instanceof PsiMethod) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiMethod)scope).getName());
            }
        } else if (element instanceof PsiClass && ((PsiClass)element).isAnnotationType() && !annoClasses.contains(element)) {
            annoClasses.add((PsiClass)element);
        } else if (element instanceof PsiMethod) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)((PsiMember)element).getName());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/java/InjectionCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/java/InjectionCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectMethodNamesWithLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

