/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.java.validation;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.psiutils.CollectionUtils;
import java.util.Arrays;
import java.util.Set;
import javax.swing.JComponent;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.util.AnnotateFix;
import org.intellij.plugins.intelliLang.util.AnnotationUtilEx;
import org.intellij.plugins.intelliLang.util.PsiUtilEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageMismatch
extends LocalInspectionTool {
    public boolean CHECK_NON_ANNOTATED_REFERENCES = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Flag usages of non-annotated elements where the usage context implies a certain language", (InspectionProfileEntry)this, "CHECK_NON_ANNOTATED_REFERENCES");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LanguageMismatch.$$$reportNull$$$0(0);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){
            final Pair<String, ? extends Set<String>> annotationName;
            {
                this.annotationName = Configuration.getProjectInstance(holder.getProject()).getAdvancedConfiguration().getLanguageAnnotationPair();
            }

            public void visitExpression(PsiExpression expression) {
                LanguageMismatch.this.checkExpression(expression, holder, this.annotationName);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                PsiElement element = expression.resolve();
                if (!(element instanceof PsiModifierListOwner)) {
                    return;
                }
                LanguageMismatch.this.checkExpression((PsiExpression)expression, holder, this.annotationName);
            }
        };
        if (javaElementVisitor == null) {
            LanguageMismatch.$$$reportNull$$$0(1);
        }
        return javaElementVisitor;
    }

    void checkExpression(PsiExpression expression, ProblemsHolder holder, Pair<String, ? extends Set<String>> annotationName) {
        PsiModifierListOwner declOwner;
        String expected;
        PsiAnnotation[] annotations;
        PsiType type = expression.getType();
        if (type == null || !PsiUtilEx.isStringOrStringArray(type)) {
            return;
        }
        PsiModifierListOwner contextOwner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.CONTEXT_ONLY);
        if (contextOwner != null && PsiUtilEx.isLanguageAnnotationTarget(contextOwner) && (annotations = AnnotationUtilEx.getAnnotationFrom(contextOwner, annotationName, true)).length > 0 && (expected = AnnotationUtilEx.calcAnnotationValue(annotations, "value")) != null && (declOwner = AnnotationUtilEx.getAnnotatedElementFor((PsiElement)expression, AnnotationUtilEx.LookupType.PREFER_DECLARATION)) != null && PsiUtilEx.isLanguageAnnotationTarget(declOwner)) {
            PsiAnnotation[] as = AnnotationUtilEx.getAnnotationFrom(declOwner, annotationName, true);
            if (as.length > 0) {
                String actual = AnnotationUtilEx.calcAnnotationValue(as, "value");
                if (!expected.equals(actual)) {
                    holder.registerProblem((PsiElement)expression, "Language mismatch: Expected '" + expected + "', got '" + actual + "'", new LocalQuickFix[0]);
                }
            } else if (this.CHECK_NON_ANNOTATED_REFERENCES) {
                PsiAssignmentExpression a;
                PsiExpressionList list;
                PsiElement var = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiVariable.class, PsiExpressionList.class, PsiAssignmentExpression.class});
                if (var instanceof PsiVariable ? ((PsiVariable)var).getInitializer() != expression : (var instanceof PsiExpressionList ? Arrays.asList((list = (PsiExpressionList)var).getExpressions()).indexOf(expression) == -1 : var instanceof PsiAssignmentExpression && (a = (PsiAssignmentExpression)var).getRExpression() != expression)) {
                    return;
                }
                if (declOwner instanceof PsiField && CollectionUtils.isConstantEmptyArray((PsiField)((PsiField)declOwner))) {
                    return;
                }
                if (AnnotateFix.canApplyOn(declOwner)) {
                    PsiAnnotation annotation = annotations[annotations.length - 1];
                    final String initializer = annotation.getParameterList().getText();
                    AnnotateFix fix = new AnnotateFix(annotation.getQualifiedName(), initializer){

                        @NotNull
                        public String getName() {
                            String string = initializer == null ? super.getName() : super.getName() + initializer;
                            if (string == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/java/validation/LanguageMismatch$2", "getName"));
                        }
                    };
                    holder.registerProblem((PsiElement)expression, "Language problem: Found non-annotated reference where '" + expected + "' is expected", new LocalQuickFix[]{fix});
                } else {
                    holder.registerProblem((PsiElement)expression, "Language problem: Found non-annotated reference where '" + expected + "' is expected", new LocalQuickFix[0]);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/java/validation/LanguageMismatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/java/validation/LanguageMismatch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

