/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlExtension {
    public static final ExtensionPointName<XmlExtension> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlExtension");

    public static XmlExtension getExtension(@NotNull PsiFile file) {
        if (file == null) {
            XmlExtension.$$$reportNull$$$0(0);
        }
        return (XmlExtension)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)XmlExtension.calcExtension(file), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static XmlExtension calcExtension(PsiFile file) {
        for (XmlExtension extension : EP_NAME.getExtensionList()) {
            if (!extension.isAvailable(file)) continue;
            return extension;
        }
        return DefaultXmlExtension.DEFAULT_EXTENSION;
    }

    public static XmlExtension getExtensionByElement(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            return XmlExtension.getExtension(psiFile);
        }
        return null;
    }

    public abstract boolean isAvailable(PsiFile var1);

    @NotNull
    public abstract List<TagInfo> getAvailableTagNames(@NotNull XmlFile var1, @NotNull XmlTag var2);

    @Nullable
    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new TagNameReference(nameElement, startTagFlag);
    }

    @Nullable
    public String[][] getNamespacesFromDocument(XmlDocument parent, boolean declarationsExist) {
        return declarationsExist ? (String[][])null : XmlUtil.getDefaultNamespaces(parent);
    }

    public boolean canBeDuplicated(XmlAttribute attribute) {
        return false;
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        return false;
    }

    public HighlightInfoType getHighlightInfoType(XmlFile file) {
        return HighlightInfoType.ERROR;
    }

    @Nullable
    public abstract SchemaPrefix getPrefixDeclaration(XmlTag var1, String var2);

    public SearchScope getNsPrefixScope(XmlAttribute declaration) {
        return new LocalSearchScope((PsiElement)declaration.getParent());
    }

    public boolean shouldBeHighlightedAsTag(XmlTag tag) {
        return true;
    }

    @Nullable
    public XmlElementDescriptor getElementDescriptor(XmlTag tag, XmlTag contextTag, XmlElementDescriptor parentDescriptor) {
        return parentDescriptor.getElementDescriptor(tag, contextTag);
    }

    @Nullable
    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        return element.getNSDescriptor(namespace, strict);
    }

    @Nullable
    public XmlTag getParentTagForNamespace(XmlTag tag, XmlNSDescriptor namespace) {
        return tag.getParentTag();
    }

    @Nullable
    public XmlFile getContainingFile(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    public XmlNSDescriptor getDescriptorFromDoctype(XmlFile containingFile, XmlNSDescriptor descr) {
        return descr;
    }

    public boolean hasDynamicComponents(PsiElement element) {
        return false;
    }

    public boolean isIndirectSyntax(XmlAttributeDescriptor descriptor) {
        return false;
    }

    public boolean shouldBeInserted(XmlAttributeDescriptor descriptor) {
        return descriptor.isRequired();
    }

    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    public AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlAttributeDescriptor descriptor, @NotNull String defaultAttributeQuote, @NotNull PsiElement context) {
        if (defaultAttributeQuote == null) {
            XmlExtension.$$$reportNull$$$0(1);
        }
        if (context == null) {
            XmlExtension.$$$reportNull$$$0(2);
        }
        return this.getAttributeValuePresentation(null, "", defaultAttributeQuote);
    }

    @NotNull
    public AttributeValuePresentation getAttributeValuePresentation(@Nullable XmlTag tag, @NotNull String attributeName, final @NotNull String defaultAttributeQuote) {
        if (attributeName == null) {
            XmlExtension.$$$reportNull$$$0(3);
        }
        if (defaultAttributeQuote == null) {
            XmlExtension.$$$reportNull$$$0(4);
        }
        AttributeValuePresentation attributeValuePresentation = new AttributeValuePresentation(){

            @Override
            @NotNull
            public String getPrefix() {
                String string = defaultAttributeQuote;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getPostfix() {
                String string = defaultAttributeQuote;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/xml/XmlExtension$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPrefix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPostfix";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (attributeValuePresentation == null) {
            XmlExtension.$$$reportNull$$$0(5);
        }
        return attributeValuePresentation;
    }

    public boolean isCustomTagAllowed(XmlTag tag) {
        return false;
    }

    public boolean useXmlTagInsertHandler() {
        return true;
    }

    public boolean isCollapsibleTag(XmlTag tag) {
        return false;
    }

    public boolean isSelfClosingTagAllowed(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlExtension.$$$reportNull$$$0(6);
        }
        return false;
    }

    public boolean isSingleTagException(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlExtension.$$$reportNull$$$0(7);
        }
        return false;
    }

    public static boolean shouldIgnoreSelfClosingTag(@NotNull XmlTag tag) {
        XmlExtension extension;
        if (tag == null) {
            XmlExtension.$$$reportNull$$$0(8);
        }
        return (extension = XmlExtension.getExtensionByElement((PsiElement)tag)) != null && extension.isSelfClosingTagAllowed(tag);
    }

    public static boolean isCollapsible(XmlTag tag) {
        XmlExtension extension = XmlExtension.getExtensionByElement((PsiElement)tag);
        return extension == null || extension.isCollapsibleTag(tag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttributeQuote";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/XmlExtension";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/XmlExtension";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValuePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuePresentation";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSelfClosingTagAllowed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSingleTagException";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreSelfClosingTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TagInfo {
        public final String name;
        public final String namespace;

        public TagInfo(String name, String namespace) {
            this.name = name;
            this.namespace = namespace;
        }

        @Nullable
        public PsiElement getDeclaration() {
            return null;
        }
    }

    public static interface AttributeValuePresentation {
        @NotNull
        public String getPrefix();

        @NotNull
        public String getPostfix();

        default public boolean showAutoPopup() {
            return true;
        }
    }
}

