/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.javaee.UriUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.util.XmlResourceResolver;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XercesAccessor;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateXmlActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.actions.validate.ValidateXmlAction");
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String GRAMMAR_FEATURE_ID = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final String ENTITY_MANAGER_PROPERTY_ID = "http://apache.org/xml/properties/internal/entity-manager";
    private static final Key<XMLGrammarPool> GRAMMAR_POOL_KEY = Key.create((String)"GrammarPoolKey");
    private static final Key<Long> GRAMMAR_POOL_TIME_STAMP_KEY = Key.create((String)"GrammarPoolTimeStampKey");
    private static final Key<VirtualFile[]> DEPENDENT_FILES_KEY = Key.create((String)"GrammarPoolFilesKey");
    private static final Key<String[]> KNOWN_NAMESPACES_KEY = Key.create((String)"KnownNamespacesKey");
    private static final Key<Map<String, XMLEntityManager.Entity>> ENTITIES_KEY = Key.create((String)"EntityManagerKey");
    public static final String JDK_XML_MAX_OCCUR_LIMIT = "jdk.xml.maxOccurLimit";
    private Project myProject;
    private XmlFile myFile;
    private ErrorReporter myErrorReporter;
    private SAXParser myParser;
    private XmlResourceResolver myXmlResourceResolver;
    private final boolean myForceChecking;
    @NonNls
    private static final String ENTITY_RESOLVER_PROPERTY_NAME = "http://apache.org/xml/properties/internal/entity-resolver";

    public ValidateXmlActionHandler(boolean _forceChecking) {
        this.myForceChecking = _forceChecking;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.myErrorReporter = errorReporter;
    }

    public VirtualFile getProblemFile(SAXParseException ex) {
        String publicId = ex.getPublicId();
        String systemId = ex.getSystemId();
        if (publicId == null) {
            if (systemId != null) {
                VirtualFile file;
                if (systemId.startsWith("file:/") && (file = VirtualFileManager.getInstance().findFileByUrl(systemId.startsWith("file://") ? systemId : systemId.replace("file:/", "file://"))) != null) {
                    return file;
                }
                String path = this.myXmlResourceResolver.getPathByPublicId(systemId);
                if (path != null) {
                    return UriUtil.findRelativeFile((String)path, null);
                }
                PsiFile file2 = this.myXmlResourceResolver.resolve(null, systemId);
                if (file2 != null) {
                    return file2.getVirtualFile();
                }
            }
            return this.myFile.getVirtualFile();
        }
        String path = this.myXmlResourceResolver.getPathByPublicId(publicId);
        if (path != null) {
            return UriUtil.findRelativeFile((String)path, null);
        }
        return null;
    }

    public String buildMessageString(SAXParseException ex) {
        String msg = "(" + ex.getLineNumber() + ":" + ex.getColumnNumber() + ") " + ex.getMessage();
        VirtualFile file = this.getProblemFile(ex);
        if (file != null && !file.equals(this.myFile.getVirtualFile())) {
            msg = file.getName() + ":" + msg;
        }
        return msg;
    }

    public void doValidate(XmlFile file) {
        this.myProject = file.getProject();
        this.myFile = file;
        this.myXmlResourceResolver = new XmlResourceResolver(this.myFile, this.myProject, this.myErrorReporter);
        this.myXmlResourceResolver.setStopOnUnDeclaredResource(this.myErrorReporter.isStopOnUndeclaredResource());
        try {
            try {
                this.myParser = this.createParser();
            }
            catch (Exception e) {
                this.filterAppException(e);
            }
            if (this.myParser == null) {
                return;
            }
            this.myErrorReporter.startProcessing();
        }
        catch (XmlResourceResolver.IgnoredResourceException e) {
        }
        catch (Exception exception) {
            this.filterAppException(exception);
        }
    }

    private void filterAppException(Exception exception) {
        if (!this.myErrorReporter.filterValidationException(exception)) {
            LOG.error((Throwable)exception);
        }
    }

    public void doParse() {
        try {
            InputSource inputSource = new InputSource(new StringReader(this.myFile.getText()));
            inputSource.setSystemId(this.myFile.getVirtualFile().getUrl().replace("file:", "file:/"));
            this.myParser.parse(inputSource, new DefaultHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                        ValidateXmlActionHandler.this.myErrorReporter.processError(e, ProblemType.WARNING);
                    }
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                        ValidateXmlActionHandler.this.myErrorReporter.processError(e, ProblemType.ERROR);
                    }
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                        ValidateXmlActionHandler.this.myErrorReporter.processError(e, ProblemType.FATAL);
                    }
                }

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    PsiFile psiFile = ValidateXmlActionHandler.this.myXmlResourceResolver.resolve(null, systemId);
                    if (psiFile == null) {
                        return null;
                    }
                    return new InputSource(new StringReader(psiFile.getText()));
                }

                @Override
                public void startDocument() throws SAXException {
                    super.startDocument();
                    ValidateXmlActionHandler.this.myParser.setProperty(ValidateXmlActionHandler.ENTITY_RESOLVER_PROPERTY_NAME, ValidateXmlActionHandler.this.myXmlResourceResolver);
                    ValidateXmlActionHandler.configureEntityManager(ValidateXmlActionHandler.this.myFile, ValidateXmlActionHandler.this.myParser);
                }
            });
            String[] resourcePaths = this.myXmlResourceResolver.getResourcePaths();
            if (resourcePaths.length > 0) {
                VirtualFile[] files = new VirtualFile[resourcePaths.length];
                for (int i = 0; i < resourcePaths.length; ++i) {
                    files[i] = UriUtil.findRelativeFile((String)resourcePaths[i], null);
                }
                this.myFile.putUserData(DEPENDENT_FILES_KEY, (Object)files);
                this.myFile.putUserData(GRAMMAR_POOL_TIME_STAMP_KEY, (Object)ValidateXmlActionHandler.calculateTimeStamp(files, this.myProject));
            }
            this.myFile.putUserData(KNOWN_NAMESPACES_KEY, (Object)ValidateXmlActionHandler.getNamespaces(this.myFile));
        }
        catch (SAXException e) {
            LOG.debug((Throwable)e);
        }
        catch (Exception exception) {
            this.filterAppException(exception);
        }
        catch (StackOverflowError stackOverflowError) {
            // empty catch block
        }
    }

    protected SAXParser createParser() throws SAXException, ParserConfigurationException {
        if (!(this.needsDtdChecking() || this.needsSchemaChecking() || this.myForceChecking)) {
            return null;
        }
        SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
        boolean schemaChecking = false;
        if (this.hasDtdDeclaration()) {
            factory.setValidating(true);
        }
        if (this.needsSchemaChecking()) {
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            try {
                factory.setXIncludeAware(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            schemaChecking = true;
        }
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SAXParser parser = factory.newSAXParser();
        parser.setProperty(ENTITY_RESOLVER_PROPERTY_NAME, this.myXmlResourceResolver);
        try {
            parser.getXMLReader().setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String property = System.getProperty(JDK_XML_MAX_OCCUR_LIMIT);
        if (property != null) {
            SecurityManager securityManager = (SecurityManager)parser.getProperty("http://apache.org/xml/properties/security-manager");
            securityManager.setMaxOccurNodeLimit(Integer.parseInt(property));
        }
        if (schemaChecking) {
            XMLGrammarPool grammarPool = ValidateXmlActionHandler.getGrammarPool(this.myFile, this.myForceChecking);
            ValidateXmlActionHandler.configureEntityManager(this.myFile, parser);
            parser.getXMLReader().setProperty(GRAMMAR_FEATURE_ID, grammarPool);
        }
        try {
            if (schemaChecking) {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                parser.getXMLReader().setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
                if (Boolean.TRUE.equals(Boolean.getBoolean("idea.xml.honour.all.schema.locations"))) {
                    parser.getXMLReader().setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
                }
                parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", Boolean.TRUE);
                parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", Boolean.TRUE);
            }
            parser.getXMLReader().setFeature("http://apache.org/xml/features/warn-on-duplicate-entitydef", Boolean.TRUE);
            parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/unparsed-entity-checking", Boolean.FALSE);
        }
        catch (SAXNotRecognizedException ex) {
            LOG.info("Xml parser installation seems screwed", (Throwable)ex);
        }
        return parser;
    }

    public static XMLGrammarPool getGrammarPool(XmlFile file, boolean forceChecking) {
        XMLGrammarPool previousGrammarPool = ValidateXmlActionHandler.getGrammarPool(file);
        XMLGrammarPool grammarPool = null;
        if (!forceChecking && !ValidateXmlActionHandler.isValidationDependentFilesOutOfDate(file)) {
            grammarPool = previousGrammarPool;
        }
        if (grammarPool == null) {
            ValidateXmlActionHandler.invalidateEntityManager(file);
            grammarPool = new XMLGrammarPoolImpl();
            file.putUserData(GRAMMAR_POOL_KEY, (Object)grammarPool);
        }
        return grammarPool;
    }

    @Nullable
    public static XMLGrammarPool getGrammarPool(XmlFile file) {
        return (XMLGrammarPool)file.getUserData(GRAMMAR_POOL_KEY);
    }

    public static boolean isValidationDependentFilesOutOfDate(XmlFile myFile) {
        long dependentFilesTimestamp;
        VirtualFile[] files = (VirtualFile[])myFile.getUserData(DEPENDENT_FILES_KEY);
        Long grammarPoolTimeStamp = (Long)myFile.getUserData(GRAMMAR_POOL_TIME_STAMP_KEY);
        Object[] ns = (String[])myFile.getUserData(KNOWN_NAMESPACES_KEY);
        if (!Arrays.equals(ns, ValidateXmlActionHandler.getNamespaces(myFile))) {
            return true;
        }
        return grammarPoolTimeStamp == null || files == null || (dependentFilesTimestamp = ValidateXmlActionHandler.calculateTimeStamp(files, myFile.getProject())) != grammarPoolTimeStamp;
    }

    private static void invalidateEntityManager(XmlFile file) {
        file.putUserData(ENTITIES_KEY, null);
    }

    private static void configureEntityManager(XmlFile file, SAXParser parser) throws SAXException {
        XMLEntityManager entityManager = (XMLEntityManager)parser.getXMLReader().getProperty(ENTITY_MANAGER_PROPERTY_ID);
        Map entities = (Map)file.getUserData(ENTITIES_KEY);
        if (entities != null) {
            Map<String, XMLEntityManager.Entity> map = XercesAccessor.getEntities(entityManager);
            for (Map.Entry entry : entities.entrySet()) {
                if (!((XMLEntityManager.Entity)entry.getValue()).isEntityDeclInExternalSubset()) continue;
                map.put((String)entry.getKey(), (XMLEntityManager.Entity)entry.getValue());
            }
        } else {
            file.putUserData(ENTITIES_KEY, XercesAccessor.getEntities(entityManager));
        }
    }

    private static String[] getNamespaces(XmlFile file) {
        XmlTag rootTag = file.getRootTag();
        if (rootTag == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        return (String[])ContainerUtil.mapNotNull((Object[])rootTag.getAttributes(), attribute -> attribute.getValue(), (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    private static long calculateTimeStamp(VirtualFile[] files, Project myProject) {
        long timestamp = 0L;
        for (VirtualFile file : files) {
            PsiFile psifile;
            if (file == null || !file.isValid() || (psifile = PsiManager.getInstance((Project)myProject).findFile(file)) == null || !psifile.isValid()) break;
            timestamp += psifile.getViewProvider().getModificationStamp();
        }
        return timestamp;
    }

    private boolean hasDtdDeclaration() {
        XmlDocument document = this.myFile.getDocument();
        if (document == null) {
            return false;
        }
        XmlProlog prolog = document.getProlog();
        if (prolog == null) {
            return false;
        }
        XmlDoctype doctype = prolog.getDoctype();
        return doctype != null;
    }

    private boolean needsDtdChecking() {
        XmlDocument document = this.myFile.getDocument();
        if (document == null) {
            return false;
        }
        return document.getProlog() != null && document.getProlog().getDoctype() != null;
    }

    private boolean needsSchemaChecking() {
        XmlAttribute[] attributes;
        XmlDocument document = this.myFile.getDocument();
        if (document == null) {
            return false;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return false;
        }
        for (XmlAttribute attribute : attributes = rootTag.getAttributes()) {
            if (!attribute.isNamespaceDeclaration()) continue;
            return true;
        }
        return false;
    }

    public static enum ProblemType {
        WARNING,
        ERROR,
        FATAL;

    }
}

