/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Experimental
public abstract class YamlUnknownValuesInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        if (holder == null) {
            YamlUnknownValuesInspectionBase.$$$reportNull$$$0(0);
        }
        if (metaTypeProvider == null) {
            YamlUnknownValuesInspectionBase.$$$reportNull$$$0(1);
        }
        ValuesChecker valuesChecker = new ValuesChecker(holder, metaTypeProvider);
        if (valuesChecker == null) {
            YamlUnknownValuesInspectionBase.$$$reportNull$$$0(2);
        }
        return valuesChecker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaTypeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlUnknownValuesInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlUnknownValuesInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ValuesChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        public ValuesChecker(@NotNull ProblemsHolder problemsHolder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
            if (problemsHolder == null) {
                ValuesChecker.$$$reportNull$$$0(0);
            }
            if (metaTypeProvider == null) {
                ValuesChecker.$$$reportNull$$$0(1);
            }
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLKeyValue(@NotNull YAMLKeyValue keyValue) {
            if (keyValue == null) {
                ValuesChecker.$$$reportNull$$$0(2);
            }
            if (keyValue.getKey() == null) {
                return;
            }
            YamlMetaTypeProvider.MetaTypeProxy meta = this.myMetaTypeProvider.getKeyValueMetaType(keyValue);
            if (meta == null) {
                return;
            }
            YAMLValue value = keyValue.getValue();
            if (value == null) {
                this.validateEmptyValue(meta.getField(), keyValue);
                return;
            }
            this.validateMultiplicity(meta, value);
            meta.getMetaType().validateKeyValue(keyValue, this.myProblemsHolder);
        }

        protected void validateMultiplicity(@NotNull YamlMetaTypeProvider.MetaTypeProxy meta, @NotNull YAMLValue value) {
            if (meta == null) {
                ValuesChecker.$$$reportNull$$$0(3);
            }
            if (value == null) {
                ValuesChecker.$$$reportNull$$$0(4);
            }
            if (meta.getField().isMany()) {
                this.requireMultiplicityMany(value);
            } else if (!meta.getField().hasRelationSpecificType(Field.Relation.SEQUENCE_ITEM)) {
                this.requireMultiplicityOne(value);
            }
        }

        protected void requireMultiplicityOne(@NotNull YAMLValue value) {
            if (value == null) {
                ValuesChecker.$$$reportNull$$$0(5);
            }
            if (value instanceof YAMLSequence) {
                for (YAMLSequenceItem next : ((YAMLSequence)value).getItems()) {
                    if (next.getValue() == null || !next.getKeysValues().isEmpty()) continue;
                    this.myProblemsHolder.registerProblem((PsiElement)next.getValue(), YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.not.allowed", ArrayUtil.EMPTY_OBJECT_ARRAY), new LocalQuickFix[0]);
                }
            }
        }

        protected void requireMultiplicityMany(@NotNull YAMLValue value) {
            if (value == null) {
                ValuesChecker.$$$reportNull$$$0(6);
            }
            if (value instanceof YAMLScalar) {
                this.myProblemsHolder.registerProblem((PsiElement)value, YAMLBundle.message("YamlUnknownValuesInspectionBase.error.array.is.required", ArrayUtil.EMPTY_OBJECT_ARRAY), new LocalQuickFix[0]);
            }
        }

        protected void validateEmptyValue(@NotNull Field feature, @NotNull YAMLKeyValue withoutValue) {
            if (feature == null) {
                ValuesChecker.$$$reportNull$$$0(7);
            }
            if (withoutValue == null) {
                ValuesChecker.$$$reportNull$$$0(8);
            }
            assert (withoutValue.getKey() != null);
            if (!feature.isEmptyValueAllowed()) {
                InspectionManager manager = this.myProblemsHolder.getManager();
                ProblemDescriptor eolError = manager.createProblemDescriptor(withoutValue.getKey(), YAMLBundle.message("YamlUnknownValuesInspectionBase.error.value.is.required", ArrayUtil.EMPTY_OBJECT_ARRAY), LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myProblemsHolder.isOnTheFly(), true);
                this.myProblemsHolder.registerProblem(eolError);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metaTypeProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "meta";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "feature";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "withoutValue";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlUnknownValuesInspectionBase$ValuesChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYAMLKeyValue";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateMultiplicity";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requireMultiplicityOne";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "requireMultiplicityMany";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateEmptyValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

