/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryCreator;
import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRepositoryManager
implements Disposable,
VcsListener {
    public static final Topic<VcsRepositoryMappingListener> VCS_REPOSITORY_MAPPING_UPDATED = Topic.create((String)"VCS repository mapping updated", VcsRepositoryMappingListener.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ReentrantReadWriteLock REPO_LOCK;
    @NotNull
    private final ReentrantReadWriteLock.WriteLock MODIFY_LOCK;
    @NotNull
    private final Map<VirtualFile, Repository> myRepositories;
    @NotNull
    private final Map<VirtualFile, Repository> myExternalRepositories;
    @NotNull
    private final List<VcsRepositoryCreator> myRepositoryCreators;
    private volatile boolean myDisposed;

    @NotNull
    public static VcsRepositoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(0);
        }
        VcsRepositoryManager vcsRepositoryManager = (VcsRepositoryManager)ObjectUtils.assertNotNull((Object)project.getComponent(VcsRepositoryManager.class));
        if (vcsRepositoryManager == null) {
            VcsRepositoryManager.$$$reportNull$$$0(1);
        }
        return vcsRepositoryManager;
    }

    public VcsRepositoryManager(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            VcsRepositoryManager.$$$reportNull$$$0(2);
        }
        if (vcsManager == null) {
            VcsRepositoryManager.$$$reportNull$$$0(3);
        }
        this.REPO_LOCK = new ReentrantReadWriteLock();
        this.MODIFY_LOCK = new ReentrantReadWriteLock().writeLock();
        this.myRepositories = new HashMap<VirtualFile, Repository>();
        this.myExternalRepositories = new HashMap<VirtualFile, Repository>();
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myRepositoryCreators = Arrays.asList(VcsRepositoryCreator.EXTENSION_POINT_NAME.getExtensions((AreaInstance)project));
        project.getMessageBus().connect().subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
    }

    public void dispose() {
        this.myDisposed = true;
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myRepositories.clear();
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void directoryMappingChanged() {
        this.checkAndUpdateRepositoriesCollection(null);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file) {
        if (file == null) {
            VcsRepositoryManager.$$$reportNull$$$0(4);
        }
        return this.getRepositoryForFile(file, false);
    }

    @Deprecated
    @Nullable
    public Repository getRepositoryForFileQuick(@NotNull VirtualFile file) {
        if (file == null) {
            VcsRepositoryManager.$$$reportNull$$$0(5);
        }
        return this.getRepositoryForFile(file, true);
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull VirtualFile file, boolean quick) {
        VcsRoot vcsRoot;
        if (file == null) {
            VcsRepositoryManager.$$$reportNull$$$0(6);
        }
        if ((vcsRoot = this.myVcsManager.getVcsRootObjectFor(file)) == null) {
            Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
            for (Map.Entry<VirtualFile, Repository> entry : repositories.entrySet()) {
                if (!entry.getKey().isValid() || !VfsUtilCore.isAncestor((VirtualFile)entry.getKey(), (VirtualFile)file, (boolean)false)) continue;
                return entry.getValue();
            }
            return null;
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getRepositoryForFile(@NotNull FilePath file, boolean quick) {
        VcsRoot vcsRoot;
        if (file == null) {
            VcsRepositoryManager.$$$reportNull$$$0(7);
        }
        if ((vcsRoot = this.myVcsManager.getVcsRootObjectFor(file)) == null) {
            Map<VirtualFile, Repository> repositories = this.getExternalRepositories();
            for (Map.Entry<VirtualFile, Repository> entry : repositories.entrySet()) {
                if (!entry.getKey().isValid() || !FileUtil.isAncestor((String)entry.getKey().getPath(), (String)file.getPath(), (boolean)false)) continue;
                return entry.getValue();
            }
            return null;
        }
        return quick ? this.getRepositoryForRootQuick(vcsRoot.getPath()) : this.getRepositoryForRoot(vcsRoot.getPath());
    }

    @Nullable
    public Repository getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, false);
    }

    @Nullable
    public Repository getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.getRepositoryForRoot(root, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Repository getRepositoryForRoot(@Nullable VirtualFile root, boolean updateIfNeeded) {
        if (root == null) {
            return null;
        }
        this.REPO_LOCK.readLock().lock();
        try {
            if (this.myDisposed) {
                throw new ProcessCanceledException();
            }
            Repository repo = this.myRepositories.get(root);
            if (repo != null) {
                Repository repository = repo;
                return repository;
            }
            Repository externalRepo = this.myExternalRepositories.get(root);
            if (externalRepo != null) {
                Repository repository = externalRepo;
                return repository;
            }
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
        if (updateIfNeeded && ArrayUtil.contains((Object)root, (Object[])this.myVcsManager.getAllVersionedRoots())) {
            this.checkAndUpdateRepositoriesCollection(root);
            this.REPO_LOCK.readLock().lock();
            try {
                Repository repository = this.myRepositories.get(root);
                return repository;
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
        }
        return null;
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull Repository repository) {
        if (root == null) {
            VcsRepositoryManager.$$$reportNull$$$0(8);
        }
        if (repository == null) {
            VcsRepositoryManager.$$$reportNull$$$0(9);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.put(root, repository);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        if (root == null) {
            VcsRepositoryManager.$$$reportNull$$$0(10);
        }
        this.REPO_LOCK.writeLock().lock();
        try {
            this.myExternalRepositories.remove(root);
        }
        finally {
            this.REPO_LOCK.writeLock().unlock();
        }
    }

    public boolean isExternal(@NotNull Repository repository) {
        if (repository == null) {
            VcsRepositoryManager.$$$reportNull$$$0(11);
        }
        this.REPO_LOCK.readLock().lock();
        try {
            boolean bl = !this.myRepositories.containsValue(repository) && this.myExternalRepositories.containsValue(repository);
            return bl;
        }
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    public Collection<Repository> getRepositories() {
        this.REPO_LOCK.readLock().lock();
        ArrayList<Repository> arrayList = new ArrayList<Repository>(this.myRepositories.values());
        ArrayList<Repository> arrayList2 = arrayList;
        if (arrayList2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(12);
        }
        return arrayList2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    @NotNull
    private Map<VirtualFile, Repository> getExternalRepositories() {
        this.REPO_LOCK.readLock().lock();
        HashMap<VirtualFile, Repository> hashMap = new HashMap<VirtualFile, Repository>(this.myExternalRepositories);
        HashMap<VirtualFile, Repository> hashMap2 = hashMap;
        if (hashMap2 == null) {
            VcsRepositoryManager.$$$reportNull$$$0(13);
        }
        return hashMap2;
        finally {
            this.REPO_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdateRepositoriesCollection(@Nullable VirtualFile checkedRoot) {
        this.MODIFY_LOCK.lock();
        try {
            HashMap<VirtualFile, Repository> repositories;
            this.REPO_LOCK.readLock().lock();
            try {
                repositories = new HashMap<VirtualFile, Repository>(this.myRepositories);
            }
            finally {
                this.REPO_LOCK.readLock().unlock();
            }
            if (checkedRoot != null && repositories.containsKey(checkedRoot)) {
                return;
            }
            Collection<VirtualFile> invalidRoots = this.findInvalidRoots(repositories.values());
            repositories.keySet().removeAll(invalidRoots);
            Map<VirtualFile, Repository> newRoots = this.findNewRoots(repositories.keySet());
            repositories.putAll(newRoots);
            this.REPO_LOCK.writeLock().lock();
            try {
                if (!this.myDisposed) {
                    for (VirtualFile file : this.myRepositories.keySet()) {
                        Repository newRepo;
                        Repository oldRepo = this.myRepositories.get(file);
                        if (oldRepo == (newRepo = (Repository)repositories.get(file))) continue;
                        Disposer.dispose((Disposable)oldRepo);
                    }
                    this.myRepositories.clear();
                    this.myRepositories.putAll(repositories);
                }
            }
            finally {
                this.REPO_LOCK.writeLock().unlock();
            }
        }
        finally {
            this.MODIFY_LOCK.unlock();
        }
        ((VcsRepositoryMappingListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, VCS_REPOSITORY_MAPPING_UPDATED)).mappingChanged();
    }

    @NotNull
    private Map<VirtualFile, Repository> findNewRoots(@NotNull Set<VirtualFile> knownRoots) {
        if (knownRoots == null) {
            VcsRepositoryManager.$$$reportNull$$$0(14);
        }
        HashMap<VirtualFile, Repository> newRootsMap = new HashMap<VirtualFile, Repository>();
        for (VcsRoot root : this.myVcsManager.getAllVcsRoots()) {
            Repository repository;
            AbstractVcs vcs;
            VcsRepositoryCreator repositoryCreator;
            VirtualFile rootPath = root.getPath();
            if (rootPath == null || knownRoots.contains(rootPath) || (repositoryCreator = this.getRepositoryCreator(vcs = root.getVcs())) == null || (repository = repositoryCreator.createRepositoryIfValid(rootPath, this)) == null) continue;
            newRootsMap.put(rootPath, repository);
        }
        HashMap<VirtualFile, Repository> hashMap = newRootsMap;
        if (hashMap == null) {
            VcsRepositoryManager.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    @NotNull
    private Collection<VirtualFile> findInvalidRoots(@NotNull Collection<Repository> repositories) {
        if (repositories == null) {
            VcsRepositoryManager.$$$reportNull$$$0(16);
        }
        ArrayList<VirtualFile> invalidRepos = new ArrayList<VirtualFile>();
        for (Repository repo : repositories) {
            VcsRoot vcsRoot = this.myVcsManager.getVcsRootObjectFor(repo.getRoot());
            if (vcsRoot != null && repo.getRoot().equals(vcsRoot.getPath()) && repo.getVcs().equals((Object)vcsRoot.getVcs())) continue;
            invalidRepos.add(repo.getRoot());
        }
        ArrayList<VirtualFile> arrayList = invalidRepos;
        if (arrayList == null) {
            VcsRepositoryManager.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @Nullable
    private VcsRepositoryCreator getRepositoryCreator(@Nullable AbstractVcs vcs) {
        if (vcs == null) {
            return null;
        }
        return (VcsRepositoryCreator)ContainerUtil.find(this.myRepositoryCreators, creator -> creator.getVcsKey().equals((Object)vcs.getKeyInstanceMethod()));
    }

    @NotNull
    public String toString() {
        String string = "RepositoryManager{myRepositories: " + this.myRepositories + '}';
        if (string == null) {
            VcsRepositoryManager.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/VcsRepositoryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownRoots";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/VcsRepositoryManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalRepositories";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findNewRoots";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findInvalidRoots";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryForFileQuick";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addExternalRepository";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeExternalRepository";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isExternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findNewRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findInvalidRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

