/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.PatchFileHeaderInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.log.impl.VcsUserImpl;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

public class PatchFileHeaderParser {
    @NonNls
    private static final Pattern ourBaseRevisionPattern = Pattern.compile("From\\s+([0-9a-fA-F]+)\\s+.*");
    @NonNls
    private static final Pattern ourAuthorPattern = Pattern.compile("From:\\s+(.*?)\\s*(?:<(.*)>\\s*)?");
    @NonNls
    private static final Pattern ourSubjectPattern = Pattern.compile("Subject:(?:\\s+\\[PATCH.*])?\\s*(.+)");
    @NonNls
    private static final Pattern ourHeaderEndMarker = Pattern.compile("---\\s*");

    public static PatchFileHeaderInfo parseHeader(Iterator<String> iterator) {
        String lineSeparator = "\n";
        StringBuilder message = new StringBuilder();
        VcsUserImpl author = null;
        String revision = null;
        boolean treatAllAsMessageLine = false;
        while (iterator.hasNext()) {
            String curLine = iterator.next();
            Matcher revisionMatcher = ourBaseRevisionPattern.matcher(curLine);
            Matcher authorMatcher = ourAuthorPattern.matcher(curLine);
            Matcher subjectMatcher = ourSubjectPattern.matcher(curLine);
            Matcher endHeaderMatcher = ourHeaderEndMarker.matcher(curLine);
            if (endHeaderMatcher.matches()) break;
            if (treatAllAsMessageLine) {
                message.append(lineSeparator).append(curLine);
                continue;
            }
            if (revisionMatcher.matches()) {
                revision = revisionMatcher.group(1);
                continue;
            }
            if (authorMatcher.matches()) {
                author = new VcsUserImpl(authorMatcher.group(1), (String)ObjectUtils.chooseNotNull((Object)authorMatcher.group(2), (Object)""));
                continue;
            }
            if (!subjectMatcher.matches()) continue;
            message.append(subjectMatcher.group(1));
            treatAllAsMessageLine = true;
        }
        return new PatchFileHeaderInfo(message.toString().trim(), author, revision);
    }
}

