/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCurrentRevisionProxy
implements ByteBackedContentRevision {
    @NotNull
    private final DiffProvider myDiffProvider;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsKey myVcsKey;

    @Nullable
    public static VcsCurrentRevisionProxy create(@NotNull VirtualFile file, @NotNull Project project) {
        DiffProvider diffProvider;
        AbstractVcs vcs;
        if (file == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(0);
        }
        if (project == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(1);
        }
        if ((vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file)) != null && (diffProvider = vcs.getDiffProvider()) != null) {
            return new VcsCurrentRevisionProxy(diffProvider, file, project, vcs.getKeyInstanceMethod());
        }
        return null;
    }

    private VcsCurrentRevisionProxy(@NotNull DiffProvider diffProvider, @NotNull VirtualFile file, @NotNull Project project, @NotNull VcsKey vcsKey) {
        if (diffProvider == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(2);
        }
        if (file == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(3);
        }
        if (project == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(4);
        }
        if (vcsKey == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(5);
        }
        this.myDiffProvider = diffProvider;
        this.myFile = file;
        this.myProject = project;
        this.myVcsKey = vcsKey;
    }

    @Nullable
    public String getContent() throws VcsException {
        return ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.getFile(), (Charset)this.myFile.getCharset());
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        return (byte[])this.getVcsRevision().second;
    }

    @NotNull
    public FilePath getFile() {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)this.myFile);
        if (filePath == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(6);
        }
        return filePath;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        VcsRevisionNumber vcsRevisionNumber;
        try {
            vcsRevisionNumber = (VcsRevisionNumber)this.getVcsRevision().first;
        }
        catch (VcsException ex) {
            VcsRevisionNumber vcsRevisionNumber2 = VcsRevisionNumber.NULL;
            if (vcsRevisionNumber2 == null) {
                VcsCurrentRevisionProxy.$$$reportNull$$$0(8);
            }
            return vcsRevisionNumber2;
        }
        if (vcsRevisionNumber == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(7);
        }
        return vcsRevisionNumber;
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> getVcsRevision() throws VcsException {
        Pair pair;
        try {
            pair = ContentRevisionCache.getOrLoadCurrentAsBytes((Project)this.myProject, (FilePath)this.getFile(), (VcsKey)this.myVcsKey, (CurrentRevisionProvider)new CurrentRevisionProvider(){

                public VcsRevisionNumber getCurrentRevision() throws VcsException {
                    return VcsCurrentRevisionProxy.this.getCurrentRevisionNumber();
                }

                public Pair<VcsRevisionNumber, byte[]> get() throws VcsException {
                    return VcsCurrentRevisionProxy.this.loadContent();
                }
            });
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
        if (pair == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @NotNull
    private VcsRevisionNumber getCurrentRevisionNumber() throws VcsException {
        VcsRevisionNumber currentRevision = this.myDiffProvider.getCurrentRevision(this.myFile);
        if (currentRevision == null) {
            throw new VcsException("Failed to fetch current revision");
        }
        VcsRevisionNumber vcsRevisionNumber = currentRevision;
        if (vcsRevisionNumber == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(10);
        }
        return vcsRevisionNumber;
    }

    @NotNull
    private Pair<VcsRevisionNumber, byte[]> loadContent() throws VcsException {
        byte[] bytes;
        VcsRevisionNumber currentRevision = this.getCurrentRevisionNumber();
        ContentRevision contentRevision = this.myDiffProvider.createFileContent(currentRevision, this.myFile);
        if (contentRevision == null) {
            throw new VcsException("Failed to create content for current revision");
        }
        if (contentRevision instanceof ByteBackedContentRevision) {
            bytes = ((ByteBackedContentRevision)contentRevision).getContentAsBytes();
        } else {
            String content = contentRevision.getContent();
            if (content == null) {
                throw new VcsException("Can't get revision content");
            }
            bytes = content.getBytes(this.myFile.getCharset());
        }
        Pair pair = Pair.create((Object)currentRevision, (Object)bytes);
        if (pair == null) {
            VcsCurrentRevisionProxy.$$$reportNull$$$0(11);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsCurrentRevisionProxy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionNumber";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsRevision";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentRevisionNumber";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

