/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.NotNullFunction;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesViewContentManager
implements ChangesViewContentI,
Disposable {
    public static final String TOOLWINDOW_ID = ToolWindowId.VCS;
    private static final Key<ChangesViewContentEP> myEPKey = Key.create((String)"ChangesViewContentEP");
    private MyContentManagerListener myContentManagerListener;
    @NotNull
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private ContentManager myContentManager;
    private final Alarm myVcsChangeAlarm;
    private final List<Content> myAddedContents;
    @NotNull
    private final CountDownLatch myInitializationWaiter;
    public static final Key<Integer> ORDER_WEIGHT_KEY = Key.create((String)"ChangesView.ContentOrderWeight");
    public static final String LOCAL_CHANGES = "Local Changes";
    public static final String REPOSITORY = "Repository";
    public static final String INCOMING = "Incoming";
    public static final String SHELF = "Shelf";

    public static ChangesViewContentI getInstance(Project project) {
        return (ChangesViewContentI)project.getComponent(ChangesViewContentI.class);
    }

    public ChangesViewContentManager(@NotNull Project project, ProjectLevelVcsManager vcsManager) {
        if (project == null) {
            ChangesViewContentManager.$$$reportNull$$$0(0);
        }
        this.myAddedContents = new ArrayList<Content>();
        this.myInitializationWaiter = new CountDownLatch(1);
        this.myProject = project;
        this.myVcsManager = vcsManager;
        this.myVcsChangeAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new MyVcsListener());
    }

    @Override
    public void setUp(ToolWindow toolWindow) {
        final ContentManager contentManager = toolWindow.getContentManager();
        this.myContentManagerListener = new MyContentManagerListener();
        contentManager.addContentManagerListener((ContentManagerListener)this.myContentManagerListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                contentManager.removeContentManagerListener((ContentManagerListener)ChangesViewContentManager.this.myContentManagerListener);
            }
        });
        this.loadExtensionTabs();
        this.myContentManager = contentManager;
        for (Content content : this.myAddedContents) {
            this.addIntoCorrectPlace(content);
        }
        this.myAddedContents.clear();
        if (contentManager.getContentCount() > 0) {
            contentManager.setSelectedContent(contentManager.getContent(0));
        }
        this.myInitializationWaiter.countDown();
    }

    private void loadExtensionTabs() {
        LinkedList<Content> contentList = new LinkedList<Content>();
        for (ChangesViewContentEP ep : ChangesViewContentEP.EP_NAME.getExtensionList((AreaInstance)this.myProject)) {
            NotNullFunction<Project, Boolean> predicate = ep.newPredicateInstance(this.myProject);
            if (predicate != null && !((Boolean)predicate.fun((Object)this.myProject)).equals(Boolean.TRUE)) continue;
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new ContentStub(ep), ep.getTabName(), false);
            content.setCloseable(false);
            content.putUserData(myEPKey, (Object)ep);
            contentList.add(content);
        }
        this.myAddedContents.addAll(0, contentList);
    }

    private void addExtensionTab(ChangesViewContentEP ep) {
        Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)new ContentStub(ep), ep.getTabName(), false);
        content.setCloseable(false);
        content.putUserData(myEPKey, (Object)ep);
        this.addIntoCorrectPlace(content);
    }

    private void updateExtensionTabs() {
        ChangesViewContentEP[] contentEPs;
        for (ChangesViewContentEP ep : contentEPs = (ChangesViewContentEP[])ChangesViewContentEP.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            NotNullFunction<Project, Boolean> predicate = ep.newPredicateInstance(this.myProject);
            if (predicate == null) continue;
            Content epContent = this.findEPContent(ep);
            Boolean predicateResult = (Boolean)predicate.fun((Object)this.myProject);
            if (predicateResult.equals(Boolean.TRUE) && epContent == null) {
                this.addExtensionTab(ep);
                continue;
            }
            if (!predicateResult.equals(Boolean.FALSE) || epContent == null) continue;
            this.myContentManager.removeContent(epContent, true);
        }
    }

    @Nullable
    private Content findEPContent(ChangesViewContentEP ep) {
        Content[] contents;
        for (Content content : contents = this.myContentManager.getContents()) {
            if (content.getUserData(myEPKey) != ep) continue;
            return content;
        }
        return null;
    }

    private void updateToolWindowAvailability() {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(TOOLWINDOW_ID);
        if (toolWindow != null) {
            boolean available = this.isAvailable();
            if (available && !toolWindow.isAvailable()) {
                toolWindow.setShowStripeButton(true);
            }
            toolWindow.setAvailable(available, null);
        }
    }

    @Override
    public boolean isAvailable() {
        List mappings = this.myVcsManager.getDirectoryMappings();
        return mappings.stream().anyMatch(mapping -> !StringUtil.isEmpty((String)mapping.getVcs()));
    }

    public void dispose() {
        for (Content content : this.myAddedContents) {
            Disposer.dispose((Disposable)content);
        }
        this.myAddedContents.clear();
        this.myVcsChangeAlarm.cancelAllRequests();
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ChangesViewContentManager" == null) {
            ChangesViewContentManager.$$$reportNull$$$0(1);
        }
        return "ChangesViewContentManager";
    }

    @Override
    public void addContent(Content content) {
        if (this.myContentManager == null) {
            this.myAddedContents.add(content);
        } else {
            this.addIntoCorrectPlace(content);
        }
    }

    @Override
    public void removeContent(Content content) {
        if (this.myContentManager != null && !this.myContentManager.isDisposed()) {
            this.myContentManager.removeContent(content, true);
        }
    }

    @Override
    public void setSelectedContent(Content content) {
        if (this.myContentManager == null) {
            return;
        }
        this.myContentManager.setSelectedContent(content);
    }

    @Override
    @Nullable
    public <T> T getActiveComponent(Class<T> aClass) {
        if (this.myContentManager == null) {
            return null;
        }
        Content content = this.myContentManager.getSelectedContent();
        if (content != null && aClass.isInstance(content.getComponent())) {
            return (T)content.getComponent();
        }
        return null;
    }

    public boolean isContentSelected(@NotNull String contentName) {
        if (contentName == null) {
            ChangesViewContentManager.$$$reportNull$$$0(2);
        }
        if (this.myContentManager == null) {
            return false;
        }
        Content selectedContent = this.myContentManager.getSelectedContent();
        if (selectedContent == null) {
            return false;
        }
        return Comparing.equal((String)contentName, (String)selectedContent.getTabName());
    }

    @Override
    public void selectContent(@NotNull String tabName) {
        if (tabName == null) {
            ChangesViewContentManager.$$$reportNull$$$0(3);
        }
        this.selectContent(tabName, false);
    }

    public void selectContent(@NotNull String tabName, boolean requestFocus) {
        if (tabName == null) {
            ChangesViewContentManager.$$$reportNull$$$0(4);
        }
        if (this.myContentManager == null) {
            return;
        }
        for (Content content : this.myContentManager.getContents()) {
            if (!content.getDisplayName().equals(tabName)) continue;
            this.myContentManager.setSelectedContent(content, requestFocus);
            break;
        }
    }

    private void addIntoCorrectPlace(Content content) {
        int weight = ChangesViewContentManager.getContentWeight(content);
        Content[] contents = this.myContentManager.getContents();
        int index = -1;
        for (int i = 0; i < contents.length; ++i) {
            int oldWeight = ChangesViewContentManager.getContentWeight(contents[i]);
            if (oldWeight <= weight) continue;
            index = i;
            break;
        }
        if (index == -1) {
            index = contents.length;
        }
        this.myContentManager.addContent(content, index);
    }

    private static int getContentWeight(Content content) {
        Integer userData = (Integer)content.getUserData(ORDER_WEIGHT_KEY);
        if (userData != null) {
            return userData;
        }
        String tabName = content.getTabName();
        for (TabOrderWeight value : TabOrderWeight.values()) {
            if (value.getName() == null || !value.getName().equals(tabName)) continue;
            return value.getWeight();
        }
        return TabOrderWeight.OTHER.getWeight();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isContentSelected";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TabOrderWeight {
        LOCAL_CHANGES("Local Changes", 10),
        REPOSITORY("Repository", 20),
        INCOMING("Incoming", 30),
        SHELF("Shelf", 40),
        OTHER(null, 100);

        @Nullable
        private final String myName;
        private final int myWeight;

        private TabOrderWeight(String name, int weight) {
            this.myName = name;
            this.myWeight = weight;
        }

        @Nullable
        private String getName() {
            return this.myName;
        }

        public int getWeight() {
            return this.myWeight;
        }
    }

    private class MyContentManagerListener
    extends ContentManagerAdapter {
        private MyContentManagerListener() {
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            Content content;
            if (event == null) {
                MyContentManagerListener.$$$reportNull$$$0(0);
            }
            if ((content = event.getContent()).getComponent() instanceof ContentStub) {
                ChangesViewContentEP ep = ((ContentStub)content.getComponent()).getEP();
                final ChangesViewContentProvider provider = ep.getInstance(ChangesViewContentManager.this.myProject);
                JComponent contentComponent = provider.initContent();
                content.setComponent(contentComponent);
                content.setDisposer(new Disposable(){

                    public void dispose() {
                        provider.disposeContent();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/changes/ui/ChangesViewContentManager$MyContentManagerListener", "selectionChanged"));
        }
    }

    private static class ContentStub
    extends JPanel {
        private final ChangesViewContentEP myEP;

        private ContentStub(ChangesViewContentEP EP) {
            this.myEP = EP;
        }

        public ChangesViewContentEP getEP() {
            return this.myEP;
        }
    }

    private class MyVcsListener
    implements VcsListener {
        private MyVcsListener() {
        }

        public void directoryMappingChanged() {
            ChangesViewContentManager.this.myVcsChangeAlarm.cancelAllRequests();
            ChangesViewContentManager.this.myVcsChangeAlarm.addRequest(() -> {
                if (ChangesViewContentManager.this.myProject.isDisposed()) {
                    return;
                }
                ChangesViewContentManager.this.updateToolWindowAvailability();
                if (ChangesViewContentManager.this.myContentManager != null) {
                    ChangesViewContentManager.this.updateExtensionTabs();
                }
            }, 100, ModalityState.NON_MODAL);
        }
    }
}

