/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogIndexService;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsUserRegistry;
import com.intellij.vcs.log.data.SingleTaskController;
import com.intellij.vcs.log.data.VcsLogProgress;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IntListDataExternalizer;
import com.intellij.vcs.log.data.index.LongPairDataExternalizer;
import com.intellij.vcs.log.data.index.VcsLogBigRepositoriesList;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.data.index.VcsLogMessagesTrigramIndex;
import com.intellij.vcs.log.data.index.VcsLogModifiableIndex;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogUserIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.impl.HeavyAwareExecutor;
import com.intellij.vcs.log.impl.VcsIndexableLogProvider;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import com.intellij.vcs.log.statistics.VcsLogIndexCollector;
import com.intellij.vcs.log.util.PersistentSet;
import com.intellij.vcs.log.util.PersistentSetImpl;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StopWatch;
import com.intellij.vcs.log.util.StorageId;
import com.intellij.vcs.log.util.TroveUtil;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogPersistentIndex
implements VcsLogModifiableIndex,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogPersistentIndex.class);
    private static final int VERSION = 14;
    private static final VcsLogProgress.ProgressKey INDEXING = new VcsLogProgress.ProgressKey("index");
    @NotNull
    private final Project myProject;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;
    @NotNull
    private final VcsLogProgress myProgress;
    @NotNull
    private final Map<VirtualFile, VcsLogIndexer> myIndexers;
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Set<VirtualFile> myRoots;
    @NotNull
    private final VcsLogBigRepositoriesList myBigRepositoriesList;
    @NotNull
    private final VcsLogIndexCollector myIndexCollector;
    @Nullable
    private final IndexStorage myIndexStorage;
    @Nullable
    private final IndexDataGetter myDataGetter;
    @NotNull
    private final SingleTaskController<IndexingRequest, Void> mySingleTaskController;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myNumberOfTasks;
    @NotNull
    private final Map<VirtualFile, AtomicLong> myIndexingTime;
    @NotNull
    private final Map<VirtualFile, AtomicInteger> myIndexingLimit;
    @NotNull
    private final List<VcsLogIndex.IndexingFinishedListener> myListeners;
    @NotNull
    private Map<VirtualFile, TIntHashSet> myCommitsToIndex;

    public VcsLogPersistentIndex(@NotNull Project project, @NotNull VcsLogStorage storage, @NotNull VcsLogProgress progress, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull FatalErrorHandler fatalErrorsConsumer, @NotNull Disposable disposableParent) {
        if (project == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(1);
        }
        if (progress == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(2);
        }
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(3);
        }
        if (fatalErrorsConsumer == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(4);
        }
        if (disposableParent == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(5);
        }
        this.myNumberOfTasks = new HashMap<VirtualFile, AtomicInteger>();
        this.myIndexingTime = new HashMap<VirtualFile, AtomicLong>();
        this.myIndexingLimit = new HashMap<VirtualFile, AtomicInteger>();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCommitsToIndex = new HashMap<VirtualFile, TIntHashSet>();
        this.myStorage = storage;
        this.myProject = project;
        this.myProgress = progress;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
        this.myBigRepositoriesList = VcsLogBigRepositoriesList.getInstance();
        this.myIndexCollector = VcsLogIndexCollector.getInstance(this.myProject);
        this.myIndexers = VcsLogPersistentIndex.getAvailableIndexers(providers);
        this.myRoots = new LinkedHashSet<VirtualFile>(this.myIndexers.keySet());
        VcsUserRegistry userRegistry = (VcsUserRegistry)ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        this.myIndexStorage = this.createIndexStorage(fatalErrorsConsumer, PersistentUtil.calcLogId(this.myProject, providers), userRegistry);
        this.myDataGetter = this.myIndexStorage != null ? new IndexDataGetter(this.myProject, this.myRoots, this.myIndexStorage, this.myStorage, this.myFatalErrorsConsumer) : null;
        for (VirtualFile root : this.myRoots) {
            this.myNumberOfTasks.put(root, new AtomicInteger());
            this.myIndexingTime.put(root, new AtomicLong());
            this.myIndexingLimit.put(root, new AtomicInteger(VcsLogPersistentIndex.getIndexingLimit()));
        }
        this.mySingleTaskController = new MySingleTaskController(project, (Disposable)(this.myIndexStorage != null ? this.myIndexStorage : this));
        Disposer.register((Disposable)disposableParent, (Disposable)this);
    }

    private static int getIndexingLimit() {
        return Math.max(1, Registry.intValue((String)"vcs.log.index.limit.minutes"));
    }

    protected IndexStorage createIndexStorage(@NotNull FatalErrorHandler fatalErrorHandler, @NotNull String logId, @NotNull VcsUserRegistry registry) {
        if (fatalErrorHandler == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(6);
        }
        if (logId == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(7);
        }
        if (registry == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(8);
        }
        try {
            return (IndexStorage)IOUtil.openCleanOrResetBroken(() -> new IndexStorage(logId, this.myStorage, registry, fatalErrorHandler, this), () -> IndexStorage.cleanup(logId));
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return null;
        }
    }

    @Override
    public void scheduleIndex(boolean full) {
        this.doScheduleIndex(full, (Consumer<IndexingRequest>)((Consumer)request -> this.mySingleTaskController.request((IndexingRequest[])new IndexingRequest[]{request})));
    }

    void indexNow(boolean full) {
        this.doScheduleIndex(full, (Consumer<IndexingRequest>)((Consumer)request -> request.run(this.myProgress.createProgressIndicator(INDEXING))));
    }

    private synchronized void doScheduleIndex(boolean full, @NotNull Consumer<IndexingRequest> requestConsumer) {
        boolean isFull;
        if (requestConsumer == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(9);
        }
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (this.myCommitsToIndex.isEmpty() || this.myIndexStorage == null) {
            return;
        }
        if (this.myIndexStorage.isFresh() && !full) {
            return;
        }
        Map<VirtualFile, TIntHashSet> commitsToIndex = this.myCommitsToIndex;
        this.myCommitsToIndex = new HashMap<VirtualFile, TIntHashSet>();
        boolean bl = isFull = full && this.myIndexStorage.isFresh();
        if (isFull) {
            LOG.debug("Index storage for project " + this.myProject.getName() + " is fresh, scheduling full reindex");
        }
        for (VirtualFile root : commitsToIndex.keySet()) {
            TIntHashSet commits = commitsToIndex.get(root);
            if (commits.isEmpty()) continue;
            if (this.myBigRepositoriesList.isBig(root)) {
                this.myCommitsToIndex.put(root, commits);
                LOG.info("Indexing repository " + root.getName() + " is skipped since it is too big");
                continue;
            }
            requestConsumer.consume((Object)new IndexingRequest(root, this.myIndexStorage.paths.getPathsEncoder(), commits, isFull));
        }
        if (isFull) {
            this.myIndexCollector.reportFreshIndex();
            this.myIndexStorage.unmarkFresh();
        }
    }

    private void storeDetail(@NotNull VcsLogIndexer.CompressedDetails detail) {
        if (detail == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(10);
        }
        if (this.myIndexStorage == null) {
            return;
        }
        try {
            int index = this.myStorage.getCommitIndex((Hash)detail.getId(), detail.getRoot());
            this.myIndexStorage.messages.put((Object)index, (Object)detail.getFullMessage());
            this.myIndexStorage.trigrams.update(index, detail);
            this.myIndexStorage.users.update(index, detail);
            this.myIndexStorage.paths.update(index, detail);
            this.myIndexStorage.parents.put((Object)index, (Object)ContainerUtil.map((Collection)detail.getParents(), p -> this.myStorage.getCommitIndex((Hash)p, detail.getRoot())));
            if (!detail.getAuthor().equals(detail.getCommitter())) {
                this.myIndexStorage.committers.put((Object)index, (Object)this.myIndexStorage.users.getUserId(detail.getCommitter()));
            }
            this.myIndexStorage.timestamps.put((Object)index, (Object)Pair.create((Object)detail.getAuthorTime(), (Object)detail.getCommitTime()));
            this.myIndexStorage.commits.put(index);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    private void flush() {
        try {
            if (this.myIndexStorage != null) {
                this.myIndexStorage.messages.force();
                this.myIndexStorage.trigrams.flush();
                this.myIndexStorage.users.flush();
                this.myIndexStorage.paths.flush();
                this.myIndexStorage.parents.force();
                this.myIndexStorage.commits.flush();
                this.myIndexStorage.committers.force();
                this.myIndexStorage.timestamps.force();
            }
        }
        catch (StorageException e) {
            this.myFatalErrorsConsumer.consume(this, e);
        }
    }

    @Override
    public void markCorrupted() {
        if (this.myIndexStorage != null) {
            this.myIndexStorage.commits.markCorrupted();
        }
    }

    @Override
    public boolean isIndexed(int commit2) {
        try {
            return this.myIndexStorage == null || this.myIndexStorage.commits.contains(commit2);
        }
        catch (IOException e) {
            this.myFatalErrorsConsumer.consume(this, e);
            return false;
        }
    }

    @Override
    public synchronized boolean isIndexed(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(11);
        }
        return this.isIndexingEnabled(root) && !this.myCommitsToIndex.containsKey(root) && this.myNumberOfTasks.get(root).get() == 0;
    }

    @Override
    public boolean isIndexingEnabled(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(12);
        }
        if (this.myIndexStorage == null) {
            return false;
        }
        return this.myRoots.contains(root) && !this.myBigRepositoriesList.isBig(root);
    }

    @Override
    public synchronized void markForIndexing(int index, @NotNull VirtualFile root) {
        if (root == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(13);
        }
        if (this.isIndexed(index) || !this.myRoots.contains(root)) {
            return;
        }
        TroveUtil.add(this.myCommitsToIndex, root, index);
    }

    @Override
    @Nullable
    public IndexDataGetter getDataGetter() {
        if (this.myIndexStorage == null) {
            return null;
        }
        return this.myDataGetter;
    }

    @Override
    public void addListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(14);
        }
        this.myListeners.add(l);
    }

    @Override
    public void removeListener(@NotNull VcsLogIndex.IndexingFinishedListener l) {
        if (l == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(15);
        }
        this.myListeners.remove(l);
    }

    public void dispose() {
    }

    @NotNull
    private static Map<VirtualFile, VcsLogIndexer> getAvailableIndexers(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(16);
        }
        LinkedHashMap<VirtualFile, VcsLogIndexer> indexers = new LinkedHashMap<VirtualFile, VcsLogIndexer>();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsLogProvider provider = entry.getValue();
            if (!((Boolean)VcsLogProperties.get((VcsLogProvider)provider, (VcsLogProperties.VcsLogProperty)VcsLogProperties.SUPPORTS_INDEXING)).booleanValue() || !(provider instanceof VcsIndexableLogProvider)) continue;
            indexers.put(root, ((VcsIndexableLogProvider)provider).getIndexer());
        }
        LinkedHashMap<VirtualFile, VcsLogIndexer> linkedHashMap = indexers;
        if (linkedHashMap == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    @NotNull
    public static Set<VirtualFile> getRootsForIndexing(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(18);
        }
        Set<VirtualFile> set = VcsLogPersistentIndex.getAvailableIndexers(providers).keySet();
        if (set == null) {
            VcsLogPersistentIndex.$$$reportNull$$$0(19);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 3: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorsConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detail";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableIndexers";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsForIndexing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createIndexStorage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doScheduleIndex";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "storeDetail";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isIndexed";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isIndexingEnabled";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "markForIndexing";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableIndexers";
                break;
            }
            case 17: 
            case 19: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRootsForIndexing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class IndexingRequest {
        private static final int BATCH_SIZE = 20000;
        private static final int FLUSHED_COMMITS_NUMBER = 15000;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final TIntHashSet myCommits;
        @NotNull
        private final VcsLogIndexer.PathsEncoder myPathsEncoder;
        private final boolean myFull;
        @NotNull
        private final AtomicInteger myNewIndexedCommits;
        @NotNull
        private final AtomicInteger myOldCommits;
        private volatile long myStartTime;

        IndexingRequest(@NotNull VirtualFile root, @NotNull VcsLogIndexer.PathsEncoder encoder, TIntHashSet commits, boolean full) {
            if (root == null) {
                IndexingRequest.$$$reportNull$$$0(0);
            }
            if (encoder == null) {
                IndexingRequest.$$$reportNull$$$0(1);
            }
            if (commits == null) {
                IndexingRequest.$$$reportNull$$$0(2);
            }
            this.myNewIndexedCommits = new AtomicInteger();
            this.myOldCommits = new AtomicInteger();
            this.myRoot = root;
            this.myPathsEncoder = encoder;
            this.myCommits = commits;
            this.myFull = full;
            ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(root)).incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(3);
            }
            if (VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot)) {
                LOG.info("Indexing repository " + this.myRoot.getName() + " is skipped since it is too big");
                ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(this.myRoot)).decrementAndGet();
                return;
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            this.myStartTime = this.getCurrentTimeMillis();
            LOG.debug("Indexing " + (this.myFull ? "full repository" : this.myCommits.size() + " commits") + " in " + this.myRoot.getName());
            try {
                try {
                    if (this.myFull) {
                        this.indexAll(indicator);
                    } else {
                        IntStream commits = TroveUtil.stream(this.myCommits).filter(c -> {
                            if (VcsLogPersistentIndex.this.isIndexed(c)) {
                                this.myOldCommits.incrementAndGet();
                                return false;
                            }
                            return true;
                        });
                        this.indexOneByOne(commits, indicator);
                    }
                }
                catch (ProcessCanceledException e) {
                    this.scheduleReindex();
                    throw e;
                }
                catch (VcsException e) {
                    LOG.error((Throwable)e);
                    this.scheduleReindex();
                }
            }
            finally {
                ((AtomicInteger)VcsLogPersistentIndex.this.myNumberOfTasks.get(this.myRoot)).decrementAndGet();
                ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).updateAndGet(t -> t + (this.getCurrentTimeMillis() - this.myStartTime));
                if (VcsLogPersistentIndex.this.isIndexed(this.myRoot)) {
                    long time = ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).getAndSet(0L);
                    VcsLogPersistentIndex.this.myIndexCollector.reportIndexingTime(time);
                    VcsLogPersistentIndex.this.myListeners.forEach(listener -> listener.indexingFinished(this.myRoot));
                }
                this.report();
                VcsLogPersistentIndex.this.flush();
            }
        }

        private long getCurrentTimeMillis() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        }

        private void report() {
            String formattedTime = StopWatch.formatTime(this.getCurrentTimeMillis() - this.myStartTime);
            if (this.myFull) {
                LOG.debug(formattedTime + " for indexing " + this.myNewIndexedCommits + " commits in " + this.myRoot.getName());
            } else {
                int leftCommits = this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get();
                String leftCommitsMessage = leftCommits > 0 ? ". " + leftCommits + " commits left" : "";
                LOG.debug(formattedTime + " for indexing " + this.myNewIndexedCommits + " new commits out of " + this.myCommits.size() + " in " + this.myRoot.getName() + leftCommitsMessage);
            }
        }

        private void scheduleReindex() {
            LOG.debug("Schedule reindexing of " + (this.myCommits.size() - this.myNewIndexedCommits.get() - this.myOldCommits.get()) + " commits in " + this.myRoot.getName());
            this.myCommits.forEach(value -> {
                VcsLogPersistentIndex.this.markForIndexing(value, this.myRoot);
                return true;
            });
            VcsLogPersistentIndex.this.scheduleIndex(false);
        }

        private void indexOneByOne(@NotNull IntStream commits, @NotNull ProgressIndicator indicator) throws VcsException {
            if (commits == null) {
                IndexingRequest.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(5);
            }
            TroveUtil.processBatches(commits, 20000, (ThrowableConsumer<? super TIntHashSet, ? extends VcsException>)((ThrowableConsumer)batch -> {
                indicator.checkCanceled();
                List<String> hashes = TroveUtil.map2List(batch, value -> VcsLogPersistentIndex.this.myStorage.getCommitId(value).getHash().asString());
                ((VcsLogIndexer)VcsLogPersistentIndex.this.myIndexers.get(this.myRoot)).readFullDetails(this.myRoot, hashes, this.myPathsEncoder, (Consumer<? super VcsLogIndexer.CompressedDetails>)((Consumer)detail -> {
                    VcsLogPersistentIndex.this.storeDetail(detail);
                    this.myNewIndexedCommits.incrementAndGet();
                    this.checkRunningTooLong(indicator);
                }));
                this.displayProgress(indicator);
            }));
        }

        public void indexAll(@NotNull ProgressIndicator indicator) throws VcsException {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(6);
            }
            this.displayProgress(indicator);
            ((VcsLogIndexer)VcsLogPersistentIndex.this.myIndexers.get(this.myRoot)).readAllFullDetails(this.myRoot, this.myPathsEncoder, (Consumer<? super VcsLogIndexer.CompressedDetails>)((Consumer)details -> {
                VcsLogPersistentIndex.this.storeDetail(details);
                if (this.myNewIndexedCommits.incrementAndGet() % 15000 == 0) {
                    VcsLogPersistentIndex.this.flush();
                }
                this.checkRunningTooLong(indicator);
                this.displayProgress(indicator);
            }));
        }

        private void checkRunningTooLong(@NotNull ProgressIndicator indicator) {
            int limit;
            long time;
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(7);
            }
            if ((time = ((AtomicLong)VcsLogPersistentIndex.this.myIndexingTime.get(this.myRoot)).get() + (this.getCurrentTimeMillis() - this.myStartTime)) >= Math.max((long)(limit = ((AtomicInteger)VcsLogPersistentIndex.this.myIndexingLimit.get(this.myRoot)).get()), 1L) * 60L * 1000L && !VcsLogPersistentIndex.this.myBigRepositoriesList.isBig(this.myRoot)) {
                LOG.warn("Indexing " + this.myRoot.getName() + " was cancelled after " + StopWatch.formatTime(time));
                VcsLogPersistentIndex.this.myBigRepositoriesList.addRepository(this.myRoot);
                ((AtomicInteger)VcsLogPersistentIndex.this.myIndexingLimit.get(this.myRoot)).compareAndSet(limit, Math.max(limit + VcsLogPersistentIndex.getIndexingLimit(), (int)((time / (long)(VcsLogPersistentIndex.getIndexingLimit() * 60000) + 1L) * (long)VcsLogPersistentIndex.getIndexingLimit())));
                indicator.cancel();
            }
        }

        public void displayProgress(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                IndexingRequest.$$$reportNull$$$0(8);
            }
            indicator.setFraction(((double)this.myNewIndexedCommits.get() + (double)this.myOldCommits.get()) / (double)this.myCommits.size());
        }

        public String toString() {
            return "IndexingRequest of " + this.myCommits.size() + " commits in " + this.myRoot.getName() + (this.myFull ? " (full)" : "");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "encoder";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commits";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexingRequest";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexOneByOne";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "indexAll";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkRunningTooLong";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "displayProgress";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MySingleTaskController
    extends SingleTaskController<IndexingRequest, Void> {
        private static final int LOW_PRIORITY = 1;
        @NotNull
        private final HeavyAwareExecutor myHeavyAwareExecutor;

        MySingleTaskController(@NotNull Project project, Disposable parent) {
            if (project == null) {
                MySingleTaskController.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                MySingleTaskController.$$$reportNull$$$0(1);
            }
            super(project, "index", EmptyConsumer.getInstance(), parent);
            this.myHeavyAwareExecutor = new HeavyAwareExecutor(project, 50, 100, VcsLogPersistentIndex.this);
        }

        @Override
        @NotNull
        protected SingleTaskController.SingleTask startNewBackgroundTask() {
            ProgressIndicator indicator = VcsLogPersistentIndex.this.myProgress.createProgressIndicator(false, INDEXING);
            Consumer task2 = progressIndicator -> {
                int previousPriority = this.setMinimumPriority();
                try {
                    IndexingRequest request;
                    while ((request = (IndexingRequest)this.popRequest()) != null) {
                        try {
                            request.run((ProgressIndicator)progressIndicator);
                            progressIndicator.checkCanceled();
                        }
                        catch (ProcessCanceledException reThrown) {
                            throw reThrown;
                        }
                        catch (Throwable t) {
                            LOG.error("Error while indexing", t);
                        }
                    }
                }
                finally {
                    this.taskCompleted(null);
                    this.resetPriority(previousPriority);
                }
            };
            Future<?> future = this.myHeavyAwareExecutor.executeOutOfHeavyOrPowerSave((Consumer<? super ProgressIndicator>)task2, "Indexing Commit Data", indicator);
            SingleTaskController.SingleTaskImpl singleTaskImpl = new SingleTaskController.SingleTaskImpl(future, indicator);
            if (singleTaskImpl == null) {
                MySingleTaskController.$$$reportNull$$$0(2);
            }
            return singleTaskImpl;
        }

        public void resetPriority(int previousPriority) {
            if (Thread.currentThread().getPriority() == 1) {
                Thread.currentThread().setPriority(previousPriority);
            }
        }

        public int setMinimumPriority() {
            int previousPriority = Thread.currentThread().getPriority();
            try {
                Thread.currentThread().setPriority(1);
            }
            catch (SecurityException e) {
                LOG.debug("Could not set indexing thread priority", (Throwable)e);
            }
            return previousPriority;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$MySingleTaskController";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "startNewBackgroundTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class IndexStorage
    implements Disposable {
        private static final String COMMITS = "commits";
        private static final String MESSAGES = "messages";
        private static final String PARENTS = "parents";
        private static final String COMMITTERS = "committers";
        private static final String TIMESTAMPS = "timestamps";
        private static final int MESSAGES_VERSION = 0;
        @NotNull
        public final PersistentSet<Integer> commits;
        @NotNull
        public final PersistentMap<Integer, String> messages;
        @NotNull
        public final PersistentMap<Integer, List<Integer>> parents;
        @NotNull
        public final PersistentMap<Integer, Integer> committers;
        @NotNull
        public final PersistentMap<Integer, Pair<Long, Long>> timestamps;
        @NotNull
        public final VcsLogMessagesTrigramIndex trigrams;
        @NotNull
        public final VcsLogUserIndex users;
        @NotNull
        public final VcsLogPathsIndex paths;
        private volatile boolean myIsFresh;

        IndexStorage(@NotNull String logId, @NotNull VcsLogStorage storage, @NotNull VcsUserRegistry userRegistry, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable parentDisposable) throws IOException {
            if (logId == null) {
                IndexStorage.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                IndexStorage.$$$reportNull$$$0(1);
            }
            if (userRegistry == null) {
                IndexStorage.$$$reportNull$$$0(2);
            }
            if (fatalErrorHandler == null) {
                IndexStorage.$$$reportNull$$$0(3);
            }
            if (parentDisposable == null) {
                IndexStorage.$$$reportNull$$$0(4);
            }
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
            try {
                boolean forwardIndexRequired = VcsLogIndexService.isPathsForwardIndexRequired();
                StorageId storageId = new StorageId("index", logId, IndexStorage.getVersion(), new boolean[]{forwardIndexRequired});
                File commitsStorage = storageId.getStorageFile(COMMITS);
                this.myIsFresh = !commitsStorage.exists();
                this.commits = new PersistentSetImpl<Integer>(commitsStorage, (KeyDescriptor<Integer>)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, null, storageId.getVersion());
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::close)));
                File messagesStorage = new StorageId("index", logId, 6).getStorageFile(MESSAGES);
                this.messages = new PersistentHashMap(messagesStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorStringDescriptor.INSTANCE, Page.PAGE_SIZE);
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.messages.close())));
                this.trigrams = new VcsLogMessagesTrigramIndex(storageId, fatalErrorHandler, this);
                this.users = new VcsLogUserIndex(storageId, userRegistry, fatalErrorHandler, this);
                this.paths = new VcsLogPathsIndex(storageId, storage, fatalErrorHandler, this);
                File parentsStorage = storageId.getStorageFile(PARENTS);
                this.parents = new PersistentHashMap(parentsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new IntListDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion());
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.parents.close())));
                File committersStorage = storageId.getStorageFile(COMMITTERS);
                this.committers = new PersistentHashMap(committersStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE, Page.PAGE_SIZE, storageId.getVersion());
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.committers.close())));
                File timestampsStorage = storageId.getStorageFile(TIMESTAMPS);
                this.timestamps = new PersistentHashMap(timestampsStorage, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new LongPairDataExternalizer(), Page.PAGE_SIZE, storageId.getVersion());
                Disposer.register((Disposable)this, () -> IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)() -> this.timestamps.close())));
            }
            catch (Throwable t) {
                Disposer.dispose((Disposable)this);
                throw t;
            }
        }

        void markCorrupted() {
            IndexStorage.catchAndWarn((ThrowableRunnable<IOException>)((ThrowableRunnable)this.commits::markCorrupted));
        }

        private static void catchAndWarn(@NotNull ThrowableRunnable<IOException> runnable) {
            if (runnable == null) {
                IndexStorage.$$$reportNull$$$0(5);
            }
            try {
                runnable.run();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        private static void cleanup(@NotNull String logId) {
            StorageId storageId;
            if (logId == null) {
                IndexStorage.$$$reportNull$$$0(6);
            }
            if (!(storageId = new StorageId("index", logId, IndexStorage.getVersion())).cleanupAllStorageFiles()) {
                LOG.error("Could not clean up storage files in " + storageId.subdir() + " starting with " + logId);
            }
        }

        private static int getVersion() {
            return 20;
        }

        public void unmarkFresh() {
            this.myIsFresh = false;
        }

        public boolean isFresh() {
            return this.myIsFresh;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "storage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "userRegistry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fatalErrorHandler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/data/index/VcsLogPersistentIndex$IndexStorage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "catchAndWarn";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cleanup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

