/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.command.HgCloneCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.ui.HgCloneDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;

public class HgCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(final @NotNull Project project, final @Nullable CheckoutProvider.Listener listener) {
        if (project == null) {
            HgCheckoutProvider.$$$reportNull$$$0(0);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final HgCloneDialog dialog = new HgCloneDialog(project);
        if (!dialog.showAndGet()) {
            return;
        }
        dialog.rememberSettings();
        VirtualFile destinationParent = LocalFileSystem.getInstance().findFileByIoFile(new File(dialog.getParentDirectory()));
        if (destinationParent == null) {
            return;
        }
        final String targetDir = destinationParent.getPath() + File.separator + dialog.getDirectoryName();
        final String sourceRepositoryURL = dialog.getSourceRepositoryURL();
        final AtomicReference cloneResult = new AtomicReference();
        new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.clone.progress", sourceRepositoryURL), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                HgCloneCommand clone = new HgCloneCommand(project);
                clone.setRepositoryURL(sourceRepositoryURL);
                clone.setDirectory(targetDir);
                cloneResult.set(clone.executeInCurrentThread());
            }

            public void onSuccess() {
                if (cloneResult.get() == null || HgErrorUtil.hasErrorsInCommandExecution((HgCommandResult)cloneResult.get())) {
                    new HgCommandResultNotifier(project).notifyError((HgCommandResult)cloneResult.get(), "Clone failed", "Clone from " + sourceRepositoryURL + " failed.");
                } else {
                    DvcsUtil.addMappingIfSubRoot((Project)project, (String)targetDir, (String)"hg4idea");
                    if (listener != null) {
                        listener.directoryCheckedOut(new File(dialog.getParentDirectory(), dialog.getDirectoryName()), HgVcs.getKey());
                        listener.checkoutCompleted();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/provider/HgCheckoutProvider$1", "run"));
            }
        }.queue();
    }

    public String getVcsName() {
        return "_Mercurial";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/provider/HgCheckoutProvider", "doCheckout"));
    }
}

