/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.ReadOnlyModificationException;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u001c\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0000\u001a0\u0010\u0011\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a(\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a<\u0010\u001b\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001e"}, d2={"XML_PROLOG", "", "getXML_PROLOG", "()[B", "deleteFile", "", "file", "Ljava/nio/file/Path;", "requestor", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "detectLineSeparators", "Lcom/intellij/util/LineSeparator;", "chars", "", "defaultSeparator", "doWrite", "dataWriterOrByteArray", "", "lineSeparator", "prependXmlProlog", "", "isEqualContent", "result", "content", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "writeFile", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "intellij.platform.configurationStore.impl"})
public final class FileBasedStorageKt {
    @NotNull
    private static final byte[] XML_PROLOG;

    @NotNull
    public static final VirtualFile writeFile(@Nullable Path file, @NotNull StorageManagerFileWriteRequestor requestor, @Nullable VirtualFile virtualFile, @NotNull DataWriter dataWriter, @NotNull LineSeparator lineSeparator, boolean prependXmlProlog) {
        VirtualFile result;
        block12: {
            block11: {
                VirtualFile virtualFile2;
                Intrinsics.checkParameterIsNotNull((Object)requestor, (String)"requestor");
                Intrinsics.checkParameterIsNotNull((Object)dataWriter, (String)"dataWriter");
                Intrinsics.checkParameterIsNotNull((Object)lineSeparator, (String)"lineSeparator");
                if (!(file == null || virtualFile != null && virtualFile.isValid())) {
                    virtualFile2 = StorageUtilKt.getOrCreateVirtualFile((Path)file, (StorageManagerFileWriteRequestor)requestor);
                } else {
                    virtualFile2 = virtualFile;
                    if (virtualFile2 == null) {
                        Intrinsics.throwNpe();
                    }
                }
                result = virtualFile2;
                if (ComponentStoreImplKt.getLOG().isDebugEnabled()) break block11;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block12;
            }
            if (!FileUtilRt.isTooLarge((long)result.getLength())) {
                BufferExposingByteArrayOutputStream content = XmlElementStorageKt.toBufferExposingByteArray(dataWriter, lineSeparator);
                if (FileBasedStorageKt.isEqualContent(result, lineSeparator, content, prependXmlProlog)) {
                    byte[] byArray = content.toByteArray();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"content.toByteArray()");
                    byte[] byArray2 = byArray;
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    boolean bl2 = false;
                    String contentString = new String(byArray2, charset);
                    ComponentStoreImplKt.getLOG().warn("Content equals, but it must be handled not on this level: file " + result.getName() + ", content:\n" + contentString);
                } else if (StorageUtilKt.getDEBUG_LOG() != null) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isUnitTestMode()) {
                        StorageUtilKt.setDEBUG_LOG((String)(result.getPath() + ":\n" + content + "\nOld Content:\n" + LoadTextUtil.loadText((VirtualFile)result)));
                    }
                }
            }
        }
        FileBasedStorageKt.doWrite(requestor, result, dataWriter, lineSeparator, prependXmlProlog);
        return result;
    }

    @NotNull
    public static final byte[] getXML_PROLOG() {
        return XML_PROLOG;
    }

    private static final boolean isEqualContent(VirtualFile result, LineSeparator lineSeparator, BufferExposingByteArrayOutputStream content, boolean prependXmlProlog) {
        boolean bl;
        block5: {
            int headerLength;
            int n = headerLength = !prependXmlProlog ? 0 : XML_PROLOG.length + lineSeparator.getSeparatorBytes().length;
            if ((int)result.getLength() != headerLength + content.size()) {
                return false;
            }
            byte[] byArray = result.contentsToByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"result.contentsToByteArray()");
            byte[] oldContent = byArray;
            if (!(!prependXmlProlog || ArrayUtil.startsWith((byte[])oldContent, (byte[])XML_PROLOG) && ArrayUtil.startsWith((byte[])oldContent, (int)XML_PROLOG.length, (byte[])lineSeparator.getSeparatorBytes()))) {
                return false;
            }
            Iterable $this$all$iv = (Iterable)RangesKt.until((int)headerLength, (int)oldContent.length);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (oldContent[it] == content.getInternalBuffer()[it - headerLength]) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void doWrite(StorageManagerFileWriteRequestor requestor, VirtualFile file, Object dataWriterOrByteArray, LineSeparator lineSeparator, boolean prependXmlProlog) {
        boolean bl;
        Logger $this$debugOrInfoIfTestMode$iv = ComponentStoreImplKt.getLOG();
        Object e$iv = null;
        boolean $i$f$debugOrInfoIfTestMode = false;
        Application application = ApplicationManager.getApplication();
        if (application != null && application.isUnitTestMode()) {
            Logger logger = $this$debugOrInfoIfTestMode$iv;
            bl = false;
            String string = "Save " + file.getPresentableUrl();
            logger.info(string);
        } else {
            Logger $this$debug$iv$iv = $this$debugOrInfoIfTestMode$iv;
            boolean $i$f$debug = false;
            if ($this$debug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv$iv;
                bl = false;
                String string = "Save " + file.getPresentableUrl();
                logger.debug(string, (Throwable)e$iv);
            }
        }
        if (!file.isWritable()) {
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream;
            e$iv = dataWriterOrByteArray;
            if (e$iv instanceof DataWriter) {
                bufferExposingByteArrayOutputStream = XmlElementStorageKt.toBufferExposingByteArray((DataWriter)dataWriterOrByteArray, lineSeparator);
            } else {
                Object object = dataWriterOrByteArray;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                }
                bufferExposingByteArrayOutputStream = (BufferExposingByteArrayOutputStream)object;
            }
            BufferExposingByteArrayOutputStream byteArray = bufferExposingByteArrayOutputStream;
            throw (Throwable)new ReadOnlyModificationException(file, new SaveSession(requestor, file, byteArray, lineSeparator, prependXmlProlog){
                final /* synthetic */ StorageManagerFileWriteRequestor $requestor;
                final /* synthetic */ VirtualFile $file;
                final /* synthetic */ BufferExposingByteArrayOutputStream $byteArray;
                final /* synthetic */ LineSeparator $lineSeparator;
                final /* synthetic */ boolean $prependXmlProlog;

                public void save() {
                    FileBasedStorageKt.access$doWrite(this.$requestor, this.$file, this.$byteArray, this.$lineSeparator, this.$prependXmlProlog);
                }
                {
                    this.$requestor = $captured_local_variable$0;
                    this.$file = $captured_local_variable$1;
                    this.$byteArray = $captured_local_variable$2;
                    this.$lineSeparator = $captured_local_variable$3;
                    this.$prependXmlProlog = $captured_local_variable$4;
                }
            });
        }
        boolean $i$f$runAsWriteActionIfNeeded = false;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
        if (!application2.isWriteAccessAllowed()) {
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(file, requestor, prependXmlProlog, lineSeparator, dataWriterOrByteArray){
                final /* synthetic */ VirtualFile $file$inlined;
                final /* synthetic */ StorageManagerFileWriteRequestor $requestor$inlined;
                final /* synthetic */ boolean $prependXmlProlog$inlined;
                final /* synthetic */ LineSeparator $lineSeparator$inlined;
                final /* synthetic */ Object $dataWriterOrByteArray$inlined;
                {
                    this.$file$inlined = virtualFile;
                    this.$requestor$inlined = storageManagerFileWriteRequestor;
                    this.$prependXmlProlog$inlined = bl;
                    this.$lineSeparator$inlined = lineSeparator;
                    this.$dataWriterOrByteArray$inlined = object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final T compute() {
                    boolean bl = false;
                    Closeable closeable = this.$file$inlined.getOutputStream((Object)this.$requestor$inlined);
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        OutputStream output = (OutputStream)closeable;
                        boolean bl3 = false;
                        if (this.$prependXmlProlog$inlined) {
                            output.write(FileBasedStorageKt.getXML_PROLOG());
                            output.write(this.$lineSeparator$inlined.getSeparatorBytes());
                        }
                        if (this.$dataWriterOrByteArray$inlined instanceof DataWriter) {
                            DataWriter dataWriter = (DataWriter)this.$dataWriterOrByteArray$inlined;
                            OutputStream outputStream = output;
                            Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"output");
                            String string = this.$lineSeparator$inlined.getSeparatorString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
                            DataWriter.DefaultImpls.write$default(dataWriter, outputStream, string, null, 4, null);
                        } else {
                            Object object = this.$dataWriterOrByteArray$inlined;
                            if (object == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                            }
                            ((BufferExposingByteArrayOutputStream)object).writeTo(output);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return (T)Unit.INSTANCE;
                }
            });
            return;
        }
        boolean bl2 = false;
        Closeable closeable = file.getOutputStream((Object)requestor);
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            OutputStream output = (OutputStream)closeable;
            boolean bl4 = false;
            if (prependXmlProlog) {
                output.write(FileBasedStorageKt.getXML_PROLOG());
                output.write(lineSeparator.getSeparatorBytes());
            }
            if (dataWriterOrByteArray instanceof DataWriter) {
                DataWriter dataWriter = (DataWriter)dataWriterOrByteArray;
                OutputStream outputStream = output;
                Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"output");
                String string = lineSeparator.getSeparatorString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lineSeparator.separatorString");
                DataWriter.DefaultImpls.write$default(dataWriter, outputStream, string, null, 4, null);
            } else {
                Object object = dataWriterOrByteArray;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream");
                }
                ((BufferExposingByteArrayOutputStream)object).writeTo(output);
            }
            Unit unit = Unit.INSTANCE;
            return;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final LineSeparator detectLineSeparators(@NotNull CharSequence chars, @Nullable LineSeparator defaultSeparator) {
        Intrinsics.checkParameterIsNotNull((Object)chars, (String)"chars");
        CharSequence charSequence = chars;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\r') {
                return LineSeparator.CRLF;
            }
            if (c != '\n') continue;
            return LineSeparator.LF;
        }
        LineSeparator lineSeparator = defaultSeparator;
        if (lineSeparator == null) {
            LineSeparator lineSeparator2 = LineSeparator.getSystemLineSeparator();
            lineSeparator = lineSeparator2;
            Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator2, (String)"LineSeparator.getSystemLineSeparator()");
        }
        return lineSeparator;
    }

    public static /* synthetic */ LineSeparator detectLineSeparators$default(CharSequence charSequence, LineSeparator lineSeparator, int n, Object object) {
        if ((n & 2) != 0) {
            lineSeparator = null;
        }
        return FileBasedStorageKt.detectLineSeparators(charSequence, lineSeparator);
    }

    private static final void deleteFile(Path file, StorageManagerFileWriteRequestor requestor, VirtualFile virtualFile) {
        if (virtualFile == null) {
            try {
                Files.delete(file);
            }
            catch (NoSuchFileException noSuchFileException) {}
        } else if (virtualFile.exists()) {
            if (virtualFile.isWritable()) {
                virtualFile.delete((Object)requestor);
            } else {
                throw (Throwable)new ReadOnlyModificationException(virtualFile, new SaveSession(virtualFile, requestor){
                    final /* synthetic */ VirtualFile $virtualFile;
                    final /* synthetic */ StorageManagerFileWriteRequestor $requestor;

                    public void save() {
                        this.$virtualFile.delete((Object)this.$requestor);
                    }
                    {
                        this.$virtualFile = $captured_local_variable$0;
                        this.$requestor = $captured_local_variable$1;
                    }
                });
            }
        }
    }

    static {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        XML_PROLOG = byArray;
    }

    public static final /* synthetic */ void access$deleteFile(Path file, StorageManagerFileWriteRequestor requestor, VirtualFile virtualFile) {
        FileBasedStorageKt.deleteFile(file, requestor, virtualFile);
    }

    public static final /* synthetic */ void access$doWrite(StorageManagerFileWriteRequestor requestor, VirtualFile file, Object dataWriterOrByteArray, LineSeparator lineSeparator, boolean prependXmlProlog) {
        FileBasedStorageKt.doWrite(requestor, file, dataWriterOrByteArray, lineSeparator, prependXmlProlog);
    }
}

