/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.concurrency.JobScheduler;
import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventScheduler;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventSchedulerKt;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEvents;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageLogger;
import com.intellij.internal.statistic.eventLog.fus.FeatureUsageStateEventTracker;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.util.ArrayUtilRt;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/configurationStore/statistic/eventLog/FeatureUsageSettingsEventScheduler;", "Lcom/intellij/internal/statistic/eventLog/fus/FeatureUsageStateEventTracker;", "()V", "initialize", "", "logConfigStateEvents", "logInitializedComponents", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "logProjectInitializedComponentsAndContinue", "projects", "Ljava/util/ArrayDeque;", "Lcom/intellij/openapi/project/Project;", "intellij.platform.configurationStore.impl"})
public final class FeatureUsageSettingsEventScheduler
implements FeatureUsageStateEventTracker {
    public void initialize() {
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            return;
        }
        JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(this){
            final /* synthetic */ FeatureUsageSettingsEventScheduler this$0;

            public final void run() {
                FeatureUsageSettingsEventScheduler.access$logConfigStateEvents(this.this$0);
            }
            {
                this.this$0 = featureUsageSettingsEventScheduler;
            }
        }, 1440, 1440, TimeUnit.MINUTES);
    }

    private final void logConfigStateEvents() {
        ProjectManagerEx projectManager;
        if (!FeatureUsageLogger.INSTANCE.isEnabled()) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        this.logInitializedComponents((ComponentManager)application);
        ProjectManagerEx projectManagerEx = projectManager = ProjectManagerEx.getInstanceEx();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectManagerEx, (String)"projectManager");
        Object[] objectArray = projectManagerEx.getOpenProjects();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"projectManager.openProjects");
        ArrayDeque<Project> projects = new ArrayDeque<Project>(ArraysKt.toList((Object[])objectArray));
        if (projectManager.isDefaultProjectInitialized()) {
            projects.addFirst(projectManager.getDefaultProject());
        }
        this.logProjectInitializedComponentsAndContinue(projects);
    }

    private final CompletableFuture<Void> logProjectInitializedComponentsAndContinue(ArrayDeque<Project> projects) {
        Project project = projects.pollFirst();
        if (project == null || !project.isInitialized() || project.isDisposed()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(null)");
            return completableFuture;
        }
        CompletionStage completionStage = this.logInitializedComponents((ComponentManager)project).thenCompose(new Function<T, CompletionStage<U>>(this, projects){
            final /* synthetic */ FeatureUsageSettingsEventScheduler this$0;
            final /* synthetic */ ArrayDeque $projects;

            @NotNull
            public final CompletableFuture<Void> apply(@Nullable Void it) {
                return FeatureUsageSettingsEventScheduler.access$logProjectInitializedComponentsAndContinue(this.this$0, this.$projects);
            }
            {
                this.this$0 = featureUsageSettingsEventScheduler;
                this.$projects = arrayDeque;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"logInitializedComponents\u2026tinue(projects)\n        }");
        return completionStage;
    }

    private final CompletableFuture<Void> logInitializedComponents(ComponentManager componentManager) {
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)componentManager);
        if (!(iComponentStore instanceof ComponentStoreImpl)) {
            iComponentStore = null;
        }
        ComponentStoreImpl componentStoreImpl = (ComponentStoreImpl)iComponentStore;
        if (componentStoreImpl == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.completedFuture(null)");
            return completableFuture;
        }
        ComponentStoreImpl stateStore = componentStoreImpl;
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(stateStore, componentManager){
            final /* synthetic */ ComponentStoreImpl $stateStore;
            final /* synthetic */ ComponentManager $componentManager;

            public final void run() {
                Map<String, ComponentInfo> components = this.$stateStore.getComponents$intellij_platform_configurationStore_impl();
                for (String name : ArrayUtilRt.toStringArray((Collection)components.keySet())) {
                    ComponentInfo info = components.get(name);
                    Object object = info;
                    if (object == null || (object = ((ComponentInfo)object).getComponent()) == null) {
                        continue;
                    }
                    Object component = object;
                    try {
                        Object componentState;
                        State stateSpec;
                        if (!(component instanceof PersistentStateComponent)) continue;
                        if (info.getStateSpec() == null) {
                            continue;
                        }
                        if (((PersistentStateComponent)component).getState() == null) {
                            continue;
                        }
                        String string = name;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                        ComponentManager componentManager = this.$componentManager;
                        if (!(componentManager instanceof Project)) {
                            componentManager = null;
                        }
                        FeatureUsageSettingsEvents.INSTANCE.logConfigurationState(string, stateSpec, componentState, (Project)componentManager);
                    }
                    catch (Exception e) {
                        FeatureUsageSettingsEventSchedulerKt.access$getLOG$p().warn("Error during configuration recording", (Throwable)e);
                    }
                }
            }
            {
                this.$stateStore = componentStoreImpl;
                this.$componentManager = componentManager;
            }
        }, logInitializedComponents.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.runAsy\u2026tion().invokeLater(it) })");
        return completableFuture;
    }

    public static final /* synthetic */ void access$logConfigStateEvents(FeatureUsageSettingsEventScheduler $this) {
        $this.logConfigStateEvents();
    }

    public static final /* synthetic */ CompletableFuture access$logProjectInitializedComponentsAndContinue(FeatureUsageSettingsEventScheduler $this, ArrayDeque projects) {
        return $this.logProjectInitializedComponentsAndContinue(projects);
    }
}

