/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Alarm;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationListener;
import git4idea.commands.GitAuthenticationMode;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitIncomingCheckStrategy;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitPushSupport;
import git4idea.push.GitPushTarget;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchIncomingOutgoingManager
implements GitRepositoryChangeListener,
GitAuthenticationListener {
    private static final Logger LOG = Logger.getInstance(GitBranchIncomingOutgoingManager.class);
    private static final String MAC_DEFAULT_LAUNCH = "com.apple.launchd";
    private static final boolean HAS_EXTERNAL_SSH_AGENT = GitBranchIncomingOutgoingManager.hasExternalSSHAgent();
    @NotNull
    private final Object LOCK;
    @NotNull
    private final Set<GitRepository> myDirtyReposPull;
    @NotNull
    private final Set<GitRepository> myDirtyReposPush;
    private boolean myUseForceAuthentication;
    @NotNull
    private final MergingUpdateQueue myQueue;
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToPull;
    @NotNull
    private final Map<GitRepository, Map<GitLocalBranch, Hash>> myLocalBranchesToPush;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myErrorMap;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitVcsSettings myGitSettings;
    @Nullable
    private ScheduledFuture<?> myPeriodicalUpdater;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @Nullable
    private MessageBusConnection myConnection;
    @NotNull
    private final MultiMap<GitRepository, GitRemote> myAuthSuccessMap;

    GitBranchIncomingOutgoingManager(@NotNull Project project, @NotNull Git git, @NotNull GitVcsSettings gitProjectSettings, @NotNull GitRepositoryManager repositoryManager) {
        if (project == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(1);
        }
        if (gitProjectSettings == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(2);
        }
        if (repositoryManager == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(3);
        }
        this.LOCK = new Object();
        this.myDirtyReposPull = new HashSet<GitRepository>();
        this.myDirtyReposPush = new HashSet<GitRepository>();
        this.myLocalBranchesToPull = ContainerUtil.newConcurrentMap();
        this.myLocalBranchesToPush = ContainerUtil.newConcurrentMap();
        this.myErrorMap = MultiMap.createConcurrentSet();
        this.myAuthSuccessMap = MultiMap.createConcurrentSet();
        this.myProject = project;
        this.myGit = git;
        this.myGitSettings = gitProjectSettings;
        this.myRepositoryManager = repositoryManager;
        this.myQueue = new MergingUpdateQueue("GitBranchIncomingOutgoingManager", 1000, true, null, (Disposable)this.myProject, null, Alarm.ThreadToUse.POOLED_THREAD);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                GitBranchIncomingOutgoingManager.this.stopScheduling();
            }
        });
    }

    private static boolean hasExternalSSHAgent() {
        String ssh_auth_sock = EnvironmentUtil.getValue((String)"SSH_AUTH_SOCK");
        if (ssh_auth_sock == null) {
            return false;
        }
        return !StringUtil.contains((CharSequence)ssh_auth_sock, (CharSequence)MAC_DEFAULT_LAUNCH);
    }

    public boolean hasIncomingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        if (localBranchName == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(4);
        }
        return this.shouldCheckIncoming() && this.getBranchesToPull(repository).contains(new GitLocalBranch(localBranchName));
    }

    public boolean hasOutgoingFor(@Nullable GitRepository repository, @NotNull String localBranchName) {
        if (localBranchName == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(5);
        }
        return this.getBranchesToPush(repository).contains(new GitLocalBranch(localBranchName));
    }

    public boolean shouldCheckIncoming() {
        return Registry.is((String)"git.update.incoming.outgoing.info") && this.myGitSettings.getIncomingCheckStrategy() != GitIncomingCheckStrategy.Never;
    }

    @NotNull
    public static GitBranchIncomingOutgoingManager getInstance(@NotNull Project project) {
        if (project == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(6);
        }
        GitBranchIncomingOutgoingManager gitBranchIncomingOutgoingManager = (GitBranchIncomingOutgoingManager)ServiceManager.getService((Project)project, GitBranchIncomingOutgoingManager.class);
        if (gitBranchIncomingOutgoingManager == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(7);
        }
        return gitBranchIncomingOutgoingManager;
    }

    public boolean hasAuthenticationProblems() {
        return !this.myErrorMap.isEmpty();
    }

    public boolean supportsIncomingOutgoing() {
        return GitVersionSpecialty.INCOMING_OUTGOING_BRANCH_INFO.existsIn(this.myProject);
    }

    public void activate() {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myConnection == null) {
                this.myConnection = this.myProject.getMessageBus().connect();
                this.myConnection.subscribe(GitRepository.GIT_REPO_CHANGE, (Object)this);
                this.myConnection.subscribe(GitAuthenticationListener.GIT_AUTHENTICATION_SUCCESS, (Object)this);
            }
            this.updateBranchesToPush();
            this.updateIncomingScheduling();
        });
    }

    public void updateIncomingScheduling() {
        if (this.myPeriodicalUpdater == null && this.shouldCheckIncoming()) {
            this.updateBranchesToPull(false);
            int timeout = Registry.intValue((String)"git.update.incoming.info.time");
            this.myPeriodicalUpdater = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.updateBranchesToPull(false), timeout, timeout, TimeUnit.MINUTES);
        } else if (this.myPeriodicalUpdater != null && !this.shouldCheckIncoming()) {
            this.stopScheduling();
        }
    }

    private void stopScheduling() {
        if (this.myPeriodicalUpdater != null) {
            this.myPeriodicalUpdater.cancel(true);
            this.myPeriodicalUpdater = null;
        }
    }

    public void forceUpdateBranchesToPull() {
        this.updateBranchesToPull(true);
        new Task.Backgroundable(this.myProject, "Update Branches Info..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                Semaphore semaphore = new Semaphore(0);
                GitBranchIncomingOutgoingManager.this.myQueue.queue(Update.create((Object)((Object)this), () -> semaphore.release()));
                GitBranchIncomingOutgoingManager.this.myQueue.flush();
                try {
                    while (!indicator.isCanceled() && !semaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBranchIncomingOutgoingManager$2", "run"));
            }
        }.queue();
    }

    private void scheduleUpdate() {
        this.myQueue.queue(Update.create((Object)"update", () -> {
            boolean useForceAuthentication;
            ArrayList<GitRepository> toPush;
            ArrayList<GitRepository> toPull;
            Object object = this.LOCK;
            synchronized (object) {
                toPull = new ArrayList<GitRepository>(this.myDirtyReposPull);
                toPush = new ArrayList<GitRepository>(this.myDirtyReposPush);
                useForceAuthentication = this.myUseForceAuthentication;
                this.myDirtyReposPull.clear();
                this.myDirtyReposPush.clear();
                this.myUseForceAuthentication = false;
            }
            BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> {
                for (GitRepository r : toPush) {
                    this.myLocalBranchesToPush.put(r, this.calculateBranchesToPush(r));
                }
                for (GitRepository r : toPull) {
                    this.myLocalBranchesToPull.put(r, this.calculateBranchesToPull(r, useForceAuthentication));
                }
            });
        }));
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesToPull(@Nullable GitRepository repository) {
        Collection<GitLocalBranch> collection = GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesToPull);
        if (collection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public Collection<GitLocalBranch> getBranchesToPush(@Nullable GitRepository repository) {
        Collection<GitLocalBranch> collection = GitBranchIncomingOutgoingManager.getBranches(repository, this.myLocalBranchesToPush);
        if (collection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(9);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesToPull(boolean useForceAuthentication) {
        if (!this.shouldCheckIncoming()) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (useForceAuthentication) {
                this.myUseForceAuthentication = true;
            }
            this.myDirtyReposPull.addAll(this.myRepositoryManager.getRepositories());
        }
        this.scheduleUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBranchesToPush() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposPush.addAll(this.myRepositoryManager.getRepositories());
        }
        this.scheduleUpdate();
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calculateBranchesToPull(@NotNull GitRepository repository, boolean useForceAuthentication) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(10);
        }
        HashMap<GitLocalBranch, Hash> result2 = new HashMap<GitLocalBranch, Hash>();
        GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository).entrySet().forEach(entry -> result2.putAll(this.calcBranchesToPullForRemote(repository, (GitRemote)entry.getKey(), (Collection)entry.getValue(), this.getAuthenticationMode(repository, (GitRemote)entry.getKey(), useForceAuthentication))));
        HashMap<GitLocalBranch, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calcBranchesToPullForRemote(@NotNull GitRepository repository, @NotNull GitRemote gitRemote, @NotNull Collection<? extends GitBranchTrackInfo> trackInfoList, GitAuthenticationMode mode) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(12);
        }
        if (gitRemote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(13);
        }
        if (trackInfoList == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(14);
        }
        HashMap<GitLocalBranch, Hash> result2 = new HashMap<GitLocalBranch, Hash>();
        GitBranchesCollection branchesCollection = repository.getBranches();
        Map<String, Hash> remoteNameWithHash = this.lsRemote(repository, gitRemote, ContainerUtil.map(trackInfoList, info -> info.getRemoteBranch().getNameForRemoteOperations()), mode);
        for (Map.Entry<String, Hash> hashEntry : remoteNameWithHash.entrySet()) {
            String remoteBranchName = hashEntry.getKey();
            Hash remoteHash = hashEntry.getValue();
            trackInfoList.forEach(info -> {
                GitRemoteBranch remoteBranch = info.getRemoteBranch();
                Hash localHashForRemoteBranch = branchesCollection.getHash(remoteBranch);
                Hash localHash = branchesCollection.getHash(info.getLocalBranch());
                if (localHashForRemoteBranch == null) {
                    return;
                }
                if (StringUtil.equals((CharSequence)remoteBranchName, (CharSequence)GitRefUtil.addRefsHeadsPrefixIfNeeded(remoteBranch.getNameForRemoteOperations()))) {
                    if (!localHashForRemoteBranch.equals(remoteHash)) {
                        result2.put(info.getLocalBranch(), localHashForRemoteBranch);
                    } else if (this.hasCommitsForBranch(repository, info.getLocalBranch(), localHash, localHashForRemoteBranch, true)) {
                        result2.put(info.getLocalBranch(), localHashForRemoteBranch);
                    }
                }
            });
        }
        HashMap<GitLocalBranch, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(15);
        }
        return hashMap;
    }

    @NotNull
    private GitAuthenticationMode getAuthenticationMode(@NotNull GitRepository repository, @NotNull GitRemote remote, boolean useForceAuthentication) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(16);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(17);
        }
        if (useForceAuthentication) {
            GitAuthenticationMode gitAuthenticationMode = GitAuthenticationMode.FULL;
            if (gitAuthenticationMode == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(18);
            }
            return gitAuthenticationMode;
        }
        if (this.myAuthSuccessMap.get((Object)repository).contains(remote)) {
            GitAuthenticationMode gitAuthenticationMode = GitAuthenticationMode.SILENT;
            if (gitAuthenticationMode == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(19);
            }
            return gitAuthenticationMode;
        }
        GitAuthenticationMode gitAuthenticationMode = GitAuthenticationMode.NONE;
        if (gitAuthenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(20);
        }
        return gitAuthenticationMode;
    }

    private boolean shouldAvoidUserInteraction(@NotNull GitRemote remote) {
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(21);
        }
        return this.myGitSettings.getIncomingCheckStrategy() == GitIncomingCheckStrategy.Auto && HAS_EXTERNAL_SSH_AGENT && GitBranchIncomingOutgoingManager.containsSSHUrl(remote);
    }

    private static boolean containsSSHUrl(@NotNull GitRemote remote) {
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(22);
        }
        return ContainerUtil.exists(remote.getUrls(), url -> !url.startsWith("http"));
    }

    @NotNull
    private Map<String, Hash> lsRemote(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> branchRefNames, @NotNull GitAuthenticationMode authenticationMode) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(23);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(24);
        }
        if (branchRefNames == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(25);
        }
        if (authenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(26);
        }
        HashMap<String, Hash> result2 = new HashMap<String, Hash>();
        if (!this.supportsIncomingOutgoing()) {
            HashMap<String, Hash> hashMap = result2;
            if (hashMap == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(27);
            }
            return hashMap;
        }
        if (authenticationMode == GitAuthenticationMode.NONE || authenticationMode == GitAuthenticationMode.SILENT && this.shouldAvoidUserInteraction(remote)) {
            this.myErrorMap.putValue((Object)repository, (Object)remote);
            HashMap<String, Hash> hashMap = result2;
            if (hashMap == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(28);
            }
            return hashMap;
        }
        VcsFileUtil.chunkArguments(branchRefNames).forEach(refs -> {
            ArrayList params = ContainerUtil.newArrayList((Object[])new String[]{"--heads", remote.getName()});
            params.addAll(refs);
            GitCommandResult lsRemoteResult = this.myGit.runCommand((Computable<? extends GitLineHandler>)((Computable)() -> this.createLsRemoteHandler(repository, remote, params, authenticationMode)));
            if (lsRemoteResult.success()) {
                Map hashWithNameMap = ContainerUtil.map2MapNotNull(lsRemoteResult.getOutput(), GitRefUtil::parseRefsLine);
                result2.putAll(GitRefUtil.getResolvedHashes(hashWithNameMap));
                this.myErrorMap.remove((Object)repository, (Object)remote);
                this.myAuthSuccessMap.putValue((Object)repository, (Object)remote);
            } else {
                this.myErrorMap.putValue((Object)repository, (Object)remote);
            }
        });
        HashMap<String, Hash> hashMap = result2;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(29);
        }
        return hashMap;
    }

    @NotNull
    private GitLineHandler createLsRemoteHandler(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<String> params, @NotNull GitAuthenticationMode authenticationMode) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(30);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(31);
        }
        if (params == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(32);
        }
        if (authenticationMode == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(33);
        }
        GitLineHandler h = new GitLineHandler(this.myProject, repository.getRoot(), GitCommand.LS_REMOTE);
        h.setIgnoreAuthenticationMode(authenticationMode);
        h.addParameters(params);
        h.setUrls(remote.getUrls());
        GitLineHandler gitLineHandler = h;
        if (gitLineHandler == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(34);
        }
        return gitLineHandler;
    }

    private boolean shouldUpdateBranchesToPull(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(35);
        }
        if (!this.shouldCheckIncoming()) {
            return false;
        }
        Map<GitLocalBranch, Hash> cachedBranchesToPull = this.myLocalBranchesToPull.get(repository);
        return cachedBranchesToPull == null || ContainerUtil.exists(repository.getBranchTrackInfos(), info -> !Objects.equals(repository.getBranches().getHash(info.getRemoteBranch()), cachedBranchesToPull.get(info.getLocalBranch())));
    }

    @NotNull
    private Map<GitLocalBranch, Hash> calculateBranchesToPush(@NotNull GitRepository gitRepository) {
        if (gitRepository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(36);
        }
        HashMap<GitLocalBranch, Hash> branchesToPush = new HashMap<GitLocalBranch, Hash>();
        GitBranchesCollection branchesCollection = gitRepository.getBranches();
        for (GitLocalBranch branch : branchesCollection.getLocalBranches()) {
            Hash localHashForRemoteBranch;
            GitPushTarget pushTarget = GitPushSupport.getPushTargetIfExist(gitRepository, branch);
            Hash hash = localHashForRemoteBranch = pushTarget != null ? branchesCollection.getHash(pushTarget.getBranch()) : null;
            Hash localHash = branchesCollection.getHash(branch);
            if (!this.hasCommitsForBranch(gitRepository, branch, localHash, localHashForRemoteBranch, false)) continue;
            branchesToPush.put(branch, localHashForRemoteBranch);
        }
        HashMap<GitLocalBranch, Hash> hashMap = branchesToPush;
        if (hashMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(37);
        }
        return hashMap;
    }

    private boolean hasCommitsForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch localBranch, @Nullable Hash localBranchHash, @Nullable Hash localHashForRemoteBranch, boolean incoming) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(38);
        }
        if (localBranch == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(39);
        }
        if (!this.supportsIncomingOutgoing()) {
            return false;
        }
        if (localHashForRemoteBranch == null || Objects.equals(localBranchHash, localHashForRemoteBranch)) {
            return false;
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        handler.setSilent(true);
        String branchName = localBranch.getName();
        handler.addParameters("--count", incoming ? branchName + ".." + branchName + "@{u}" : localHashForRemoteBranch.asString() + ".." + branchName);
        try {
            String output = this.myGit.runCommand(handler).getOutputOrThrow(new int[0]).trim();
            return !StringUtil.startsWithChar((CharSequence)output, (char)'0');
        }
        catch (VcsException e) {
            LOG.warn("Can't get outgoing info (git rev-list " + branchName + " failed):" + e.getMessage());
            return false;
        }
    }

    @NotNull
    private static Collection<GitLocalBranch> getBranches(@Nullable GitRepository repository, @NotNull Map<GitRepository, Map<GitLocalBranch, Hash>> branchCollection) {
        if (branchCollection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(40);
        }
        if (repository != null) {
            Map<GitLocalBranch, Hash> branchHashMap = branchCollection.get(repository);
            Set<GitLocalBranch> set = branchHashMap != null ? branchHashMap.keySet() : Collections.emptySet();
            if (set == null) {
                GitBranchIncomingOutgoingManager.$$$reportNull$$$0(41);
            }
            return set;
        }
        Collection collection = (Collection)StreamEx.of(branchCollection.values()).flatMap(StreamEx::ofKeys).collect(Collectors.toSet());
        if (collection == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(42);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repositoryChanged(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(43);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtyReposPush.add(repository);
            if (this.shouldUpdateBranchesToPull(repository)) {
                this.myDirtyReposPull.add(repository);
            }
        }
        this.scheduleUpdate();
    }

    @Override
    public void authenticationSucceeded(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        MultiMap<GitRemote, GitBranchTrackInfo> trackInfoByRemotes;
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(44);
        }
        if (remote == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(45);
        }
        if (!this.shouldCheckIncoming()) {
            return;
        }
        Collection remotes = this.myErrorMap.get((Object)repository);
        this.myAuthSuccessMap.putValue((Object)repository, (Object)remote);
        if (remotes.contains(remote) && (trackInfoByRemotes = GitBranchIncomingOutgoingManager.groupTrackInfoByRemotes(repository)).containsKey((Object)remote)) {
            Map<GitLocalBranch, Hash> newBranchMap = this.calcBranchesToPullForRemote(repository, remote, trackInfoByRemotes.get((Object)remote), GitAuthenticationMode.SILENT);
            this.myLocalBranchesToPull.compute(repository, (r, branchHashMap) -> {
                if (branchHashMap == null) {
                    return new HashMap(newBranchMap);
                }
                branchHashMap.putAll(newBranchMap);
                return branchHashMap;
            });
        }
    }

    @NotNull
    private static MultiMap<GitRemote, GitBranchTrackInfo> groupTrackInfoByRemotes(@NotNull GitRepository repository) {
        if (repository == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(46);
        }
        MultiMap multiMap = ContainerUtil.groupBy(repository.getBranchTrackInfos(), GitBranchTrackInfo::getRemote);
        if (multiMap == null) {
            GitBranchIncomingOutgoingManager.$$$reportNull$$$0(47);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitProjectSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchIncomingOutgoingManager";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 23: 
            case 30: 
            case 35: 
            case 38: 
            case 43: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRemote";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trackInfoList";
                break;
            }
            case 17: 
            case 21: 
            case 22: 
            case 24: 
            case 31: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchRefNames";
                break;
            }
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationMode";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranch";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchIncomingOutgoingManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesToPull";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchesToPush";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBranchesToPull";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcBranchesToPullForRemote";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthenticationMode";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemote";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createLsRemoteHandler";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBranchesToPush";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "groupTrackInfoByRemotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasIncomingFor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasOutgoingFor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 47: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchesToPull";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calcBranchesToPullForRemote";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAuthenticationMode";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldAvoidUserInteraction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "containsSSHUrl";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lsRemote";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createLsRemoteHandler";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "shouldUpdateBranchesToPull";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "calculateBranchesToPush";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasCommitsForBranch";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBranches";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "repositoryChanged";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "authenticationSucceeded";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "groupTrackInfoByRemotes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 37: 
            case 41: 
            case 42: 
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

