/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitConfigUtil {
    public static final String USER_NAME = "user.name";
    public static final String USER_EMAIL = "user.email";
    public static final String CORE_AUTOCRLF = "core.autocrlf";

    private GitConfigUtil() {
    }

    public static void getValues(Project project, VirtualFile root, String keyMask, Map<String, String> result2) throws VcsException {
        int pos;
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        h.setSilent(true);
        h.addParameters("--null");
        if (keyMask != null) {
            h.addParameters("--get-regexp", keyMask);
        } else {
            h.addParameters("-l");
        }
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        int start = 0;
        while ((pos = output.indexOf(10, start)) != -1) {
            String key = output.substring(start, pos);
            start = pos + 1;
            if ((pos = output.indexOf(0, start)) == -1) break;
            String value = output.substring(start, pos);
            start = pos + 1;
            result2.put(key, value);
        }
    }

    @Nullable
    public static String getValue(Project project, VirtualFile root, @NonNls String key) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        h.setSilent(true);
        h.addParameters("--null", "--get", key);
        GitCommandResult result2 = Git.getInstance().runCommand(h);
        String output = result2.getOutputOrThrow(1);
        int pos = output.indexOf(0);
        if (result2.getExitCode() != 0 || pos == -1) {
            return null;
        }
        return output.substring(0, pos);
    }

    @Nullable
    public static Boolean getBooleanValue(@NotNull String value) {
        if (value == null) {
            GitConfigUtil.$$$reportNull$$$0(0);
        }
        value = StringUtil.toLowerCase((String)value);
        if (ContainerUtil.newHashSet((Object[])new String[]{"true", "yes", "on", "1"}).contains(value)) {
            return true;
        }
        if (ContainerUtil.newHashSet((Object[])new String[]{"false", "no", "off", "0", ""}).contains(value)) {
            return false;
        }
        return null;
    }

    public static String getCommitEncoding(Project project, VirtualFile root) {
        String encoding = null;
        try {
            encoding = GitConfigUtil.getValue(project, root, "i18n.commitencoding");
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        if (encoding == null || encoding.length() == 0) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    public static String getLogEncoding(Project project, VirtualFile root) {
        String encoding = null;
        try {
            encoding = GitConfigUtil.getValue(project, root, "i18n.logoutputencoding");
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
        if (encoding == null || encoding.length() == 0) {
            encoding = GitConfigUtil.getCommitEncoding(project, root);
        }
        return encoding;
    }

    public static String getFileNameEncoding() {
        return Charset.defaultCharset().name();
    }

    public static void setValue(Project project, VirtualFile root, String key, String value, String ... additionalParameters) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.CONFIG);
        h.setSilent(true);
        h.addParameters(additionalParameters);
        h.addParameters(key, value);
        Git.getInstance().runCommand(h).throwOnError(1);
    }

    public static boolean isCredentialHelperUsed(Project project, File workingDirectory) {
        try {
            String value = GitConfigUtil.getValue(project, VfsUtil.findFileByIoFile((File)workingDirectory, (boolean)true), "credential.helper");
            return value != null && !value.isEmpty();
        }
        catch (VcsException ignored) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "git4idea/config/GitConfigUtil", "getBooleanValue"));
    }
}

