/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeRequestProducer;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import git4idea.conflicts.GitMergeHandler;
import git4idea.conflicts.MergeConflictResolveUtil;
import java.awt.Window;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0016\u0017\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J.\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil;", "", "()V", "ACTIVE_MERGE_WINDOW", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/ui/WindowWrapper;", "kotlin.jvm.PlatformType", "focusActiveMergeWindow", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "putActiveWindowKey", "", "project", "Lcom/intellij/openapi/project/Project;", "wrapper", "showMergeWindow", "lock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "resolverComputer", "Lkotlin/Function0;", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "MyMergeCallback", "MyProducer", "NotificationProvider", "intellij.vcs.git"})
public final class MergeConflictResolveUtil {
    private static final Key<WindowWrapper> ACTIVE_MERGE_WINDOW;
    public static final MergeConflictResolveUtil INSTANCE;

    public final void showMergeWindow(@NotNull Project project, @Nullable VirtualFile file, @NotNull BackgroundableActionLock lock, @NotNull Function0<? extends GitMergeHandler.Resolver> resolverComputer) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)lock, (String)"lock");
        Intrinsics.checkParameterIsNotNull(resolverComputer, (String)"resolverComputer");
        if (this.focusActiveMergeWindow(file)) {
            return;
        }
        if (lock.isLocked()) {
            return;
        }
        lock.lock();
        String string = file != null ? new MergeDialogCustomizer().getMergeWindowTitle(file) : "Merge";
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (file != null) MergeD\u2026wTitle(file) else \"Merge\"");
        String title = string;
        Consumer windowHandler2 = (Consumer)new Consumer<WindowWrapper>(lock, project, file){
            final /* synthetic */ BackgroundableActionLock $lock;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $file;

            public final void consume(WindowWrapper wrapper) {
                WindowWrapper windowWrapper = wrapper;
                Intrinsics.checkExpressionValueIsNotNull((Object)windowWrapper, (String)"wrapper");
                UIUtil.runWhenWindowClosed((Window)windowWrapper.getWindow(), (Runnable)new Runnable(this){
                    final /* synthetic */ showMergeWindow.windowHandler.1 this$0;

                    public final void run() {
                        this.this$0.$lock.unlock();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                MergeConflictResolveUtil.access$putActiveWindowKey(MergeConflictResolveUtil.INSTANCE, this.$project, wrapper, this.$file);
            }
            {
                this.$lock = backgroundableActionLock;
                this.$project = project;
                this.$file = virtualFile;
            }
        };
        DiffDialogHints hints = new DiffDialogHints(WindowWrapper.Mode.FRAME, null, windowHandler2);
        MyProducer producer = new MyProducer(project, title, resolverComputer);
        DiffManagerEx.getInstance().showMergeBuiltin(project, (MergeRequestProducer)producer, hints);
    }

    private final void putActiveWindowKey(Project project, WindowWrapper wrapper, VirtualFile file) {
        if (file == null) {
            return;
        }
        Window window = wrapper.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"wrapper.window");
        Window window2 = window;
        if (!(window2 instanceof JFrame)) {
            return;
        }
        file.putUserData(ACTIVE_MERGE_WINDOW, (Object)wrapper);
        EditorNotifications.getInstance((Project)project).updateNotifications(file);
        UIUtil.runWhenWindowClosed((Window)window2, (Runnable)new Runnable(file, project){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;

            public final void run() {
                this.$file.putUserData(MergeConflictResolveUtil.access$getACTIVE_MERGE_WINDOW$p(MergeConflictResolveUtil.INSTANCE), null);
                EditorNotifications.getInstance((Project)this.$project).updateNotifications(this.$file);
            }
            {
                this.$file = virtualFile;
                this.$project = project;
            }
        });
    }

    private final boolean focusActiveMergeWindow(VirtualFile file) {
        VirtualFile virtualFile = file;
        if (virtualFile == null || (virtualFile = (WindowWrapper)virtualFile.getUserData(ACTIVE_MERGE_WINDOW)) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"file?.getUserData(ACTIVE\u2026E_WINDOW) ?: return false");
        VirtualFile wrapper = virtualFile;
        UIUtil.toFront((Window)wrapper.getWindow());
        return true;
    }

    private MergeConflictResolveUtil() {
    }

    static {
        MergeConflictResolveUtil mergeConflictResolveUtil;
        INSTANCE = mergeConflictResolveUtil = new MergeConflictResolveUtil();
        Key key = Key.create((String)"ResolveConflictsWindow");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<WindowWrapper\u2026\"ResolveConflictsWindow\")");
        ACTIVE_MERGE_WINDOW = key;
    }

    public static final /* synthetic */ Key access$getACTIVE_MERGE_WINDOW$p(MergeConflictResolveUtil $this) {
        MergeConflictResolveUtil mergeConflictResolveUtil = $this;
        return ACTIVE_MERGE_WINDOW;
    }

    public static final /* synthetic */ void access$putActiveWindowKey(MergeConflictResolveUtil $this, Project project, WindowWrapper wrapper, VirtualFile file) {
        $this.putActiveWindowKey(project, wrapper, file);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$MyProducer;", "Lcom/intellij/diff/merge/MergeRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "resolverComputer", "Lkotlin/Function0;", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getResolverComputer", "()Lkotlin/jvm/functions/Function0;", "getTitle", "()Ljava/lang/String;", "getName", "process", "Lcom/intellij/diff/merge/MergeRequest;", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.vcs.git"})
    private static final class MyProducer
    implements MergeRequestProducer {
        @NotNull
        private final Project project;
        @NotNull
        private final String title;
        @NotNull
        private final Function0<GitMergeHandler.Resolver> resolverComputer;

        @NotNull
        public String getName() {
            return this.title;
        }

        @NotNull
        public MergeRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
            try {
                GitMergeHandler.Resolver resolver = (GitMergeHandler.Resolver)this.resolverComputer.invoke();
                MergeData mergeData = resolver.getMergeData();
                Intrinsics.checkExpressionValueIsNotNull((Object)mergeData, (String)"resolver.mergeData");
                MergeData mergeData2 = mergeData;
                List byteContents = CollectionsKt.listOf((Object[])new byte[][]{mergeData2.CURRENT, mergeData2.ORIGINAL, mergeData2.LAST});
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction(new Computable<T>(this, resolver, byteContents){
                    final /* synthetic */ MyProducer this$0;
                    final /* synthetic */ GitMergeHandler.Resolver $resolver$inlined;
                    final /* synthetic */ List $byteContents$inlined;
                    {
                        this.this$0 = myProducer;
                        this.$resolver$inlined = resolver;
                        this.$byteContents$inlined = list;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)DiffRequestFactory.getInstance().createMergeRequest(this.this$0.getProject(), this.$resolver$inlined.getVirtualFile(), this.$byteContents$inlined, this.$resolver$inlined.getWindowTitle(), this.$resolver$inlined.getContentTitles());
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runReadAction {\n        \u2026.contentTitles)\n        }");
                MergeRequest request = (MergeRequest)object;
                MergeUtil.putRevisionInfos((MergeRequest)request, (MergeData)mergeData2);
                MergeCallback.register((MergeRequest)request, (MergeCallback)new MyMergeCallback(resolver));
                return request;
            }
            catch (Throwable e) {
                throw (Throwable)new DiffRequestProducerException(e);
            }
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final Function0<GitMergeHandler.Resolver> getResolverComputer() {
            return this.resolverComputer;
        }

        public MyProducer(@NotNull Project project, @NotNull String title, @NotNull Function0<? extends GitMergeHandler.Resolver> resolverComputer) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
            Intrinsics.checkParameterIsNotNull(resolverComputer, (String)"resolverComputer");
            this.project = project;
            this.title = title;
            this.resolverComputer = resolverComputer;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$MyMergeCallback;", "Lcom/intellij/diff/merge/MergeCallback;", "resolver", "Lgit4idea/conflicts/GitMergeHandler$Resolver;", "(Lgit4idea/conflicts/GitMergeHandler$Resolver;)V", "addListener", "", "listener", "Lcom/intellij/diff/merge/MergeCallback$Listener;", "disposable", "Lcom/intellij/openapi/Disposable;", "applyResult", "result", "Lcom/intellij/diff/merge/MergeResult;", "checkIsValid", "", "intellij.vcs.git"})
    private static final class MyMergeCallback
    extends MergeCallback {
        private final GitMergeHandler.Resolver resolver;

        /*
         * WARNING - void declaration
         */
        public void applyResult(@NotNull MergeResult result2) {
            Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
            Project project = this.resolver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"resolver.project");
            Project project2 = project;
            VirtualFile virtualFile = this.resolver.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"resolver.virtualFile");
            VirtualFile file = virtualFile;
            Document document = FileDocumentManager.getInstance().getCachedDocument(file);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            MergeUtil.reportProjectFileChangeIfNeeded((Project)project2, (VirtualFile)file);
            if (result2 != MergeResult.CANCEL) {
                void title$iv;
                String string = "Finishing Conflict Resolve";
                boolean cancellable$iv = false;
                boolean $i$f$runBackgroundableTask = false;
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, (String)title$iv, cancellable$iv, project2, (String)title$iv, cancellable$iv, this, result2){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $title;
                    final /* synthetic */ boolean $cancellable;
                    final /* synthetic */ MyMergeCallback this$0;
                    final /* synthetic */ MergeResult $result$inlined;
                    {
                        this.$project = $captured_local_variable$1;
                        this.$title = $captured_local_variable$2;
                        this.$cancellable = $captured_local_variable$3;
                        this.this$0 = myMergeCallback;
                        this.$result$inlined = mergeResult;
                        super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                        ProgressIndicator it = indicator;
                        boolean bl = false;
                        MyMergeCallback.access$getResolver$p(this.this$0).onConflictResolved(this.$result$inlined);
                    }
                });
            }
        }

        public boolean checkIsValid() {
            return this.resolver.checkIsValid();
        }

        public void addListener(@NotNull MergeCallback.Listener listener2, @NotNull Disposable disposable) {
            Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
            Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
            this.resolver.addListener(listener2, disposable);
        }

        public MyMergeCallback(@NotNull GitMergeHandler.Resolver resolver) {
            Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
            this.resolver = resolver;
        }

        public static final /* synthetic */ GitMergeHandler.Resolver access$getResolver$p(MyMergeCallback $this) {
            return $this.resolver;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/conflicts/MergeConflictResolveUtil$NotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "intellij.vcs.git"})
    public static final class NotificationProvider
    extends EditorNotifications.Provider<EditorNotificationPanel> {
        private final Key<EditorNotificationPanel> KEY;

        @NotNull
        public Key<EditorNotificationPanel> getKey() {
            return this.KEY;
        }

        @Nullable
        public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)fileEditor, (String)"fileEditor");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            WindowWrapper windowWrapper = (WindowWrapper)file.getUserData(MergeConflictResolveUtil.access$getACTIVE_MERGE_WINDOW$p(INSTANCE));
            if (windowWrapper == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)windowWrapper, (String)"file.getUserData(ACTIVE_\u2026GE_WINDOW) ?: return null");
            WindowWrapper wrapper = windowWrapper;
            EditorNotificationPanel panel = new EditorNotificationPanel(LightColors.SLIGHTLY_GREEN);
            panel.setText("Merge conflicts resolve in progress.");
            panel.createActionLabel("Focus Window", new Runnable(wrapper){
                final /* synthetic */ WindowWrapper $wrapper;

                public final void run() {
                    UIUtil.toFront((Window)this.$wrapper.getWindow());
                }
                {
                    this.$wrapper = windowWrapper;
                }
            });
            panel.createActionLabel("Cancel Resolve", new Runnable(wrapper){
                final /* synthetic */ WindowWrapper $wrapper;

                public final void run() {
                    this.$wrapper.close();
                }
                {
                    this.$wrapper = windowWrapper;
                }
            });
            return panel;
        }

        public NotificationProvider() {
            Key key = Key.create((String)"MergeConflictResolveUtil.NotificationProvider");
            Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<EditorNotific\u2026il.NotificationProvider\")");
            this.KEY = key;
        }
    }
}

