/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.history.GitChangeType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitChangesParser {
    private static final Logger LOG = Logger.getInstance(GitChangesParser.class);

    @NotNull
    public static List<Change> parse(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<? extends VcsFileStatusInfo> statusInfos, @NotNull String hash, @NotNull Date date, @Nullable String parentsHash) {
        if (project == null) {
            GitChangesParser.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitChangesParser.$$$reportNull$$$0(1);
        }
        if (statusInfos == null) {
            GitChangesParser.$$$reportNull$$$0(2);
        }
        if (hash == null) {
            GitChangesParser.$$$reportNull$$$0(3);
        }
        if (date == null) {
            GitChangesParser.$$$reportNull$$$0(4);
        }
        GitRevisionNumber thisRevision = new GitRevisionNumber(hash, date);
        GitRevisionNumber parentRevision = parentsHash == null ? null : new GitRevisionNumber(parentsHash);
        ArrayList<Change> result2 = new ArrayList<Change>();
        for (VcsFileStatusInfo vcsFileStatusInfo : statusInfos) {
            result2.add(GitChangesParser.parseChange(project, root, (VcsRevisionNumber)thisRevision, (VcsRevisionNumber)parentRevision, vcsFileStatusInfo));
        }
        ArrayList<Change> arrayList = result2;
        if (arrayList == null) {
            GitChangesParser.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static Change parseChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull VcsRevisionNumber thisRevision, @Nullable VcsRevisionNumber parentRevision, @NotNull VcsFileStatusInfo statusInfo) {
        ContentRevision after;
        FileStatus status;
        ContentRevision before;
        if (project == null) {
            GitChangesParser.$$$reportNull$$$0(6);
        }
        if (vcsRoot == null) {
            GitChangesParser.$$$reportNull$$$0(7);
        }
        if (thisRevision == null) {
            GitChangesParser.$$$reportNull$$$0(8);
        }
        if (statusInfo == null) {
            GitChangesParser.$$$reportNull$$$0(9);
        }
        String path = statusInfo.getFirstPath();
        FilePath filePath = GitContentRevision.createPath(vcsRoot, path);
        switch (statusInfo.getType()) {
            case NEW: {
                before = null;
                status = FileStatus.ADDED;
                after = GitContentRevision.createRevision(filePath, thisRevision, project);
                break;
            }
            case MODIFICATION: {
                status = FileStatus.MODIFIED;
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                after = GitContentRevision.createRevision(filePath, thisRevision, project);
                break;
            }
            case DELETED: {
                status = FileStatus.DELETED;
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                after = null;
                break;
            }
            case MOVED: {
                status = FileStatus.MODIFIED;
                String secondPath = statusInfo.getSecondPath();
                FilePath filePathAfterRename = secondPath == null ? filePath : GitContentRevision.createPath(vcsRoot, secondPath);
                before = GitContentRevision.createRevision(filePath, parentRevision, project);
                after = GitContentRevision.createRevision(filePathAfterRename, thisRevision, project);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown file status: " + statusInfo));
            }
        }
        Change change = new Change(before, after, status);
        if (change == null) {
            GitChangesParser.$$$reportNull$$$0(10);
        }
        return change;
    }

    @NotNull
    static Change.Type getChangeType(@NotNull GitChangeType type) {
        if (type == null) {
            GitChangesParser.$$$reportNull$$$0(11);
        }
        switch (type) {
            case ADDED: {
                Change.Type type2 = Change.Type.NEW;
                if (type2 == null) {
                    GitChangesParser.$$$reportNull$$$0(12);
                }
                return type2;
            }
            case TYPE_CHANGED: 
            case MODIFIED: {
                Change.Type type3 = Change.Type.MODIFICATION;
                if (type3 == null) {
                    GitChangesParser.$$$reportNull$$$0(13);
                }
                return type3;
            }
            case DELETED: {
                Change.Type type4 = Change.Type.DELETED;
                if (type4 == null) {
                    GitChangesParser.$$$reportNull$$$0(14);
                }
                return type4;
            }
            case COPIED: 
            case RENAMED: {
                Change.Type type5 = Change.Type.MOVED;
                if (type5 == null) {
                    GitChangesParser.$$$reportNull$$$0(15);
                }
                return type5;
            }
        }
        LOG.error("Unknown git change type: " + (Object)((Object)type));
        Change.Type type6 = Change.Type.MODIFICATION;
        if (type6 == null) {
            GitChangesParser.$$$reportNull$$$0(16);
        }
        return type6;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusInfos";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitChangesParser";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisRevision";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusInfo";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitChangesParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseChange";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChangeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

