/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.config.GitConfigUtil;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitInteractiveRebaseFile;
import git4idea.rebase.GitRebaseEntry;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001e\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0006\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/rebase/GitAutomaticRebaseEditor;", "Lgit4idea/rebase/GitInteractiveRebaseEditorHandler;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "entriesEditor", "Lkotlin/Function1;", "", "Lgit4idea/rebase/GitRebaseEntry;", "plainTextEditor", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "editCommits", "", "path", "intellij.vcs.git"})
public final class GitAutomaticRebaseEditor
extends GitInteractiveRebaseEditorHandler {
    @NotNull
    private final Logger LOG;
    private final Project project;
    private final VirtualFile root;
    private final Function1<List<GitRebaseEntry>, List<GitRebaseEntry>> entriesEditor;
    private final Function1<String, String> plainTextEditor;

    @NotNull
    public final Logger getLOG() {
        return this.LOG;
    }

    @Override
    public int editCommits(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        try {
            if (!this.myRebaseEditorShown) {
                this.myRebaseEditorShown = true;
                GitInteractiveRebaseFile file = new GitInteractiveRebaseFile(this.project, this.root, path);
                List<GitRebaseEntry> list = file.load();
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"file.load()");
                List<GitRebaseEntry> entries = list;
                file.save((List)this.entriesEditor.invoke(entries));
            } else {
                Object object;
                String encoding = GitConfigUtil.getCommitEncoding(this.project, this.root);
                String string = FileUtil.loadFile((File)new File(path), (String)encoding);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.loadFile(File(path), encoding)");
                String originalMessage = string;
                String modifiedMessage = (String)this.plainTextEditor.invoke((Object)originalMessage);
                File file = new File(path);
                String string2 = modifiedMessage;
                String string3 = encoding;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"encoding");
                Object object2 = string3;
                File file2 = file;
                boolean bl = false;
                Charset charset = Charset.forName((String)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                object2 = object = charset;
                bl = false;
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string4.getBytes((Charset)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object = byArray;
                FileUtil.writeToFile((File)file2, (byte[])object);
            }
            return 0;
        }
        catch (Exception ex) {
            this.LOG.error("Editor failed: ", (Throwable)ex);
            return 2;
        }
    }

    public GitAutomaticRebaseEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull Function1<? super List<GitRebaseEntry>, ? extends List<GitRebaseEntry>> entriesEditor, @NotNull Function1<? super String, String> plainTextEditor) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(entriesEditor, (String)"entriesEditor");
        Intrinsics.checkParameterIsNotNull(plainTextEditor, (String)"plainTextEditor");
        super(project, root);
        this.project = project;
        this.root = root;
        this.entriesEditor = entriesEditor;
        this.plainTextEditor = plainTextEditor;
        GitAutomaticRebaseEditor gitAutomaticRebaseEditor = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(GitAutomaticRebaseEditor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        gitAutomaticRebaseEditor.LOG = logger = logger2;
    }
}

