%% mpicpm07-8.m  (Figure 7.8)
\documentclass[a4paper]{article}
\usepackage{mathspic}
\begin{document}
\beginpicture
\setdashes
paper{units(1mm),xrange(0,70),yrange(0,60),axes(LBT*R*),ticks(10,10)}
\setsolid
point(A){10,10}   %% anchor point
point(B){A, polar(50,50 deg)}
point(C){A,polar(50,0 deg)}
point(J){pointonline(AB,30)}
point(K){perpendicular(J,AC)}
drawRightangle(JKC,3)
drawLine(AB,AC,JK)
drawIncircle(AJK)
drawExcircle(AJK,JK)
\setplotsymbol({\large .}) \setdots
drawCircumcircle(AJK)
\setplotsymbol({\tiny .})
point(I){IncircleCenter(AJK)}[symbol=$\odot$, radius=1.2]
point(E){ExcircleCenter(AJK,JK)}[symbol=$\odot$, radius=1.2]
point(P1){perpendicular(E,AC)}
var r = EP1  %% radius of excircle
var d = 72   %% angle of pentagon (deg)
var a1 = -90, a2=a1+d, a3=a2+d, a4=a3+d, a5=a4+d
point(P2){E, polar(r,a2 deg)}
point(P3){E, polar(r,a3 deg)}
point(P4){E, polar(r,a4 deg)}
point(P5){E, polar(r,a5 deg)}
drawPoint(ABCJKIEP1P2P3P4P5)
\setdashes
drawLine(P1P2P3P4P5P1,EP1,EP2)
\setsolid
drawAngleArc{angle(P2EP1),radius(9),internal,clockwise}
\newcommand{\figtitle}{%
   \fbox{%
   \begin{minipage}{30mm}%
   \  Triangle, pentagon and three circles%
   \end{minipage}%
   \  }}%
text(\figtitle){20,52}
var s = 5
text($A$){A,polar(s,230 deg)}
text($B$){B,polar(s,50 deg)}
text($C$){C,polar(s,0 deg)}
text($J$){J,polar(s,90 deg)}
text($K$){K,polar(s,270 deg)}
text($E$){E,polar(s,a3 deg)}
text($72$){E,polar(5.5,-54 deg)}
text($I$){I,shift(3, 0)}
text($P_1$){P1,polar(s, a1 deg)}
text($P_2$){P2,polar(s, a2 deg)}
text($P_3$){P3,polar(s, a3 deg)}
\endpicture
\end{document}
