/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.commandline;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.spi.FilterReply;
import liquibase.logging.LogType;
import org.slf4j.ILoggerFactory;
import org.slf4j.Marker;

public class CommandLineOutputAppender
extends ConsoleAppender {
    private Mode mode = Mode.STANDARD;

    public CommandLineOutputAppender(ILoggerFactory loggerContext, String target) {
        this.setContext((Context)((LoggerContext)loggerContext));
        this.setTarget(target);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern("%msg%n");
        encoder.setContext((Context)((LoggerContext)loggerContext));
        encoder.start();
        this.setEncoder((Encoder)encoder);
        this.addFilter(new ModeFilter());
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static enum Mode {
        STANDARD,
        PIPE_SQL,
        FULL_LOG;

    }

    protected class ModeFilter
    extends Filter {
        protected ModeFilter() {
        }

        public FilterReply decide(Object event) {
            Marker marker = ((LoggingEvent)event).getMarker();
            LogType logType = LogType.valueOf(marker.getName());
            if (CommandLineOutputAppender.this.mode == Mode.STANDARD) {
                if (logType == LogType.USER_MESSAGE && CommandLineOutputAppender.this.target.equals((Object)ConsoleTarget.SystemOut)) {
                    return FilterReply.ACCEPT;
                }
                return FilterReply.DENY;
            }
            if (CommandLineOutputAppender.this.mode == Mode.PIPE_SQL) {
                if (logType == LogType.USER_MESSAGE && CommandLineOutputAppender.this.target == ConsoleTarget.SystemErr) {
                    return FilterReply.ACCEPT;
                }
                if (logType == LogType.WRITE_SQL && CommandLineOutputAppender.this.target == ConsoleTarget.SystemOut) {
                    return FilterReply.ACCEPT;
                }
                return FilterReply.DENY;
            }
            return FilterReply.DENY;
        }
    }
}

