/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.type;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.type.UnrecoverablePduException;

public class SmppBindException
extends UnrecoverablePduException {
    static final long serialVersionUID = 1L;
    private final BaseBindResp bindResponse;

    public SmppBindException(BaseBindResp bindResponse) {
        super(SmppBindException.buildErrorMessage(bindResponse));
        this.bindResponse = bindResponse;
    }

    public BaseBindResp getBindResponse() {
        return this.bindResponse;
    }

    public static String buildErrorMessage(BaseBindResp bindResponse) {
        if (bindResponse == null) {
            return "Bind request failed (response was null)";
        }
        return "Unable to bind [error: 0x" + HexUtil.toHexString((int)bindResponse.getCommandStatus()) + " \"" + bindResponse.getResultMessage() + "\"]";
    }
}

