/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import javax.json.JsonObject;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.JsonGeocoder;

public class GisgraphyGeocoder
extends JsonGeocoder {
    public GisgraphyGeocoder(AddressFormat addressFormat) {
        this("http://services.gisgraphy.com/reversegeocoding/search", 0, addressFormat);
    }

    public GisgraphyGeocoder(String url, int cacheSize, AddressFormat addressFormat) {
        super(url + "?format=json&lat=%f&lng=%f&from=1&to=1", cacheSize, addressFormat);
    }

    @Override
    public Address parseAddress(JsonObject json) {
        Address address = new Address();
        JsonObject result = json.getJsonArray("result").getJsonObject(0);
        if (result.containsKey((Object)"streetName")) {
            address.setStreet(result.getString("streetName"));
        }
        if (result.containsKey((Object)"city")) {
            address.setSettlement(result.getString("city"));
        }
        if (result.containsKey((Object)"state")) {
            address.setState(result.getString("state"));
        }
        if (result.containsKey((Object)"countryCode")) {
            address.setCountry(result.getString("countryCode"));
        }
        if (result.containsKey((Object)"formatedFull")) {
            address.setFormattedAddress(result.getString("formatedFull"));
        }
        return address;
    }
}

