/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geolocation;

import javax.json.JsonObject;
import javax.ws.rs.client.InvocationCallback;
import org.traccar.Context;
import org.traccar.geolocation.GeolocationException;
import org.traccar.geolocation.GeolocationProvider;
import org.traccar.model.CellTower;
import org.traccar.model.Network;

public class OpenCellIdGeolocationProvider
implements GeolocationProvider {
    private String url;

    public OpenCellIdGeolocationProvider(String key) {
        this("http://opencellid.org/cell/get", key);
    }

    public OpenCellIdGeolocationProvider(String url, String key) {
        this.url = url + "?format=json&mcc=%d&mnc=%d&lac=%d&cellid=%d&key=" + key;
    }

    @Override
    public void getLocation(Network network, final GeolocationProvider.LocationProviderCallback callback) {
        if (network.getCellTowers() != null && !network.getCellTowers().isEmpty()) {
            CellTower cellTower = network.getCellTowers().iterator().next();
            String request = String.format(this.url, cellTower.getMobileCountryCode(), cellTower.getMobileNetworkCode(), cellTower.getLocationAreaCode(), cellTower.getCellId());
            Context.getClient().target(request).request().async().get((InvocationCallback)new InvocationCallback<JsonObject>(){

                public void completed(JsonObject json) {
                    if (json.containsKey((Object)"lat") && json.containsKey((Object)"lon")) {
                        callback.onSuccess(json.getJsonNumber("lat").doubleValue(), json.getJsonNumber("lon").doubleValue(), 0.0);
                    } else {
                        callback.onFailure(new GeolocationException("Coordinates are missing"));
                    }
                }

                public void failed(Throwable throwable) {
                    callback.onFailure(throwable);
                }
            });
        } else {
            callback.onFailure(new GeolocationException("No network information"));
        }
    }
}

