/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.notification.MessageException;

public abstract class Notificator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Notificator.class);

    public void sendAsync(final long userId, final Event event, final Position position) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Notificator.this.sendSync(userId, event, position);
                }
                catch (InterruptedException | MessageException error) {
                    LOGGER.warn("Event send error", (Throwable)error);
                }
            }
        }).start();
    }

    public abstract void sendSync(long var1, Event var3, Position var4) throws MessageException, InterruptedException;
}

