/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.traccar.BaseFrameDecoder;

public class HuabaoFrameDecoder
extends BaseFrameDecoder {
    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ByteBuf buf) throws Exception {
        if (buf.readableBytes() < 2) {
            return null;
        }
        int index = buf.indexOf(buf.readerIndex() + 1, buf.writerIndex(), (byte)126);
        if (index != -1) {
            ByteBuf result = Unpooled.buffer((int)(index + 1 - buf.readerIndex()));
            while (buf.readerIndex() <= index) {
                short b = buf.readUnsignedByte();
                if (b == 125) {
                    short ext = buf.readUnsignedByte();
                    if (ext == 1) {
                        result.writeByte(125);
                        continue;
                    }
                    if (ext != 2) continue;
                    result.writeByte(126);
                    continue;
                }
                result.writeByte((int)b);
            }
            return result;
        }
        return null;
    }
}

