/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class Minifinder2ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_DATA = 1;

    public Minifinder2ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int code) {
        if (BitUtil.check(code, 0)) {
            return "lowBattery";
        }
        if (BitUtil.check(code, 1)) {
            return "overspeed";
        }
        if (BitUtil.check(code, 2)) {
            return "fallDown";
        }
        if (BitUtil.check(code, 8)) {
            return "powerOff";
        }
        if (BitUtil.check(code, 9)) {
            return "powerOn";
        }
        if (BitUtil.check(code, 12)) {
            return "sos";
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        short type = buf.readUnsignedByte();
        if (type == 1) {
            Position position = new Position(this.getProtocolName());
            while (buf.isReadable()) {
                int endIndex = buf.readUnsignedByte() + buf.readerIndex();
                short key = buf.readUnsignedByte();
                switch (key) {
                    case 1: {
                        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, buf.readCharSequence(15, StandardCharsets.US_ASCII).toString());
                        if (deviceSession == null) {
                            return null;
                        }
                        position.setDeviceId(deviceSession.getDeviceId());
                        break;
                    }
                    case 2: {
                        position.set("alarm", this.decodeAlarm(buf.readIntLE()));
                        break;
                    }
                    case 32: {
                        position.setLatitude((double)buf.readIntLE() * 1.0E-7);
                        position.setLongitude((double)buf.readIntLE() * 1.0E-7);
                        position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedShortLE()));
                        position.setCourse(buf.readUnsignedShortLE());
                        position.setAltitude(buf.readShortLE());
                        position.setValid(buf.readUnsignedShortLE() > 0);
                        position.set("odometer", buf.readUnsignedIntLE());
                        position.set("sat", buf.readUnsignedByte());
                        break;
                    }
                    case 33: {
                        byte rssi;
                        int mcc = buf.readUnsignedShortLE();
                        short mnc = buf.readUnsignedByte();
                        if (position.getNetwork() == null) {
                            position.setNetwork(new Network());
                        }
                        while (buf.readerIndex() < endIndex) {
                            rssi = buf.readByte();
                            position.getNetwork().addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShortLE(), buf.readUnsignedShortLE(), rssi));
                        }
                        break;
                    }
                    case 34: {
                        byte rssi;
                        if (position.getNetwork() == null) {
                            position.setNetwork(new Network());
                        }
                        while (buf.readerIndex() < endIndex) {
                            rssi = buf.readByte();
                            String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                            position.getNetwork().addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), rssi));
                        }
                        break;
                    }
                    case 64: {
                        buf.readUnsignedIntLE();
                        short heartRate = buf.readUnsignedByte();
                        if (heartRate <= 1) break;
                        position.set("heartRate", Integer.valueOf(heartRate));
                        break;
                    }
                }
                buf.readerIndex(endIndex);
            }
            if (!position.getAttributes().containsKey("sat")) {
                this.getLastLocation(position, null);
            }
            return position.getDeviceId() > 0L ? position : null;
        }
        return null;
    }
}

