/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.sms.smpp;

import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.pdu.EnquireLink;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.sms.smpp.SmppClient;

public class EnquireLinkTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnquireLinkTask.class);
    private SmppClient smppClient;
    private Integer enquireLinkTimeout;

    public EnquireLinkTask(SmppClient smppClient, Integer enquireLinkTimeout) {
        this.smppClient = smppClient;
        this.enquireLinkTimeout = enquireLinkTimeout;
    }

    @Override
    public void run() {
        SmppSession smppSession = this.smppClient.getSession();
        if (smppSession != null && smppSession.isBound()) {
            try {
                smppSession.enquireLink(new EnquireLink(), (long)this.enquireLinkTimeout.intValue());
            }
            catch (RecoverablePduException | SmppChannelException | SmppTimeoutException | UnrecoverablePduException error) {
                LOGGER.warn("Enquire link failed, executing reconnect: ", error);
                this.smppClient.scheduleReconnect();
            }
            catch (InterruptedException error) {
                LOGGER.info("Enquire link interrupted, probably killed by reconnecting");
            }
        } else {
            LOGGER.warn("Enquire link running while session is not connected");
        }
    }
}

