/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.HashMap;
import net.sf.saxon.om.StructuredQName;

public abstract class StandardNames {
    private static final int DFLT_NS = 0;
    private static final int XSL_NS = 1;
    private static final int SAXON_NS = 2;
    private static final int XML_NS = 3;
    private static final int XS_NS = 4;
    private static final int XSI_NS = 5;
    private static final int SCM_NS = 6;
    public static final int DFLT = 0;
    public static final int XSL = 128;
    public static final int SAXON = 256;
    public static final int XML = 384;
    public static final int XS = 512;
    public static final int XSI = 640;
    public static final int SCM = 768;
    public static final int XSL_ANALYZE_STRING = 128;
    public static final int XSL_APPLY_IMPORTS = 129;
    public static final int XSL_APPLY_TEMPLATES = 130;
    public static final int XSL_ATTRIBUTE = 131;
    public static final int XSL_ATTRIBUTE_SET = 132;
    public static final int XSL_CALL_TEMPLATE = 133;
    public static final int XSL_CHARACTER_MAP = 134;
    public static final int XSL_CHOOSE = 135;
    public static final int XSL_COMMENT = 138;
    public static final int XSL_COPY = 139;
    public static final int XSL_COPY_OF = 140;
    public static final int XSL_DECIMAL_FORMAT = 141;
    public static final int XSL_DOCUMENT = 142;
    public static final int XSL_ELEMENT = 143;
    public static final int XSL_FALLBACK = 144;
    public static final int XSL_FOR_EACH = 145;
    public static final int XSL_FOR_EACH_GROUP = 148;
    public static final int XSL_FUNCTION = 149;
    public static final int XSL_IF = 150;
    public static final int XSL_IMPORT = 151;
    public static final int XSL_IMPORT_SCHEMA = 152;
    public static final int XSL_INCLUDE = 153;
    public static final int XSL_KEY = 154;
    public static final int XSL_MATCHING_SUBSTRING = 155;
    public static final int XSL_MESSAGE = 158;
    public static final int XSL_NEXT_MATCH = 159;
    public static final int XSL_NUMBER = 160;
    public static final int XSL_NAMESPACE = 161;
    public static final int XSL_NAMESPACE_ALIAS = 162;
    public static final int XSL_NON_MATCHING_SUBSTRING = 163;
    public static final int XSL_OTHERWISE = 164;
    public static final int XSL_OUTPUT = 165;
    public static final int XSL_OUTPUT_CHARACTER = 169;
    public static final int XSL_PARAM = 170;
    public static final int XSL_PERFORM_SORT = 171;
    public static final int XSL_PRESERVE_SPACE = 172;
    public static final int XSL_PROCESSING_INSTRUCTION = 173;
    public static final int XSL_RESULT_DOCUMENT = 174;
    public static final int XSL_SEQUENCE = 175;
    public static final int XSL_SORT = 178;
    public static final int XSL_STRIP_SPACE = 179;
    public static final int XSL_STYLESHEET = 180;
    public static final int XSL_TEMPLATE = 181;
    public static final int XSL_TEXT = 182;
    public static final int XSL_TRANSFORM = 183;
    public static final int XSL_VALUE_OF = 184;
    public static final int XSL_VARIABLE = 185;
    public static final int XSL_WITH_PARAM = 188;
    public static final int XSL_WHEN = 189;
    public static final int XSL_DEFAULT_COLLATION = 228;
    public static final int XSL_EXCLUDE_RESULT_PREFIXES = 229;
    public static final int XSL_EXTENSION_ELEMENT_PREFIXES = 230;
    public static final int XSL_INHERIT_NAMESPACES = 231;
    public static final int XSL_TYPE = 232;
    public static final int XSL_USE_ATTRIBUTE_SETS = 233;
    public static final int XSL_USE_WHEN = 234;
    public static final int XSL_VALIDATION = 235;
    public static final int XSL_VERSION = 236;
    public static final int XSL_XPATH_DEFAULT_NAMESPACE = 237;
    private static final String XSL_B = "{http://www.w3.org/1999/XSL/Transform}";
    public static final String XSL_DEFAULT_COLLATION_CLARK = "{http://www.w3.org/1999/XSL/Transform}default-collation";
    public static final String XSL_INHERIT_NAMESPACES_CLARK = "{http://www.w3.org/1999/XSL/Transform}inherit-namespaces";
    public static final String XSL_VERSION_CLARK = "{http://www.w3.org/1999/XSL/Transform}version";
    public static final String XSL_XPATH_DEFAULT_NAMESPACE_CLARK = "{http://www.w3.org/1999/XSL/Transform}xpath-default-namespace";
    public static final String XSL_EXTENSION_ELEMENT_PREFIXES_CLARK = "{http://www.w3.org/1999/XSL/Transform}extension-element-prefixes";
    public static final String XSL_EXCLUDE_RESULT_PREFIXES_CLARK = "{http://www.w3.org/1999/XSL/Transform}exclude-result-prefixes";
    public static final int SAXON_ASSIGN = 257;
    public static final int SAXON_BREAK = 258;
    public static final int SAXON_CALL_TEMPLATE = 259;
    public static final int SAXON_COLLATION = 260;
    public static final int SAXON_CONTINUE = 261;
    public static final int SAXON_DOCTYPE = 262;
    public static final int SAXON_ENTITY_REF = 263;
    public static final int SAXON_FINALLY = 264;
    public static final int SAXON_IMPORT_QUERY = 265;
    public static final int SAXON_ITERATE = 266;
    public static final int SAXON_SCRIPT = 267;
    public static final int SAXON_WHILE = 268;
    private static final String SAXON_B = "{http://saxon.sf.net/}";
    public static final String SAXON_ALLOW_ALL_BUILT_IN_TYPES = "{http://saxon.sf.net/}allow-all-built-in-types";
    public static final String SAXON_ASSIGNABLE = "{http://saxon.sf.net/}assignable";
    public static final String SAXON_CHARACTER_REPRESENTATION = "{http://saxon.sf.net/}character-representation";
    public static final String SAXON_DOUBLE_SPACE = "{http://saxon.sf.net/}double-space";
    public static final String SAXON_EXPLAIN = "{http://saxon.sf.net/}explain";
    public static final String SAXON_READ_ONCE = "{http://saxon.sf.net/}read-once";
    public static final String SAXON_INDENT_SPACES = "{http://saxon.sf.net/}indent-spaces";
    public static final String SAXON_NEXT_IN_CHAIN = "{http://saxon.sf.net/}next-in-chain";
    public static final String SAXON_REQUIRE_WELL_FORMED = "{http://saxon.sf.net/}require-well-formed";
    public static final String SAXON_SUPPRESS_INDENTATION = "{http://saxon.sf.net/}suppress-indentation";
    public static final String SAXON_MEMO_FUNCTION = "{http://saxon.sf.net/}memo-function";
    public static final int SAXON_JAVA_LANG_OBJECT = 285;
    public static final int XML_BASE = 385;
    public static final int XML_SPACE = 386;
    public static final int XML_LANG = 387;
    public static final int XML_ID = 388;
    public static final String ALPHANUMERIC = "alphanumeric";
    public static final String ARCHIVE = "archive";
    public static final String AS = "as";
    public static final String BYTE_ORDER_MARK = "byte-order-mark";
    public static final String CASE_ORDER = "case-order";
    public static final String CDATA_SECTION_ELEMENTS = "cdata-section-elements";
    public static final String CHARACTER = "character";
    public static final String CLASS = "class";
    public static final String COLLATION = "collation";
    public static final String COPY_NAMESPACES = "copy-namespaces";
    public static final String COUNT = "count";
    public static final String DATA_TYPE = "data-type";
    public static final String DECIMAL_SEPARATOR = "decimal-separator";
    public static final String DECOMPOSITION = "decomposition";
    public static final String DEFAULT = "default";
    public static final String DEFAULT_COLLATION = "default-collation";
    public static final String DEFAULT_VALIDATION = "default-validation";
    public static final String DIGIT = "digit";
    public static final String DISABLE_OUTPUT_ESCAPING = "disable-output-escaping";
    public static final String DOCTYPE_PUBLIC = "doctype-public";
    public static final String DOCTYPE_SYSTEM = "doctype-system";
    public static final String ELEMENTS = "elements";
    public static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    public static final String ENCODING = "encoding";
    public static final String EXCLUDE_RESULT_PREFIXES = "exclude-result-prefixes";
    public static final String EXTENSION_ELEMENT_PREFIXES = "extension-element-prefixes";
    public static final String FLAGS = "flags";
    public static final String FORMAT = "format";
    public static final String FROM = "from";
    public static final String GROUP_ADJACENT = "group-adjacent";
    public static final String GROUP_BY = "group-by";
    public static final String GROUP_ENDING_WITH = "group-ending-with";
    public static final String GROUP_STARTING_WITH = "group-starting-with";
    public static final String GROUPING_SEPARATOR = "grouping-separator";
    public static final String GROUPING_SIZE = "grouping-size";
    public static final String HREF = "href";
    public static final String ID = "id";
    public static final String IGNORE_CASE = "ignore-case";
    public static final String IGNORE_MODIFIERS = "ignore-modifiers";
    public static final String IGNORE_SYMBOLS = "ignore-symbols";
    public static final String IGNORE_WIDTH = "ignore-width";
    public static final String IMPLEMENTS_PREFIX = "implements-prefix";
    public static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    public static final String INDENT = "indent";
    public static final String INFINITY = "infinity";
    public static final String INHERIT_NAMESPACES = "inherit-namespaces";
    public static final String INPUT_TYPE_ANNOTATIONS = "input-type-annotations";
    public static final String LANG = "lang";
    public static final String LANGUAGE = "language";
    public static final String LETTER_VALUE = "letter-value";
    public static final String LEVEL = "level";
    public static final String MATCH = "match";
    public static final String MEDIA_TYPE = "media-type";
    public static final String METHOD = "method";
    public static final String MINUS_SIGN = "minus-sign";
    public static final String MODE = "mode";
    public static final String NAME = "name";
    public static final String NAMESPACE = "namespace";
    public static final String NAN = "NaN";
    public static final String NORMALIZATION_FORM = "normalization-form";
    public static final String OMIT_XML_DECLARATION = "omit-xml-declaration";
    public static final String ORDER = "order";
    public static final String ORDINAL = "ordinal";
    public static final String OUTPUT_VERSION = "output-version";
    public static final String OVERRIDE = "override";
    public static final String PATTERN_SEPARATOR = "pattern-separator";
    public static final String PERCENT = "percent";
    public static final String PER_MILLE = "per-mille";
    public static final String PRIORITY = "priority";
    public static final String REGEX = "regex";
    public static final String REQUIRED = "required";
    public static final String RESULT_PREFIX = "result-prefix";
    public static final String RULES = "rules";
    public static final String SCHEMA_LOCATION = "schema-location";
    public static final String SELECT = "select";
    public static final String SEPARATOR = "separator";
    public static final String SRC = "src";
    public static final String STABLE = "stable";
    public static final String STANDALONE = "standalone";
    public static final String STRENGTH = "strength";
    public static final String STRING = "string";
    public static final String STYLESHEET_PREFIX = "stylesheet-prefix";
    public static final String TERMINATE = "terminate";
    public static final String TEST = "test";
    public static final String TUNNEL = "tunnel";
    public static final String TYPE = "type";
    public static final String UNDECLARE_PREFIXES = "undeclare-prefixes";
    public static final String USE = "use";
    public static final String USE_ATTRIBUTE_SETS = "use-attribute-sets";
    public static final String USE_CHARACTER_MAPS = "use-character-maps";
    public static final String USE_WHEN = "use-when";
    public static final String VALIDATION = "validation";
    public static final String VALUE = "value";
    public static final String VERSION = "version";
    public static final String XPATH_DEFAULT_NAMESPACE = "xpath-default-namespace";
    public static final String ZERO_DIGIT = "zero-digit";
    public static final int XS_STRING = 513;
    public static final int XS_BOOLEAN = 514;
    public static final int XS_DECIMAL = 515;
    public static final int XS_FLOAT = 516;
    public static final int XS_DOUBLE = 517;
    public static final int XS_DURATION = 518;
    public static final int XS_DATE_TIME = 519;
    public static final int XS_TIME = 520;
    public static final int XS_DATE = 521;
    public static final int XS_G_YEAR_MONTH = 522;
    public static final int XS_G_YEAR = 523;
    public static final int XS_G_MONTH_DAY = 524;
    public static final int XS_G_DAY = 525;
    public static final int XS_G_MONTH = 526;
    public static final int XS_HEX_BINARY = 527;
    public static final int XS_BASE64_BINARY = 528;
    public static final int XS_ANY_URI = 529;
    public static final int XS_QNAME = 530;
    public static final int XS_NOTATION = 531;
    public static final int XS_INTEGER = 532;
    public static final int XS_NON_POSITIVE_INTEGER = 533;
    public static final int XS_NEGATIVE_INTEGER = 534;
    public static final int XS_LONG = 535;
    public static final int XS_INT = 536;
    public static final int XS_SHORT = 537;
    public static final int XS_BYTE = 538;
    public static final int XS_NON_NEGATIVE_INTEGER = 539;
    public static final int XS_POSITIVE_INTEGER = 540;
    public static final int XS_UNSIGNED_LONG = 541;
    public static final int XS_UNSIGNED_INT = 542;
    public static final int XS_UNSIGNED_SHORT = 543;
    public static final int XS_UNSIGNED_BYTE = 544;
    public static final int XS_NORMALIZED_STRING = 553;
    public static final int XS_TOKEN = 554;
    public static final int XS_LANGUAGE = 555;
    public static final int XS_NMTOKEN = 556;
    public static final int XS_NMTOKENS = 557;
    public static final int XS_NAME = 558;
    public static final int XS_NCNAME = 559;
    public static final int XS_ID = 560;
    public static final int XS_IDREF = 561;
    public static final int XS_IDREFS = 562;
    public static final int XS_ENTITY = 563;
    public static final int XS_ENTITIES = 564;
    public static final int XS_ANY_TYPE = 572;
    public static final int XS_ANY_SIMPLE_TYPE = 573;
    public static final int XS_INVALID_NAME = 574;
    public static final int XS_ALL = 582;
    public static final int XS_ANNOTATION = 583;
    public static final int XS_ANY = 584;
    public static final int XS_ANY_ATTRIBUTE = 585;
    public static final int XS_APPINFO = 586;
    public static final int XS_ATTRIBUTE = 587;
    public static final int XS_ATTRIBUTE_GROUP = 588;
    public static final int XS_CHOICE = 589;
    public static final int XS_COMPLEX_CONTENT = 592;
    public static final int XS_COMPLEX_TYPE = 593;
    public static final int XS_DOCUMENTATION = 594;
    public static final int XS_ELEMENT = 595;
    public static final int XS_ENUMERATION = 596;
    public static final int XS_EXTENSION = 597;
    public static final int XS_FIELD = 598;
    public static final int XS_FRACTION_DIGITS = 599;
    public static final int XS_GROUP = 600;
    public static final int XS_IMPORT = 602;
    public static final int XS_INCLUDE = 603;
    public static final int XS_KEY = 604;
    public static final int XS_KEYREF = 605;
    public static final int XS_LENGTH = 606;
    public static final int XS_LIST = 607;
    public static final int XS_MAX_EXCLUSIVE = 608;
    public static final int XS_MAX_INCLUSIVE = 609;
    public static final int XS_MAX_LENGTH = 612;
    public static final int XS_MIN_EXCLUSIVE = 613;
    public static final int XS_MIN_INCLUSIVE = 614;
    public static final int XS_MIN_LENGTH = 615;
    public static final int XS_notation = 616;
    public static final int XS_PATTERN = 617;
    public static final int XS_REDEFINE = 618;
    public static final int XS_RESTRICTION = 619;
    public static final int XS_SCHEMA = 620;
    public static final int XS_SELECTOR = 622;
    public static final int XS_SEQUENCE = 623;
    public static final int XS_SIMPLE_CONTENT = 624;
    public static final int XS_SIMPLE_TYPE = 625;
    public static final int XS_TOTAL_DIGITS = 626;
    public static final int XS_UNION = 627;
    public static final int XS_UNIQUE = 628;
    public static final int XS_WHITE_SPACE = 629;
    public static final int XS_UNTYPED = 630;
    public static final int XS_UNTYPED_ATOMIC = 631;
    public static final int XS_ANY_ATOMIC_TYPE = 632;
    public static final int XS_YEAR_MONTH_DURATION = 633;
    public static final int XS_DAY_TIME_DURATION = 634;
    public static final int XS_NUMERIC = 635;
    public static final int XS_ASSERT = 636;
    public static final int XS_ALTERNATIVE = 637;
    public static final int XSI_TYPE = 641;
    public static final int XSI_NIL = 642;
    public static final int XSI_SCHEMA_LOCATION = 643;
    public static final int XSI_NO_NAMESPACE_SCHEMA_LOCATION = 644;
    public static final int XSI_SCHEMA_LOCATION_TYPE = 645;
    public static final int SCM_SCHEMA = 769;
    public static final int SCM_ELEMENT_DECLARATION = 770;
    public static final int SCM_ATTRIBUTE_DECLARATION = 771;
    public static final int SCM_COMPLEX_TYPE_DEFINITION = 772;
    public static final int SCM_SIMPLE_TYPE_DEFINITION = 773;
    public static final int SCM_ATTRIBUTE_GROUP_DECLARATION = 774;
    public static final int SCM_MODEL_GROUP_DECLARATION = 775;
    public static final int SCM_NOTATION_DECLARATION = 770;
    public static final int SCM_ANNOTATION = 770;
    public static final int SCM_NAME = 770;
    public static final int SCM_TARGET_NAMESPACE = 770;
    private static String[] localNames = new String[1023];
    private static HashMap lookup = new HashMap(1023);

    private StandardNames() {
    }

    private static void bindXSLTName(int constant, String localName) {
        StandardNames.localNames[constant] = localName;
        lookup.put(XSL_B + localName, new Integer(constant));
    }

    private static void bindSaxonName(int constant, String localName) {
        StandardNames.localNames[constant] = localName;
        lookup.put(SAXON_B + localName, new Integer(constant));
    }

    private static void bindXMLName(int constant, String localName) {
        StandardNames.localNames[constant] = localName;
        lookup.put("{http://www.w3.org/XML/1998/namespace}" + localName, new Integer(constant));
    }

    private static void bindXSName(int constant, String localName) {
        StandardNames.localNames[constant] = localName;
        lookup.put("{http://www.w3.org/2001/XMLSchema}" + localName, new Integer(constant));
    }

    private static void bindXSIName(int constant, String localName) {
        StandardNames.localNames[constant] = localName;
        lookup.put("{http://www.w3.org/2001/XMLSchema-instance}" + localName, new Integer(constant));
    }

    public static int getFingerprint(String uri, String localName) {
        Integer fp = (Integer)lookup.get('{' + uri + '}' + localName);
        if (fp == null) {
            return -1;
        }
        return fp;
    }

    public static String getLocalName(int fingerprint) {
        return localNames[fingerprint];
    }

    public static String getURI(int fingerprint) {
        int c = fingerprint >> 7;
        switch (c) {
            case 0: {
                return "";
            }
            case 1: {
                return "http://www.w3.org/1999/XSL/Transform";
            }
            case 2: {
                return "http://saxon.sf.net/";
            }
            case 3: {
                return "http://www.w3.org/XML/1998/namespace";
            }
            case 4: {
                return "http://www.w3.org/2001/XMLSchema";
            }
            case 5: {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            case 6: {
                return "http://ns.saxonica.com/schema-component-model";
            }
        }
        return null;
    }

    public static short getURICode(int fingerprint) {
        int c = fingerprint >> 7;
        switch (c) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
        }
        return -1;
    }

    public static String getClarkName(int fingerprint) {
        String uri = StandardNames.getURI(fingerprint);
        if (uri.length() == 0) {
            return StandardNames.getLocalName(fingerprint);
        }
        return '{' + uri + '}' + StandardNames.getLocalName(fingerprint);
    }

    public static String getPrefix(int fingerprint) {
        int c = fingerprint >> 7;
        switch (c) {
            case 0: {
                return "";
            }
            case 1: {
                return "xsl";
            }
            case 2: {
                return "saxon";
            }
            case 3: {
                return "xml";
            }
            case 4: {
                return "xs";
            }
            case 5: {
                return "xsi";
            }
        }
        return null;
    }

    public static String getDisplayName(int fingerprint) {
        if (fingerprint == -1) {
            return "(anonymous type)";
        }
        if (fingerprint > 1023) {
            return "(" + fingerprint + ')';
        }
        if (fingerprint >> 7 == 0) {
            return StandardNames.getLocalName(fingerprint);
        }
        return StandardNames.getPrefix(fingerprint) + ':' + StandardNames.getLocalName(fingerprint);
    }

    public static StructuredQName getStructuredQName(int fingerprint) {
        return new StructuredQName(StandardNames.getPrefix(fingerprint), StandardNames.getURI(fingerprint), StandardNames.getLocalName(fingerprint));
    }

    static {
        StandardNames.bindXSLTName(128, "analyze-string");
        StandardNames.bindXSLTName(129, "apply-imports");
        StandardNames.bindXSLTName(130, "apply-templates");
        StandardNames.bindXSLTName(131, "attribute");
        StandardNames.bindXSLTName(132, "attribute-set");
        StandardNames.bindXSLTName(133, "call-template");
        StandardNames.bindXSLTName(134, "character-map");
        StandardNames.bindXSLTName(135, "choose");
        StandardNames.bindXSLTName(138, "comment");
        StandardNames.bindXSLTName(139, "copy");
        StandardNames.bindXSLTName(140, "copy-of");
        StandardNames.bindXSLTName(141, "decimal-format");
        StandardNames.bindXSLTName(142, "document");
        StandardNames.bindXSLTName(143, "element");
        StandardNames.bindXSLTName(144, "fallback");
        StandardNames.bindXSLTName(145, "for-each");
        StandardNames.bindXSLTName(148, "for-each-group");
        StandardNames.bindXSLTName(149, "function");
        StandardNames.bindXSLTName(150, "if");
        StandardNames.bindXSLTName(151, "import");
        StandardNames.bindXSLTName(152, "import-schema");
        StandardNames.bindXSLTName(153, "include");
        StandardNames.bindXSLTName(154, "key");
        StandardNames.bindXSLTName(155, "matching-substring");
        StandardNames.bindXSLTName(158, "message");
        StandardNames.bindXSLTName(159, "next-match");
        StandardNames.bindXSLTName(160, "number");
        StandardNames.bindXSLTName(161, NAMESPACE);
        StandardNames.bindXSLTName(162, "namespace-alias");
        StandardNames.bindXSLTName(163, "non-matching-substring");
        StandardNames.bindXSLTName(164, "otherwise");
        StandardNames.bindXSLTName(165, "output");
        StandardNames.bindXSLTName(169, "output-character");
        StandardNames.bindXSLTName(170, "param");
        StandardNames.bindXSLTName(171, "perform-sort");
        StandardNames.bindXSLTName(172, "preserve-space");
        StandardNames.bindXSLTName(173, "processing-instruction");
        StandardNames.bindXSLTName(174, "result-document");
        StandardNames.bindXSLTName(175, "sequence");
        StandardNames.bindXSLTName(178, "sort");
        StandardNames.bindXSLTName(179, "strip-space");
        StandardNames.bindXSLTName(180, "stylesheet");
        StandardNames.bindXSLTName(181, "template");
        StandardNames.bindXSLTName(182, "text");
        StandardNames.bindXSLTName(183, "transform");
        StandardNames.bindXSLTName(184, "value-of");
        StandardNames.bindXSLTName(185, "variable");
        StandardNames.bindXSLTName(188, "with-param");
        StandardNames.bindXSLTName(189, "when");
        StandardNames.bindXSLTName(228, DEFAULT_COLLATION);
        StandardNames.bindXSLTName(237, XPATH_DEFAULT_NAMESPACE);
        StandardNames.bindXSLTName(229, EXCLUDE_RESULT_PREFIXES);
        StandardNames.bindXSLTName(230, EXTENSION_ELEMENT_PREFIXES);
        StandardNames.bindXSLTName(231, INHERIT_NAMESPACES);
        StandardNames.bindXSLTName(232, TYPE);
        StandardNames.bindXSLTName(233, USE_ATTRIBUTE_SETS);
        StandardNames.bindXSLTName(234, USE_WHEN);
        StandardNames.bindXSLTName(235, VALIDATION);
        StandardNames.bindXSLTName(236, VERSION);
        StandardNames.bindSaxonName(257, "assign");
        StandardNames.bindSaxonName(258, "break");
        StandardNames.bindSaxonName(259, "call-template");
        StandardNames.bindSaxonName(260, COLLATION);
        StandardNames.bindSaxonName(261, "continue");
        StandardNames.bindSaxonName(262, "doctype");
        StandardNames.bindSaxonName(263, "entity-ref");
        StandardNames.bindSaxonName(264, "finally");
        StandardNames.bindSaxonName(265, "import-query");
        StandardNames.bindSaxonName(266, "iterate");
        StandardNames.bindSaxonName(267, "script");
        StandardNames.bindSaxonName(268, "while");
        StandardNames.bindXMLName(385, "base");
        StandardNames.bindXMLName(386, "space");
        StandardNames.bindXMLName(387, LANG);
        StandardNames.bindXMLName(388, ID);
        StandardNames.bindXSName(513, STRING);
        StandardNames.bindXSName(514, "boolean");
        StandardNames.bindXSName(515, "decimal");
        StandardNames.bindXSName(516, "float");
        StandardNames.bindXSName(517, "double");
        StandardNames.bindXSName(518, "duration");
        StandardNames.bindXSName(519, "dateTime");
        StandardNames.bindXSName(520, "time");
        StandardNames.bindXSName(521, "date");
        StandardNames.bindXSName(522, "gYearMonth");
        StandardNames.bindXSName(523, "gYear");
        StandardNames.bindXSName(524, "gMonthDay");
        StandardNames.bindXSName(525, "gDay");
        StandardNames.bindXSName(526, "gMonth");
        StandardNames.bindXSName(527, "hexBinary");
        StandardNames.bindXSName(528, "base64Binary");
        StandardNames.bindXSName(529, "anyURI");
        StandardNames.bindXSName(530, "QName");
        StandardNames.bindXSName(531, "NOTATION");
        StandardNames.bindXSName(532, "integer");
        StandardNames.bindXSName(533, "nonPositiveInteger");
        StandardNames.bindXSName(534, "negativeInteger");
        StandardNames.bindXSName(535, "long");
        StandardNames.bindXSName(536, "int");
        StandardNames.bindXSName(537, "short");
        StandardNames.bindXSName(538, "byte");
        StandardNames.bindXSName(539, "nonNegativeInteger");
        StandardNames.bindXSName(540, "positiveInteger");
        StandardNames.bindXSName(541, "unsignedLong");
        StandardNames.bindXSName(542, "unsignedInt");
        StandardNames.bindXSName(543, "unsignedShort");
        StandardNames.bindXSName(544, "unsignedByte");
        StandardNames.bindXSName(553, "normalizedString");
        StandardNames.bindXSName(554, "token");
        StandardNames.bindXSName(555, LANGUAGE);
        StandardNames.bindXSName(556, "NMTOKEN");
        StandardNames.bindXSName(557, "NMTOKENS");
        StandardNames.bindXSName(558, "Name");
        StandardNames.bindXSName(559, "NCName");
        StandardNames.bindXSName(560, "ID");
        StandardNames.bindXSName(561, "IDREF");
        StandardNames.bindXSName(562, "IDREFS");
        StandardNames.bindXSName(563, "ENTITY");
        StandardNames.bindXSName(564, "ENTITIES");
        StandardNames.bindXSName(572, "anyType");
        StandardNames.bindXSName(573, "anySimpleType");
        StandardNames.bindXSName(574, "invalidName");
        StandardNames.bindXSName(582, "all");
        StandardNames.bindXSName(637, "alternative");
        StandardNames.bindXSName(583, "annotation");
        StandardNames.bindXSName(584, "any");
        StandardNames.bindXSName(585, "anyAttribute");
        StandardNames.bindXSName(586, "appinfo");
        StandardNames.bindXSName(636, "assert");
        StandardNames.bindXSName(587, "attribute");
        StandardNames.bindXSName(588, "attributeGroup");
        StandardNames.bindXSName(589, "choice");
        StandardNames.bindXSName(592, "complexContent");
        StandardNames.bindXSName(593, "complexType");
        StandardNames.bindXSName(594, "documentation");
        StandardNames.bindXSName(595, "element");
        StandardNames.bindXSName(596, "enumeration");
        StandardNames.bindXSName(597, "extension");
        StandardNames.bindXSName(598, "field");
        StandardNames.bindXSName(599, "fractionDigits");
        StandardNames.bindXSName(600, "group");
        StandardNames.bindXSName(602, "import");
        StandardNames.bindXSName(603, "include");
        StandardNames.bindXSName(604, "key");
        StandardNames.bindXSName(605, "keyref");
        StandardNames.bindXSName(606, "length");
        StandardNames.bindXSName(607, "list");
        StandardNames.bindXSName(608, "maxExclusive");
        StandardNames.bindXSName(609, "maxInclusive");
        StandardNames.bindXSName(612, "maxLength");
        StandardNames.bindXSName(613, "minExclusive");
        StandardNames.bindXSName(614, "minInclusive");
        StandardNames.bindXSName(615, "minLength");
        StandardNames.bindXSName(616, "notation");
        StandardNames.bindXSName(617, "pattern");
        StandardNames.bindXSName(618, "redefine");
        StandardNames.bindXSName(619, "restriction");
        StandardNames.bindXSName(620, "schema");
        StandardNames.bindXSName(622, "selector");
        StandardNames.bindXSName(623, "sequence");
        StandardNames.bindXSName(624, "simpleContent");
        StandardNames.bindXSName(625, "simpleType");
        StandardNames.bindXSName(626, "totalDigits");
        StandardNames.bindXSName(627, "union");
        StandardNames.bindXSName(628, "unique");
        StandardNames.bindXSName(629, "whiteSpace");
        StandardNames.bindXSName(630, "untyped");
        StandardNames.bindXSName(631, "untypedAtomic");
        StandardNames.bindXSName(632, "anyAtomicType");
        StandardNames.bindXSName(633, "yearMonthDuration");
        StandardNames.bindXSName(634, "dayTimeDuration");
        StandardNames.bindXSName(635, "_numeric_");
        StandardNames.bindXSIName(641, TYPE);
        StandardNames.bindXSIName(642, "nil");
        StandardNames.bindXSIName(643, "schemaLocation");
        StandardNames.bindXSIName(644, "noNamespaceSchemaLocation");
        StandardNames.bindXSIName(645, "anonymous_schemaLocationType");
    }
}

