/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.atrules.css3.media;

import org.w3c.css.atrules.css.media.MediaFeature;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class MediaGrid
extends MediaFeature {
    public MediaGrid() {
    }

    public MediaGrid(ApplContext ac, String modifier, CssExpression expression, boolean check2) throws InvalidParamException {
        if (modifier != null) {
            throw new InvalidParamException("nomodifiermedia", this.getFeatureName(), ac);
        }
        if (expression != null) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (expression.getCount() == 0) {
                throw new InvalidParamException("few-value", this.getFeatureName(), ac);
            }
            CssValue val = expression.getValue();
            if (val.getType() == 5) {
                val.getCheckableValue().checkInteger(ac, this);
                CssNumber valnum = (CssNumber)val;
                int gridval = valnum.getInt();
                if (gridval != 0 && gridval != 1) {
                    throw new InvalidParamException("grid", val.toString(), ac);
                }
                this.value = valnum;
            } else {
                throw new InvalidParamException("unrecognize", ac);
            }
        }
    }

    @Override
    public void setModifier(ApplContext ac, String modifier) throws InvalidParamException {
        throw new InvalidParamException("nomodifiermedia", this.getFeatureName(), ac);
    }

    public MediaGrid(ApplContext ac, String modifier, CssExpression expression) throws InvalidParamException {
        this(ac, modifier, expression, false);
    }

    public Object get() {
        return this.value;
    }

    @Override
    public final String getFeatureName() {
        return "grid";
    }

    @Override
    public boolean equals(MediaFeature other) {
        try {
            MediaGrid mg = (MediaGrid)other;
            return (this.value == null && mg.value == null || this.value != null && this.value.equals(mg.value)) && (this.modifier == null && mg.modifier == null || this.modifier != null && this.modifier.equals(mg.modifier));
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

